/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.view.swing.modules;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TableModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class ResizableTable
extends JTable
implements ComponentListener {
    public static final int COL_FIXED_WIDTH = 1;
    private static final int FIX_COLUMNS = 1;
    private static final int NONFIX_COLUMNS = 2;
    private static final int ALL_COLUMNS = 3;
    private static Cursor rowResizeCursor = Cursor.getPredefinedCursor(8);
    private static Cursor columnResizeCursor = Cursor.getPredefinedCursor(11);
    private Cursor nonResizeCursor = null;
    private boolean resizingAColumn = false;
    private boolean resizingARow = false;
    private int[] columnFlags = new int[1];
    private int[] defaultColumnWidths = new int[1];
    private int defaultColumnWidth = 75;
    private JScrollPane scrollPane = null;
    private int scrollPaneWidth = 0;
    private ColumnResizer columnResizer;
    private boolean defaultColumnWidthsSet = false;

    public ResizableTable(TableModel dm) {
        super(dm);
        this.nonResizeCursor = this.getCursor();
        new RowResizer();
        this.columnResizer = new ColumnResizer();
        this.setShowGrid(false);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent ev) {
                if (ev.getSource() != ResizableTable.this || ResizableTable.this.defaultColumnWidthsSet) {
                    return;
                }
                ResizableTable.this.defaultColumnWidthsSet = true;
                TableColumnModel tcm = ResizableTable.this.getColumnModel();
                for (int col = 0; col < tcm.getColumnCount(); ++col) {
                    TableColumn tc = tcm.getColumn(col);
                    int w = ResizableTable.this.getDefaultColumnWidth(col);
                    if (w == 0) continue;
                    tc.setWidth(w);
                    tc.setPreferredWidth(w);
                }
            }
        });
    }

    public int getColumnFlags(int col) {
        return col < this.columnFlags.length ? this.columnFlags[col] : 0;
    }

    public void setColumnFlags(int col, int f) {
        if (col >= this.columnFlags.length) {
            int[] tmp = new int[col + 1];
            System.arraycopy(this.columnFlags, 0, tmp, 0, this.columnFlags.length);
            this.columnFlags = tmp;
        }
        this.columnFlags[col] = f;
    }

    public int getDefaultColumnWidth(int col) {
        int w = col < this.defaultColumnWidths.length ? this.defaultColumnWidths[col] : -1;
        return w > 0 ? w : this.defaultColumnWidth;
    }

    public void setDefaultColumnWidth(int col, int w) {
        if (col >= this.defaultColumnWidths.length) {
            int[] tmp = new int[col + 1];
            System.arraycopy(this.defaultColumnWidths, 0, tmp, 0, this.defaultColumnWidths.length);
            this.defaultColumnWidths = tmp;
        }
        this.defaultColumnWidths[col] = w;
    }

    public void setDefaultColumnWidth(int w) {
        this.defaultColumnWidth = w;
    }

    public int getPreferredColumnWidth(int col) {
        int totalw = this.getVisibleWidth();
        if ((this.getColumnFlags(col) & 1) != 0) {
            int w = this.getDefaultColumnWidth(col);
            return w;
        }
        int width_to_fill = totalw - this.calcRowWidth(1);
        int nonfixw = this.calcRowWidth(2);
        int w = this.getDefaultColumnWidth(col);
        if (width_to_fill <= nonfixw) {
            return w;
        }
        int w2 = (w * width_to_fill + nonfixw - 1) / nonfixw;
        return w2;
    }

    public int getPreferredHorizontalScrollUnitIncrement() {
        int ncols = this.getColumnModel().getColumnCount();
        int minw = Integer.MAX_VALUE;
        for (int i = 0; i < ncols; ++i) {
            int w = this.getDefaultColumnWidth(i);
            if (w >= minw || w <= 0) continue;
            minw = w;
        }
        return minw;
    }

    public void setJScrollPane(JScrollPane pane) {
        if (this.scrollPane != null) {
            this.scrollPane.removeComponentListener(this);
        }
        this.scrollPane = pane;
        if (pane != null) {
            pane.addComponentListener(this);
            this.scrollPaneWidth = pane.getSize().width;
        }
    }

    @Override
    public void doLayout() {
        LayoutManager l = this.getLayout();
        if (l != null) {
            l.layoutContainer(this);
        }
    }

    @Override
    public void createDefaultColumnsFromModel() {
        super.createDefaultColumnsFromModel();
        Dimension sz = this.getSize();
        if (sz.width != 0) {
            this.sizeColumns(3);
        }
    }

    @Override
    public void tableChanged(TableModelEvent ev) {
        ListSelectionModel sm = this.getSelectionModel();
        ListSelectionModel tcmsm = this.getColumnModel().getSelectionModel();
        int tcmAnchorIndex = tcmsm.getAnchorSelectionIndex();
        int tcmLeadIndex = tcmsm.getLeadSelectionIndex();
        int tcmMinSelIndex = tcmsm.getMinSelectionIndex();
        int tcmMaxSelIndex = tcmsm.getMaxSelectionIndex();
        int anchorIndex = sm.getAnchorSelectionIndex();
        int leadIndex = sm.getLeadSelectionIndex();
        int minSelIndex = sm.getMinSelectionIndex();
        int maxSelIndex = sm.getMaxSelectionIndex();
        super.tableChanged(ev);
        sm.setAnchorSelectionIndex(anchorIndex);
        sm.setLeadSelectionIndex(leadIndex);
        sm.setSelectionInterval(minSelIndex, maxSelIndex);
        tcmsm.setAnchorSelectionIndex(anchorIndex);
        tcmsm.setLeadSelectionIndex(leadIndex);
        tcmsm.setSelectionInterval(tcmMinSelIndex, tcmMaxSelIndex);
    }

    void cancelEditing() {
        TableColumnModel tcmodel = this.getColumnModel();
        for (int i = 0; i < tcmodel.getColumnCount(); ++i) {
            TableColumn tc = tcmodel.getColumn(i);
            TableCellEditor tced = tc.getCellEditor();
            if (tced == null) continue;
            tced.cancelCellEditing();
        }
    }

    private void sizeColumns(int colflags) {
        int visibleWidth = this.getVisibleWidth();
        TableColumnModel tcmodel = this.getColumnModel();
        int ncols = tcmodel.getColumnCount();
        boolean rescale = ncols == 1 || this.calcRowWidth(3) < visibleWidth;
        for (int col = 0; col < ncols; ++col) {
            boolean fix;
            boolean bl = fix = (this.getColumnFlags(col) & 1) != 0;
            if ((!fix || (colflags & 1) == 0) && (fix || (colflags & 2) == 0)) continue;
            TableColumn tc = tcmodel.getColumn(col);
            int w = rescale ? this.getPreferredColumnWidth(col) : this.getDefaultColumnWidth(col);
            tc.setWidth(w);
            tc.setPreferredWidth(w);
        }
    }

    private int getVisibleWidth() {
        if (this.scrollPane != null) {
            Rectangle r = this.scrollPane.getViewportBorderBounds();
            return r.width;
        }
        Dimension d = this.getSize();
        return d.width;
    }

    private int getVisibleHeight() {
        if (this.scrollPane != null) {
            Rectangle r = this.scrollPane.getViewportBorderBounds();
            return r.height;
        }
        Dimension d = this.getSize();
        return d.height;
    }

    private int calcRowWidth(int colflags) {
        int ncols = this.getColumnModel().getColumnCount();
        int totalw = 0;
        for (int i = 0; i < ncols; ++i) {
            boolean fix;
            boolean bl = fix = (this.getColumnFlags(i) & 1) != 0;
            if ((!fix || (colflags & 1) == 0) && (fix || (colflags & 2) == 0)) continue;
            totalw += this.getDefaultColumnWidth(i);
        }
        return totalw;
    }

    @Override
    public void setCursor(Cursor c) {
        super.setCursor(c);
        if (c != rowResizeCursor && c != columnResizeCursor) {
            this.nonResizeCursor = c;
        }
    }

    private int columnAtPoint2(Point p) {
        int i = super.columnAtPoint(p);
        if (i == -1 && p.x > 0 && p.y > 0 && p.y < this.getHeight()) {
            i = this.getColumnCount();
        }
        return i;
    }

    int getTopRow() {
        JScrollBar bar;
        JScrollPane pane = this.scrollPane;
        JScrollBar jScrollBar = bar = pane != null ? pane.getVerticalScrollBar() : null;
        if (bar != null) {
            int unit = this.getRowHeight();
            return bar.getValue() / unit;
        }
        return 0;
    }

    void setTopRow(int row) {
        JScrollBar bar;
        JScrollPane pane = this.scrollPane;
        JScrollBar jScrollBar = bar = pane != null ? pane.getVerticalScrollBar() : null;
        if (bar != null) {
            int unit = this.getRowHeight();
            int y = row * unit;
            if (bar.isValid()) {
                bar.setValue(y);
            } else {
                final int yy = y;
                bar.addComponentListener(new ComponentAdapter(){

                    @Override
                    public void componentResized(ComponentEvent e) {
                        bar.removeComponentListener(this);
                        bar.setValue(yy);
                    }
                });
            }
        }
    }

    int getBottomRow() {
        JScrollBar bar;
        JScrollPane pane = this.scrollPane;
        JScrollBar jScrollBar = bar = pane != null ? pane.getVerticalScrollBar() : null;
        if (bar != null) {
            int h = this.getVisibleHeight();
            int unit = this.getRowHeight();
            return (bar.getValue() + h + unit - 1) / unit;
        }
        return this.getRowCount() - 1;
    }

    void setBottomRow(int row) {
        JScrollBar bar;
        JScrollPane pane = this.scrollPane;
        JScrollBar jScrollBar = bar = pane != null ? pane.getVerticalScrollBar() : null;
        if (bar != null) {
            int h;
            int unit = this.getRowHeight();
            int y = (row + 1) * unit - (h = this.getVisibleHeight());
            if (y < 0) {
                y = 0;
            }
            if (bar.isValid()) {
                bar.setValue(y);
            } else {
                final int yy = y;
                bar.addComponentListener(new ComponentAdapter(){

                    @Override
                    public void componentResized(ComponentEvent e) {
                        bar.removeComponentListener(this);
                        bar.setValue(yy);
                    }
                });
            }
        }
    }

    int getLeftColumn() {
        JScrollBar bar;
        JScrollPane pane = this.scrollPane;
        JScrollBar jScrollBar = bar = pane != null ? pane.getHorizontalScrollBar() : null;
        if (bar != null) {
            int x = bar.getValue();
            TableColumnModel tcm = this.getColumnModel();
            int ncols = tcm.getColumnCount();
            int x0 = 0;
            for (int i = 0; i < ncols; ++i) {
                TableColumn tc = tcm.getColumn(i);
                int x1 = x0 + tc.getWidth();
                if (x < (x0 + x1) / 2) {
                    if (x >= x0) {
                        return i;
                    }
                } else if (x < x1) {
                    return i + 1;
                }
                x0 = x1;
            }
        }
        return 0;
    }

    void setLeftColumn(int col) {
        JScrollBar bar;
        JScrollPane pane = this.scrollPane;
        JScrollBar jScrollBar = bar = pane != null ? pane.getHorizontalScrollBar() : null;
        if (bar != null) {
            TableColumnModel tcm = this.getColumnModel();
            int x = 0;
            for (int i = 0; i < col; ++i) {
                TableColumn tc = tcm.getColumn(i);
                x += tc.getWidth();
            }
            if (bar.isValid()) {
                bar.setValue(x);
            } else {
                final int xx = x;
                bar.addComponentListener(new ComponentAdapter(){

                    @Override
                    public void componentResized(ComponentEvent e) {
                        bar.removeComponentListener(this);
                        bar.setValue(xx);
                    }
                });
            }
        }
    }

    @Override
    public void changeSelection(int row, int col, boolean toggle, boolean extend) {
        if (!this.resizingARow && !this.resizingAColumn) {
            super.changeSelection(row, col, toggle, extend);
            int rows = this.getRowCount();
            if (row >= rows) {
                super.changeSelection(rows - 1, col, toggle, extend);
                JScrollBar bar = this.scrollPane.getVerticalScrollBar();
                if (bar != null) {
                    int vscrH = bar.getVisibleAmount();
                    int vscrMax = bar.getMaximum() - vscrH;
                    bar.setValue(vscrMax);
                }
            }
        }
    }

    @Override
    public boolean editCellAt(int row, int col, EventObject e) {
        return !this.resizingARow && !this.resizingAColumn && super.editCellAt(row, col, e);
    }

    @Override
    public void componentResized(ComponentEvent ev) {
        int w;
        int n = w = this.scrollPane != null ? this.scrollPane.getSize().width : 0;
        if (ev.getSource() == this.scrollPane && w != this.scrollPaneWidth) {
            this.sizeColumns(this.scrollPaneWidth == 0 ? 3 : 2);
            this.scrollPaneWidth = w;
        }
    }

    @Override
    public void componentMoved(ComponentEvent ev) {
    }

    @Override
    public void componentShown(ComponentEvent ev) {
    }

    @Override
    public void componentHidden(ComponentEvent ev) {
    }

    private MouseEvent retargetEvent(MouseEvent e, ResizableTable t, Point loc) {
        return new MouseEvent(t, e.getID(), e.getWhen(), e.getModifiers(), e.getX() - loc.x, e.getY() - loc.y, e.getClickCount(), e.isPopupTrigger(), e.getButton());
    }

    private ResizableTable getLeftResizableTable(Point loc) {
        Container cont;
        int i;
        Container scrp = this.getParent().getParent();
        if (!(scrp instanceof JScrollPane)) {
            return null;
        }
        Container panel = scrp.getParent();
        if (panel == null) {
            return null;
        }
        loc.x -= scrp.getX() + this.getParent().getX() + this.getX();
        loc.y -= scrp.getY() + this.getParent().getY() + this.getY();
        for (i = panel.getComponentCount() - 1; i >= 0 && panel.getComponent(i) != scrp; --i) {
        }
        if (i <= 0) {
            return null;
        }
        Component c = panel.getComponent(i - 1);
        if (!(c instanceof JScrollPane)) {
            return null;
        }
        scrp = (Container)c;
        c = scrp.getComponent(0);
        loc.x += scrp.getX() + c.getX();
        loc.y += scrp.getY() + c.getY();
        if (c instanceof Container && (cont = (Container)c).getComponentCount() != 0) {
            c = ((Container)c).getComponent(0);
            loc.x += c.getX();
            loc.y += c.getY();
        }
        return c instanceof ResizableTable ? (ResizableTable)c : null;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (this.getRowCount() <= 0 || this.getColumnCount() <= 0) {
            super.paintComponent(graphics);
            return;
        }
        Rectangle r = this.getCellRect(this.getRowCount() - 1, this.getColumnCount() - 1, true);
        Rectangle size = new Rectangle(0, 0, r.x + r.width, r.y + r.height);
        Rectangle currentClip = graphics.getClipBounds();
        Rectangle newClip = currentClip.intersection(size);
        Graphics g = graphics.create();
        if (!currentClip.equals(newClip)) {
            if (this.isOpaque()) {
                g.setColor(this.getBackground());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            g.setClip(newClip);
        }
        super.paintComponent(g);
        g.dispose();
    }

    private class RowResizer
    extends MouseInputAdapter {
        private int origRowHeight;
        private int mouseYOffset;
        private int resizingRow;
        private int lastRowHeightValue = 0;

        public RowResizer() {
            ResizableTable.this.addMouseListener(this);
            ResizableTable.this.addMouseMotionListener(this);
        }

        private int getResizingRow(Point p) {
            return this.getResizingRow(p, ResizableTable.this.rowAtPoint(p));
        }

        private int getResizingRow(Point p, int row) {
            if (row == -1) {
                return -1;
            }
            int col = ResizableTable.this.columnAtPoint(p);
            if (col == -1) {
                return -1;
            }
            Rectangle r = ResizableTable.this.getCellRect(row, col, true);
            r.grow(0, -3);
            if (r.contains(p)) {
                return -1;
            }
            int midPoint = r.y + r.height / 2;
            int rowIndex = p.y < midPoint ? row - 1 : row;
            return rowIndex;
        }

        @Override
        public void mousePressed(MouseEvent ev) {
            Point p = ev.getPoint();
            this.resizingRow = this.getResizingRow(p);
            this.origRowHeight = ResizableTable.this.getRowHeight(this.resizingRow);
            this.mouseYOffset = p.y;
        }

        @Override
        public void mouseMoved(MouseEvent ev) {
            int row = this.getResizingRow(ev.getPoint());
            if (row >= 0 && !ResizableTable.this.resizingARow) {
                ResizableTable.this.resizingARow = true;
                ResizableTable.this.setCursor(rowResizeCursor);
            } else if (row < 0 && ResizableTable.this.resizingARow) {
                ResizableTable.this.resizingARow = false;
                ResizableTable.this.setCursor(ResizableTable.this.nonResizeCursor);
            }
        }

        @Override
        public void mouseDragged(MouseEvent ev) {
            int delta;
            int newHeight;
            int mouseY = ev.getY();
            int row = this.resizingRow;
            if (row >= 0 && (newHeight = this.origRowHeight + (delta = mouseY - this.mouseYOffset)) > 0) {
                ResizableTable.this.setRowHeight(row, newHeight);
                this.lastRowHeightValue = newHeight;
            }
        }

        @Override
        public void mouseReleased(MouseEvent ev) {
            int row = this.resizingRow;
            if (row >= 0) {
                int topRow = ResizableTable.this.getTopRow();
                int h0 = ResizableTable.this.getRowHeight();
                int h = this.lastRowHeightValue;
                if (h < 1) {
                    return;
                }
                ResizableTable.this.setRowHeight(h);
                int delta0 = row + 1 - topRow;
                int y0 = delta0 * h0;
                int delta = y0 / h;
                int newTopRow = delta > 0 ? row - delta : topRow;
                ResizableTable.this.setTopRow(newTopRow);
            }
        }
    }

    public class ColumnResizer
    extends MouseInputAdapter {
        private int mouseXOffset;

        public ColumnResizer() {
            ResizableTable.this.addMouseListener(this);
            ResizableTable.this.addMouseMotionListener(this);
        }

        private boolean canResize(TableColumn column) {
            return column != null && ResizableTable.this.getTableHeader().getResizingAllowed() && column.getResizable();
        }

        private int getResizingColumnIndex(Point p) {
            return this.getResizingColumnIndex(p, ResizableTable.this.columnAtPoint2(p));
        }

        private int getResizingColumnIndex(Point p, int column) {
            if (column == -1) {
                return Integer.MIN_VALUE;
            }
            int row = ResizableTable.this.rowAtPoint(p);
            if (row == -1) {
                return Integer.MIN_VALUE;
            }
            Rectangle r = ResizableTable.this.getCellRect(row, column, true);
            r.grow(-3, 0);
            if (r.contains(p)) {
                return Integer.MIN_VALUE;
            }
            int midPoint = r.x + r.width / 2;
            JTableHeader h = ResizableTable.this.getTableHeader();
            int columnIndex = h.getComponentOrientation().isLeftToRight() ? (p.x < midPoint ? column - 1 : column) : (p.x < midPoint ? column : column - 1);
            return columnIndex;
        }

        @Override
        public void mousePressed(MouseEvent ev) {
            int rescol;
            JTableHeader h = ResizableTable.this.getTableHeader();
            h.setDraggedColumn(null);
            h.setResizingColumn(null);
            h.setDraggedDistance(0);
            Point p = ev.getPoint();
            int index = ResizableTable.this.columnAtPoint2(p);
            if (index == -1) {
                return;
            }
            if (index == ResizableTable.this.getColumnCount()) {
                index = ResizableTable.this.getColumnCount() - 1;
            }
            if ((rescol = this.getResizingColumnIndex(p, index)) < 0) {
                Point loc;
                ResizableTable t;
                if (rescol == -1 && (t = ResizableTable.this.getLeftResizableTable(loc = new Point(0, 0))) != null) {
                    MouseEvent ev2 = ResizableTable.this.retargetEvent(ev, t, loc);
                    t.columnResizer.mousePressed(ev2);
                }
                return;
            }
            TableColumn restc = h.getColumnModel().getColumn(rescol);
            if (!this.canResize(restc)) {
                return;
            }
            h.setResizingColumn(restc);
            int w = restc.getWidth();
            this.mouseXOffset = h.getComponentOrientation().isLeftToRight() ? p.x - w : p.x + w;
        }

        @Override
        public void mouseMoved(MouseEvent ev) {
            int i = this.getResizingColumnIndex(ev.getPoint());
            if (i >= ResizableTable.this.getColumnCount()) {
                if (ResizableTable.this.resizingAColumn) {
                    ResizableTable.this.resizingAColumn = false;
                    ResizableTable.this.setCursor(ResizableTable.this.nonResizeCursor);
                }
            } else if (i >= 0) {
                JTableHeader h = ResizableTable.this.getTableHeader();
                TableColumn tc = h.getColumnModel().getColumn(i);
                if (!ResizableTable.this.resizingAColumn) {
                    ResizableTable.this.resizingAColumn = true;
                    ResizableTable.this.setCursor(columnResizeCursor);
                }
            } else if (i == -1) {
                Point loc = new Point(0, 0);
                ResizableTable t = ResizableTable.this.getLeftResizableTable(loc);
                if (t != null) {
                    MouseEvent ev2 = ResizableTable.this.retargetEvent(ev, t, loc);
                    t.columnResizer.mouseMoved(ev2);
                }
                if (!ResizableTable.this.resizingAColumn) {
                    ResizableTable.this.resizingAColumn = true;
                    ResizableTable.this.setCursor(columnResizeCursor);
                }
            } else if (ResizableTable.this.resizingAColumn) {
                ResizableTable.this.resizingAColumn = false;
                ResizableTable.this.setCursor(ResizableTable.this.nonResizeCursor);
            }
        }

        @Override
        public void mouseDragged(MouseEvent ev) {
            int mouseX = ev.getX();
            JTableHeader h = ResizableTable.this.getTableHeader();
            TableColumn resizingColumn = h.getResizingColumn();
            boolean headerLeftToRight = h.getComponentOrientation().isLeftToRight();
            if (resizingColumn != null) {
                Container container;
                int oldWidth = resizingColumn.getWidth();
                int newWidth = headerLeftToRight ? mouseX - this.mouseXOffset : this.mouseXOffset - mouseX;
                resizingColumn.setWidth(newWidth);
                if (h.getParent() == null || (container = h.getParent().getParent()) == null || !(container instanceof JScrollPane)) {
                    return;
                }
                if (!container.getComponentOrientation().isLeftToRight() && !headerLeftToRight) {
                    JViewport viewport = ((JScrollPane)container).getViewport();
                    int viewportWidth = viewport.getWidth();
                    int diff = newWidth - oldWidth;
                    int newHeaderWidth = ResizableTable.this.getWidth() + diff;
                    Dimension tableSize = ResizableTable.this.getSize();
                    tableSize.width += diff;
                    ResizableTable.this.setSize(tableSize);
                    if (newHeaderWidth >= viewportWidth && ResizableTable.this.getAutoResizeMode() == 0) {
                        Point p = viewport.getViewPosition();
                        p.x = Math.max(0, Math.min(newHeaderWidth - viewportWidth, p.x + diff));
                        viewport.setViewPosition(p);
                        this.mouseXOffset += diff;
                    }
                }
            } else {
                JTableHeader hh;
                Point loc = new Point(0, 0);
                ResizableTable t = ResizableTable.this.getLeftResizableTable(loc);
                if (t != null && (hh = t.getTableHeader()).getResizingColumn() != null) {
                    MouseEvent ev2 = ResizableTable.this.retargetEvent(ev, t, loc);
                    t.columnResizer.mouseDragged(ev2);
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            JTableHeader h = ResizableTable.this.getTableHeader();
            if (h.getResizingColumn() != null) {
                h.setResizingColumn(null);
            } else {
                Point loc = new Point(0, 0);
                ResizableTable t = ResizableTable.this.getLeftResizableTable(loc);
                if (t != null) {
                    JTableHeader hh = t.getTableHeader();
                    hh.setResizingColumn(null);
                }
            }
            h.setDraggedColumn(null);
        }
    }
}

