/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.view.swing.modules;

import chemaxon.calculations.clean.Clean3D;
import chemaxon.marvin.common.swing.MolPanel;
import chemaxon.marvin.io.ArrayMDocSource;
import chemaxon.marvin.io.MDocSource;
import chemaxon.marvin.util.CallbackIface;
import chemaxon.marvin.util.ErrorDisplay;
import chemaxon.marvin.util.MarvinModule;
import chemaxon.marvin.view.swing.ViewPanel;
import chemaxon.struc.MDocument;
import chemaxon.struc.Molecule;
import java.awt.Dialog;
import java.awt.Frame;
import java.util.ResourceBundle;

public class ShowConformers
extends MarvinModule {
    private static final ResourceBundle RESOURCES = MolPanel.getResourceBundle(ShowConformers.class.getName());
    private int icell;
    private Molecule m;
    private MolPanel that;
    private ErrorDisplay errorDisplay;

    public ShowConformers(int icell, Molecule m, MolPanel that, ErrorDisplay errorDisplay) {
        this.icell = icell;
        this.m = m;
        this.that = that;
        this.errorDisplay = errorDisplay;
    }

    @Override
    public Object modfunc(Object arg) {
        Molecule[] mols;
        Clean3D clean3d = new Clean3D();
        boolean descriptorPresent = false;
        if (clean3d.checkDescriptorPresence(this.m)) {
            descriptorPresent = true;
        }
        if ((mols = clean3d.calcConformers(this.m)) == null) {
            if (descriptorPresent) {
                this.errorDisplay.warning("The structure has been changed since the last conformer calculation and the stored conformer descriptor is removed.\nTo be able to use this option, please first calculate the conformers (Tools->Conformation->Conformers) using the\n\"Store conformer information in property field\" option.", null);
            } else {
                this.errorDisplay.warning("To be able to use this option, please first calculate the conformers (Tools->Conformation->Conformers)\nusing the \"Store conformer information in property field\" option.", null);
            }
            return null;
        }
        String[] labels = new String[mols.length];
        for (int i = 0; i < mols.length; ++i) {
            String label = RESOURCES.getString("clean3dConf") + ": " + (i + 1);
            String estring = mols[i].getProperty("ENERGY");
            if (estring != null) {
                try {
                    label = label + " " + RESOURCES.getString("clean3dConfEnergy") + ": ";
                    label = label + Math.rint(Double.parseDouble(estring) * 100.0) / 100.0;
                    label = label + " kcal/mol";
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            labels[i] = label;
        }
        try {
            CallbackIface view = (CallbackIface)MarvinModule.load("view.swing.MolsView", this.that);
            view.callback("setDim", new Integer(3));
            MolsSource docSource = new MolsSource(mols, labels);
            view.callback("setCells", ((MDocSource)docSource).getRecordCountMax());
            ViewPanel vpan = (ViewPanel)view.callback("createViewPanel", null);
            CallbackIface frame = null;
            try {
                frame = this.that.isParentWindowDialog() ? (CallbackIface)MarvinModule.load("view.swing.MolsFrame", new Class[]{Dialog.class}, new Object[]{this.that.getParentDialog()}, this.that) : (CallbackIface)MarvinModule.load("view.swing.MolsFrame", new Class[]{Frame.class}, new Object[]{this.that.getParentFrame()}, this.that);
            }
            catch (Throwable t) {
                // empty catch block
            }
            frame.callback("setTitle", RESOURCES.getString("clean3dConfFrameTitle"));
            frame.callback("setSelectButton", RESOURCES.getString("clean3dConfFrameSelButtonLabel"));
            frame.callback("setParent", this.that);
            frame.callback("setSourceCell", new Integer(this.icell));
            frame.callback("setViewPanel", vpan);
            frame.callback("setDocSource", docSource);
            frame.callback("build", null);
            frame.callback("show", null);
        }
        catch (SecurityException sex) {
            this.errorDisplay.firewallError(sex, null);
        }
        return null;
    }

    private static class MolsSource
    extends ArrayMDocSource {
        String[] labels = null;

        MolsSource(Molecule[] mols, String[] labels) {
            super(mols);
            this.labels = labels;
        }

        @Override
        public String getDocLabel(int k, MDocument doc) {
            return this.labels != null ? this.labels[k] : super.getDocLabel(k, doc);
        }
    }
}

