/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.view.swing.modules;

import chemaxon.marvin.view.swing.modules.ResizableTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class SplittedTable {
    private JPanel mainPanel = new MyPanel();
    private TableModel mainTableModel;
    private int[] splitColumns;
    private ResizableTable[] tables;
    private JScrollPane[] scrollPanes;

    public SplittedTable(TableModel mainmodel, int[] splitcols) {
        this.mainTableModel = mainmodel;
        this.splitColumns = new int[splitcols.length];
        System.arraycopy(splitcols, 0, this.splitColumns, 0, splitcols.length);
        this.tables = new ResizableTable[splitcols.length + 1];
        this.scrollPanes = new JScrollPane[splitcols.length + 1];
        for (int i = 0; i < this.tables.length; ++i) {
            SplittedTableModel model = new SplittedTableModel(i);
            this.tables[i] = new ResizableTable(model);
            this.scrollPanes[i] = new MyScrollPane(i);
            this.scrollPanes[i].setLocation(new Point(this.getTableX(i), 0));
            final int finali = i;
            this.tables[i].addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent ev) {
                    for (int j = finali + 1; j < SplittedTable.this.tables.length; ++j) {
                        SplittedTable.this.scrollPanes[j].setLocation(new Point(SplittedTable.this.getTableX(j), 0));
                    }
                }
            });
            this.tables[i].addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent ev) {
                    String name = ev.getPropertyName();
                    if (name.equals("rowHeight")) {
                        int v = (Integer)ev.getNewValue();
                        for (int j = 0; j < SplittedTable.this.tables.length; ++j) {
                            if (j == finali) continue;
                            SplittedTable.this.tables[j].setRowHeight(v);
                        }
                    }
                }
            });
            this.handleResizeByDraggingInFixedPart(i);
        }
        if (this.tables.length == 2) {
            this.addTablesWithBorderLayout();
        } else {
            this.addTablesWithGridBagLayout();
        }
    }

    private void handleResizeByDraggingInFixedPart(final int i) {
        if (i == this.tables.length - 1) {
            return;
        }
        TableColumnModel tcm = this.tables[i].getColumnModel();
        for (int j = 0; j < tcm.getColumnCount(); ++j) {
            final TableColumn tc = tcm.getColumn(j);
            tc.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent ev) {
                    String name = ev.getPropertyName();
                    if (name.equals("width")) {
                        int newv = (Integer)ev.getNewValue();
                        int oldv = (Integer)ev.getOldValue();
                        int dw = newv - oldv;
                        int lasti = SplittedTable.this.tables.length - 1;
                        JScrollPane lastscr = SplittedTable.this.scrollPanes[lasti];
                        Dimension szl = lastscr.getSize();
                        Dimension szi = SplittedTable.this.scrollPanes[i].getSize();
                        szi.width += dw;
                        szl.width -= dw;
                        lastscr.setSize(szl);
                        SplittedTable.this.scrollPanes[i].setSize(szi);
                        if (oldv != newv && szl.width < lastscr.getMinimumSize().width) {
                            tc.setWidth(oldv);
                            return;
                        }
                        for (int k = i + 1; k < SplittedTable.this.tables.length; ++k) {
                            SplittedTable.this.scrollPanes[k].repaint();
                        }
                    }
                }
            });
        }
    }

    private void addTablesWithBorderLayout() {
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.add((Component)this.scrollPanes[0], "West");
        this.mainPanel.add((Component)this.scrollPanes[1], "Center");
    }

    private void addTablesWithGridBagLayout() {
        GridBagLayout gbl = new GridBagLayout();
        this.mainPanel.setLayout(gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weighty = 1.0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.fill = 1;
        for (int i = 0; i < this.tables.length; ++i) {
            gbc.weightx = this.tables[i].getColumnCount();
            gbl.setConstraints(this.mainPanel.add(this.scrollPanes[i]), gbc);
            ++gbc.gridx;
        }
    }

    public int getPartIndex(JTable t) {
        for (int i = 0; i < this.tables.length; ++i) {
            if (this.tables[i] != t) continue;
            return i;
        }
        return -1;
    }

    public int getPartIndex(int col) {
        for (int i = 0; i < this.splitColumns.length; ++i) {
            if (col >= this.splitColumns[i]) continue;
            return i;
        }
        return this.splitColumns.length;
    }

    public int getStartColumn(int i) {
        return i != 0 ? this.splitColumns[i - 1] : 0;
    }

    public JComponent getJComponent() {
        return this.mainPanel;
    }

    public ResizableTable getLastTable() {
        return this.tables[this.tables.length - 1];
    }

    public int getTableX(int i) {
        int x = 0;
        for (int j = 0; j < i; ++j) {
            x += this.scrollPanes[j].getWidth();
        }
        return x;
    }

    public int getLastTableX() {
        return this.getTableX(this.tables.length - 1);
    }

    public int getPartCount() {
        return this.tables.length;
    }

    public ResizableTable getPart(int i) {
        return this.tables[i];
    }

    TableColumn getColumn(int col) {
        int i = this.getPartIndex(col);
        return this.tables[i].getColumnModel().getColumn(col - this.getStartColumn(i));
    }

    void fireTableChanged(TableModelEvent ev) {
        int first = ev.getFirstRow();
        int last = ev.getLastRow();
        int col = ev.getColumn();
        int type = ev.getType();
        if (col == -1) {
            for (int i = 0; i < this.tables.length; ++i) {
                AbstractTableModel m = (AbstractTableModel)this.tables[i].getModel();
                TableModelEvent ev2 = new TableModelEvent(m, first, last, col, type);
                m.fireTableChanged(ev2);
            }
        } else {
            int i = this.getPartIndex(col);
            AbstractTableModel m = (AbstractTableModel)this.tables[i].getModel();
            int col0 = this.getStartColumn(i);
            TableModelEvent ev2 = new TableModelEvent(m, first, last, col - col0, type);
            m.fireTableChanged(ev2);
        }
    }

    public int getRowCount() {
        return this.mainTableModel.getRowCount();
    }

    public int getColumnCount() {
        return this.mainTableModel.getColumnCount();
    }

    public int getRowHeight() {
        return this.tables[0].getRowHeight();
    }

    public void setRowHeight(int h) {
        for (int i = 0; i < this.tables.length; ++i) {
            this.tables[i].setRowHeight(h);
        }
    }

    public int getPreferredHorizontalScrollUnitIncrement() {
        return this.getLastTable().getPreferredHorizontalScrollUnitIncrement();
    }

    public void setAutoResizeMode(int mode) {
        for (int i = 0; i < this.tables.length; ++i) {
            this.tables[i].setAutoResizeMode(mode);
        }
    }

    public void setRowSelectionAllowed(boolean allowed) {
        for (int i = 0; i < this.tables.length; ++i) {
            this.tables[i].setRowSelectionAllowed(allowed);
        }
    }

    public void setColumnSelectionAllowed(boolean allowed) {
        for (int i = 0; i < this.tables.length; ++i) {
            this.tables[i].setColumnSelectionAllowed(allowed);
        }
    }

    public void setAutoCreateColumnsFromModel(boolean a) {
        for (int i = 0; i < this.tables.length; ++i) {
            this.tables[i].setAutoCreateColumnsFromModel(a);
        }
    }

    public void addMouseListener(MouseListener l) {
        for (int i = 0; i < this.tables.length; ++i) {
            this.tables[i].addMouseListener(l);
        }
    }

    public boolean isEditing() {
        for (int i = 0; i < this.tables.length; ++i) {
            if (!this.tables[i].isEditing()) continue;
            return true;
        }
        return false;
    }

    public int getEditingRow() {
        for (int i = 0; i < this.tables.length; ++i) {
            int row = this.tables[i].getEditingRow();
            if (row < 0) continue;
            return row;
        }
        return -1;
    }

    public int getEditingColumn() {
        int col = 0;
        for (int i = 0; i < this.tables.length; ++i) {
            int k = this.tables[i].getEditingColumn();
            if (k >= 0) {
                return col + k;
            }
            col += this.tables[i].getColumnCount();
        }
        return -1;
    }

    public TableCellEditor getCellEditor() {
        for (int i = 0; i < this.tables.length; ++i) {
            TableCellEditor tce = this.tables[i].getCellEditor();
            if (tce == null) continue;
            return tce;
        }
        return null;
    }

    public void setDefaultColumnWidth(int w) {
        for (int i = 0; i < this.tables.length; ++i) {
            this.tables[i].setDefaultColumnWidth(w);
        }
    }

    public Rectangle getCellRect(int row, int col, boolean includeSpacing) {
        int i = this.getPartIndex(col);
        return this.tables[i].getCellRect(row, col - this.getStartColumn(i), includeSpacing);
    }

    public void setJScrollPane(JScrollPane p) {
        int i = this.scrollPanes.length - 1;
        LayoutManager lm = this.mainPanel.getLayout();
        if (lm instanceof GridBagLayout) {
            GridBagLayout gbl = (GridBagLayout)lm;
            GridBagConstraints gbc = gbl.getConstraints(this.scrollPanes[i]);
            this.mainPanel.remove(this.scrollPanes[i]);
            this.scrollPanes[i] = p;
            gbl.setConstraints(this.mainPanel.add(this.scrollPanes[i]), gbc);
        } else {
            this.mainPanel.remove(this.scrollPanes[i]);
            this.scrollPanes[i] = p;
            this.mainPanel.add((Component)this.scrollPanes[i], "Center");
        }
        this.getLastTable().setJScrollPane(p);
        this.initJScrollPane(i, p);
    }

    public void setDefaultColumnWidth(int col, int w) {
        int i = this.getPartIndex(col);
        int j = col - this.getStartColumn(i);
        this.tables[i].setDefaultColumnWidth(j, w);
    }

    public int getPreferredColumnWidth(int col) {
        int i = this.getPartIndex(col);
        return this.tables[i].getDefaultColumnWidth(col - this.getStartColumn(i));
    }

    public void setColumnFlags(int col, int f) {
        int i = this.getPartIndex(col);
        this.tables[i].setColumnFlags(col - this.getStartColumn(i), f);
    }

    void cancelEditing() {
        for (int i = 0; i < this.tables.length; ++i) {
            this.tables[i].cancelEditing();
        }
    }

    int getTopRow() {
        return this.getLastTable().getTopRow();
    }

    void setTopRow(int row) {
        this.getLastTable().setTopRow(row);
    }

    int getBottomRow() {
        return this.getLastTable().getBottomRow();
    }

    void setBottomRow(int row) {
        this.getLastTable().setBottomRow(row);
    }

    private void initJScrollPane(final int i, JScrollPane p) {
        boolean last = i == this.tables.length - 1;
        p.setVerticalScrollBarPolicy(last ? 20 : 21);
        p.setHorizontalScrollBarPolicy(this.tables.length == 1 ? 30 : 32);
        if (!last) {
            JScrollBar dummy = new JScrollBar(0){

                @Override
                public void paint(Graphics g) {
                }
            };
            p.setHorizontalScrollBar(dummy);
        }
        JScrollBar vbar = p.getVerticalScrollBar();
        vbar.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent ev) {
                int v = ev.getValue();
                for (int j = 0; j < SplittedTable.this.tables.length; ++j) {
                    if (j == i) continue;
                    JScrollBar b = SplittedTable.this.scrollPanes[j].getVerticalScrollBar();
                    b.setValue(v);
                }
            }
        });
    }

    JScrollPane createLastScrollPane() {
        return new MyScrollPane(this.tables.length - 1);
    }

    private class MyScrollPane
    extends JScrollPane {
        private int index;

        MyScrollPane(int i) {
            super(SplittedTable.this.tables[i]);
            this.index = i;
            SplittedTable.this.initJScrollPane(i, this);
        }

        @Override
        public Dimension getPreferredSize() {
            if (this.index != SplittedTable.this.tables.length - 1) {
                Dimension size = SplittedTable.this.tables[this.index].getPreferredSize();
                Insets insets = this.getInsets();
                size.width += insets.left + insets.right;
                size.height += insets.top + insets.bottom;
                return size;
            }
            return super.getPreferredSize();
        }

        @Override
        public JScrollBar createVerticalScrollBar() {
            JScrollBar bar = new JScrollBar(1){

                @Override
                public int getUnitIncrement(int dir) {
                    return SplittedTable.this.getRowHeight();
                }

                @Override
                public int getBlockIncrement(int dir) {
                    int h = this.getSize().height;
                    int rh = SplittedTable.this.getRowHeight();
                    int visibleRows = (h + rh / 4) / rh;
                    return visibleRows * rh;
                }
            };
            return bar;
        }
    }

    private class SplittedTableModel
    extends AbstractTableModel {
        private int id;

        public SplittedTableModel(int id) {
            this.id = id;
        }

        @Override
        public int getColumnCount() {
            return this.getEndColumnInMainTable() - SplittedTable.this.getStartColumn(this.id);
        }

        @Override
        public int getRowCount() {
            return SplittedTable.this.mainTableModel.getRowCount();
        }

        @Override
        public String getColumnName(int col) {
            int start = SplittedTable.this.getStartColumn(this.id);
            return SplittedTable.this.mainTableModel.getColumnName(start + col);
        }

        public Class getColumnClass(int col) {
            int start = SplittedTable.this.getStartColumn(this.id);
            return SplittedTable.this.mainTableModel.getColumnClass(start + col);
        }

        @Override
        public Object getValueAt(int row, int col) {
            int start = SplittedTable.this.getStartColumn(this.id);
            return SplittedTable.this.mainTableModel.getValueAt(row, start + col);
        }

        @Override
        public void setValueAt(Object o, int row, int col) {
            int start = SplittedTable.this.getStartColumn(this.id);
            SplittedTable.this.mainTableModel.setValueAt(o, row, start + col);
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            int start = SplittedTable.this.getStartColumn(this.id);
            return SplittedTable.this.mainTableModel.isCellEditable(row, start + col);
        }

        private int getEndColumnInMainTable() {
            return this.id != SplittedTable.this.splitColumns.length ? SplittedTable.this.splitColumns[this.id] : SplittedTable.this.mainTableModel.getColumnCount();
        }
    }

    private class MyPanel
    extends JPanel {
        private MyPanel() {
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension d = new Dimension();
            d.width = 0;
            d.height = 0;
            for (int i = 0; i < SplittedTable.this.tables.length; ++i) {
                Dimension di = SplittedTable.this.scrollPanes[i].getPreferredSize();
                if (di.height > d.height) {
                    d.height = di.height;
                }
                d.width += di.width;
            }
            return d;
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension d = new Dimension();
            d.width = 0;
            d.height = 0;
            for (int i = 0; i < SplittedTable.this.tables.length; ++i) {
                Dimension di = SplittedTable.this.scrollPanes[i].getMinimumSize();
                if (di.height > d.height) {
                    d.height = di.height;
                }
                d.width += di.width;
            }
            return d;
        }

        @Override
        public Dimension getMaximumSize() {
            Dimension d = new Dimension();
            d.width = 0;
            d.height = 0;
            for (int i = 0; i < SplittedTable.this.tables.length; ++i) {
                Dimension di = SplittedTable.this.scrollPanes[i].getMaximumSize();
                if (di.height > d.height) {
                    d.height = di.height;
                }
                d.width += di.width;
            }
            return d;
        }

        @Override
        public int getWidth() {
            int w = 0;
            for (int i = 0; i < SplittedTable.this.tables.length; ++i) {
                w += SplittedTable.this.scrollPanes[i].getWidth();
            }
            return w;
        }

        @Override
        public int getHeight() {
            int h = 0;
            for (int i = 0; i < SplittedTable.this.tables.length; ++i) {
                int hh = SplittedTable.this.scrollPanes[i].getHeight();
                if (hh <= h) continue;
                h = hh;
            }
            return h;
        }
    }
}

