/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.view.swing.modules;

import chemaxon.marvin.view.swing.modules.FindInfo;
import chemaxon.marvin.view.swing.modules.RowColorFunction;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.util.StringTokenizer;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class TextCellRenderer
extends JTextPane
implements TableCellRenderer {
    public static final int HEADER = 1;
    private int options;
    private boolean lineWrap;
    private RowColorFunction rowColorFunc;
    private Color gridColor;
    private FindInfo findInfo;

    public TextCellRenderer(int opts, RowColorFunction rcf, FindInfo fi) {
        this.setEditable(false);
        this.setLineWrap(true);
        this.options = opts;
        this.rowColorFunc = rcf;
        this.findInfo = fi;
        this.gridColor = this.getForeground();
    }

    public boolean getLineWrap() {
        return this.lineWrap;
    }

    public void setLineWrap(boolean w) {
        this.lineWrap = w;
    }

    @Override
    public void paint(Graphics g0) {
        super.paint(g0);
        Dimension prefsz = this.getPreferredSize();
        Dimension sz = this.getSize();
        Graphics2D g = (Graphics2D)g0;
        int d = g.getFontMetrics().getHeight() / 3;
        if (prefsz.height > sz.height) {
            int y = sz.height;
            for (int x = sz.width - 1; x > 0; x -= 2 * d) {
                this.drawTornEdge(g, x, y, d, d, false);
            }
        } else {
            g0.setColor(this.gridColor);
            g0.drawLine(0, sz.height - 1, sz.width - 1, sz.height - 1);
        }
        if (prefsz.width > sz.width) {
            int x = sz.width;
            for (int y = sz.height - 1; y > 0; y -= 2 * d) {
                this.drawTornEdge(g, x, y, d, d, true);
            }
        } else {
            g0.setColor(this.gridColor);
            g0.drawLine(sz.width - 1, 0, sz.width - 1, sz.height - 1);
        }
    }

    private void drawTornEdge(Graphics2D g, int x, int y, int dx, int dy, boolean vert) {
        GeneralPath gpf = new GeneralPath(0, 4);
        gpf.moveTo(x, y);
        if (vert) {
            gpf.lineTo(x - dx, y - dy);
            gpf.lineTo(x, y - 2 * dy);
        } else {
            gpf.lineTo(x - dx, y - dy);
            gpf.lineTo(x - 2 * dx, y);
        }
        GeneralPath gpd = (GeneralPath)gpf.clone();
        gpf.lineTo(x, y);
        g.setColor(this.getBackground());
        g.fill(gpf);
        g.setColor(this.gridColor);
        g.draw(gpd);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        int offset;
        String word;
        Color bg = this.rowColorFunc != null ? this.rowColorFunc.rowBackground(row) : null;
        Color fg = this.rowColorFunc != null ? this.rowColorFunc.rowForeground(row) : null;
        this.gridColor = table.getGridColor();
        if (hasFocus) {
            fg = table.getSelectionForeground();
            super.setBackground(table.getSelectionBackground());
        } else if ((this.options & 1) != 0) {
            JTableHeader h = table.getTableHeader();
            if (fg == null) {
                fg = h.getForeground();
            }
            super.setBackground(bg != null ? bg : h.getBackground());
        } else {
            if (fg == null) {
                fg = table.getForeground();
            }
            super.setBackground(bg != null ? bg : table.getBackground());
        }
        super.setForeground(fg);
        String s = value != null ? value.toString() : "";
        boolean html = this.getContentType().equals("text/html");
        if (html) {
            StringTokenizer st = new StringTokenizer(s, "\n");
            StringBuffer sb = new StringBuffer();
            if (!this.lineWrap) {
                sb.append("<table CELLSPACING=0 CELLPADDING=0><tr>\n<td NOWRAP>");
            }
            int i = 0;
            while (st.hasMoreTokens()) {
                int k;
                if (i != 0) {
                    if (this.lineWrap) {
                        sb.append("<br>\n");
                    } else {
                        sb.append("</td></tr>\n<tr><td NOWRAP>");
                    }
                }
                if ((k = (s = st.nextToken()).indexOf(61)) >= 0) {
                    sb.append("<b>");
                    sb.append(s.substring(0, k).trim());
                    sb.append("</b> = ");
                    sb.append(s.substring(k + 1).trim());
                } else {
                    sb.append(s);
                }
                ++i;
            }
            if (!this.lineWrap) {
                sb.append("</td></tr></table>");
            }
            s = sb.toString();
        }
        this.setText(s);
        Font font = this.getFont();
        if (font != null) {
            this.setJTextPaneFont(font, fg);
        }
        String string = word = this.findInfo != null ? this.findInfo.getWord() : null;
        if (word != null && (offset = TextCellRenderer.search(this, word, this.findInfo.getMatchCase(), table.getSelectionBackground())) != -1) {
            try {
                this.scrollRectToVisible(this.modelToView(offset));
            }
            catch (BadLocationException e) {
                // empty catch block
            }
        }
        return this;
    }

    private static int search(JTextComponent comp, String word, boolean cs, Color color) {
        if (word == null || word.equals("")) {
            return -1;
        }
        int first = -1;
        Highlighter highlighter = comp.getHighlighter();
        Highlighter.Highlight[] highlights = highlighter.getHighlights();
        for (int i = 0; i < highlights.length; ++i) {
            Highlighter.Highlight h = highlights[i];
            highlighter.removeHighlight(h);
        }
        String content = null;
        try {
            Document d = comp.getDocument();
            content = d.getText(0, d.getLength());
            if (!cs) {
                content = content.toLowerCase();
            }
        }
        catch (BadLocationException e) {
            return -1;
        }
        if (!cs) {
            word = word.toLowerCase();
        }
        int lastIndex = 0;
        int wordSize = word.length();
        DefaultHighlighter.DefaultHighlightPainter painter = null;
        while ((lastIndex = content.indexOf(word, lastIndex)) != -1) {
            int endIndex = lastIndex + wordSize;
            if (painter == null) {
                painter = new DefaultHighlighter.DefaultHighlightPainter(color);
            }
            try {
                highlighter.addHighlight(lastIndex, endIndex, painter);
            }
            catch (BadLocationException e) {
                // empty catch block
            }
            if (first == -1) {
                first = lastIndex;
            }
            lastIndex = endIndex;
        }
        return first;
    }

    private void setJTextPaneFont(Font font, Color fg) {
        MutableAttributeSet attrs = this.getInputAttributes();
        StyleConstants.setFontFamily(attrs, font.getFamily());
        StyleConstants.setFontSize(attrs, font.getSize());
        StyleConstants.setItalic(attrs, (font.getStyle() & 2) != 0);
        StyleConstants.setBold(attrs, (font.getStyle() & 1) != 0);
        StyleConstants.setForeground(attrs, fg);
        StyledDocument doc = this.getStyledDocument();
        doc.setCharacterAttributes(0, doc.getLength() + 1, attrs, false);
    }

    @Override
    public void invalidate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void validate() {
    }

    @Override
    public void repaint() {
    }

    @Override
    public void repaint(Rectangle r) {
    }

    @Override
    public void repaint(int x, int y, int width, int height) {
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if ("document".equals(propertyName)) {
            super.firePropertyChange(propertyName, oldValue, newValue);
        }
    }
}

