/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.view.swing.modules;

import chemaxon.marvin.common.swing.DnD;
import chemaxon.marvin.modules.datatransfer.ClipboardHandler;
import chemaxon.marvin.util.CallbackIface;
import chemaxon.marvin.view.swing.ViewCanvas;
import chemaxon.marvin.view.swing.ViewPanel;
import chemaxon.struc.CTransform3D;
import chemaxon.struc.MDocument;
import chemaxon.struc.Molecule;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.JOptionPane;

public class ViewDnD
implements CallbackIface {
    private DnD theDnD;
    private CTransform3D savedTransform = null;
    private Molecule dragMol = null;
    private DnD dragger = null;
    private DnD dropper = null;

    @Override
    public Object callback(String method, Object arg) {
        if (method.equals("init")) {
            this.theDnD = (DnD)arg;
        } else if (method.equals("dragGestureRecognized")) {
            DragGestureEvent ev = (DragGestureEvent)arg;
            ViewCanvas viewCanvas = this.getViewCanvas();
            MDocument doc = viewCanvas.getDocument();
            if (doc == null) {
                return null;
            }
            this.dragMol = (Molecule)doc.getMainMoleculeGraph();
            if (this.dragMol == null) {
                return null;
            }
            Transferable dataTransfer = ClipboardHandler.getTransferableFor(this.dragMol, null);
            int na = this.dragMol.getAtomCount();
            this.dropper = null;
            this.dragger = null;
            if (na > 0 && viewCanvas.callback("canbeDnDdrag", null) != null) {
                this.savedTransform = (CTransform3D)viewCanvas.callback("getSavedTransform", null);
                this.theDnD.log("GESTURE RECOGNIZED, " + na + " atoms selected");
                this.dragger = this.theDnD;
                this.theDnD.getDragSource().startDrag(ev, DragSource.DefaultCopyDrop, dataTransfer, this.theDnD);
            }
        } else if (method.equals("dragOver")) {
            DropTargetDragEvent ev = (DropTargetDragEvent)arg;
            ViewCanvas viewCanvas = this.getViewCanvas();
            if (this.theDnD == this.dragger) {
                Point p = ev.getLocation();
                MouseEvent mev = new MouseEvent(viewCanvas, 506, 0L, 0, p.x, p.y, 0, false);
                viewCanvas.mouseDragged(mev);
                viewCanvas.repaint();
            }
            ev.acceptDrag(3);
        } else if (method.equals("dragDropEnd")) {
            DragSourceDropEvent ev = (DragSourceDropEvent)arg;
            ViewCanvas viewCanvas = this.getViewCanvas();
            if (ev.getDropSuccess()) {
                if (this.dropper == this.theDnD) {
                    this.theDnD.log("SUCCESS (local transfer)");
                } else if (ev.getDropAction() == 2) {
                    this.theDnD.log("SUCCESS (move)");
                } else {
                    viewCanvas.callback("setTransform", this.savedTransform);
                }
            } else {
                this.theDnD.log("REJECTED " + this.dropper + " " + this.theDnD);
                if (this.dropper != null) {
                    viewCanvas.callback("setTransform", this.savedTransform);
                }
            }
            this.dropper = null;
            this.dragger = null;
        } else if (method.equals("drop")) {
            DropTargetDropEvent ev = (DropTargetDropEvent)arg;
            ViewCanvas viewCanvas = this.getViewCanvas();
            ViewPanel viewPanel = this.getViewPanel();
            int index = this.getIndex();
            this.dropper = this.theDnD;
            DropTargetContext targetContext = ev.getDropTargetContext();
            Transferable t = ev.getTransferable();
            ev.acceptDrop(ev.getSourceActions());
            Molecule molAtTarget = null;
            if (this.theDnD != this.dragger) {
                MDocument d = viewPanel.getDocument(index);
                Molecule molecule = molAtTarget = d != null ? d.getPrimaryMolecule() : null;
            }
            if (molAtTarget != null) {
                if (molAtTarget.isEmpty()) {
                    molAtTarget = null;
                } else {
                    int confirm = viewPanel.isImportEnabled() ? JOptionPane.showConfirmDialog(viewPanel, "Replace molecule?", "Replace?", 0, 2) : -1;
                    if (confirm == 0) {
                        molAtTarget = null;
                    }
                }
            }
            if (molAtTarget == null) {
                Molecule dropMol;
                Molecule molecule = dropMol = this.theDnD == this.dragger ? this.dragMol : (Molecule)ClipboardHandler.getObjectFromTransferable(t);
                if (dropMol == null) {
                    JOptionPane.showMessageDialog(viewPanel, "Cannot import molecule from this object.", "Cannot drop", 0);
                } else {
                    if (this.theDnD != this.dragger) {
                        dropMol.valenceCheck();
                        Molecule[] m = new Molecule[]{dropMol};
                        viewPanel.molLoaded(m, index);
                        viewPanel.setFile(null);
                    }
                    viewCanvas.repaint();
                    Object data = null;
                    try {
                        data = t.getTransferData(DataFlavor.javaFileListFlavor);
                    }
                    catch (IOException ex) {
                    }
                    catch (UnsupportedFlavorException ex) {
                        // empty catch block
                    }
                    if (data != null) {
                        for (File f : (List)data) {
                            viewPanel.addRecentFileToUserSettings(f);
                            viewPanel.setLoadCwdToUserSettings(f);
                        }
                    }
                    targetContext.dropComplete(true);
                    return null;
                }
            }
            targetContext.dropComplete(false);
            ev.rejectDrop();
        }
        return null;
    }

    private ViewCanvas getViewCanvas() {
        return (ViewCanvas)this.theDnD.getComponent();
    }

    private ViewPanel getViewPanel() {
        return (ViewPanel)this.theDnD.getMolPanel();
    }

    private int getIndex() {
        return (Integer)this.getViewCanvas().callback("getIndex", null);
    }
}

