/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.math.discrete;

import java.util.ArrayList;
import java.util.NoSuchElementException;

public class PermutationIterator {
    private MyIntVec numbers;
    private int[] actualPermutations = null;
    private boolean doInit = false;
    private PermutationIterator myPermutations = null;
    private int counter = 0;
    private int myIndex = 0;

    public PermutationIterator(int n) {
        this.actualPermutations = new int[n];
        this.numbers = new MyIntVec(n);
        for (int i = 0; i < n; ++i) {
            this.actualPermutations[i] = i;
            this.numbers.add(i);
        }
        this.init();
    }

    private PermutationIterator(MyIntVec numbers, int[] actual, boolean init) {
        this.actualPermutations = actual;
        this.doInit = init;
        this.numbers = numbers;
        this.init();
    }

    private PermutationIterator(MyIntVec numbers, int newCounter, int[] actual, boolean init) {
        this.doInit = init;
        this.actualPermutations = actual;
        this.numbers = numbers;
        this.counter = newCounter;
        this.initRemove();
    }

    private void init() {
        this.myIndex = this.actualPermutations.length - this.numbers.size();
        MyIntVec lessNumber = (MyIntVec)this.numbers.clone();
        if (lessNumber.size() > 1) {
            lessNumber.remove(0);
            this.myPermutations = new PermutationIterator(lessNumber, this.actualPermutations, this.doInit);
        }
        this.doInit = false;
    }

    private void initRemove() {
        this.myIndex = this.actualPermutations.length - this.numbers.size();
        for (int i = 0; i < this.numbers.size(); ++i) {
            System.err.print(" " + this.numbers.get(i));
        }
        System.err.println();
        MyIntVec lessNumber = (MyIntVec)this.numbers.clone();
        if (lessNumber.size() > 1) {
            lessNumber.remove(this.counter);
            this.myPermutations = new PermutationIterator(lessNumber, lessNumber.size() - 1, this.actualPermutations, this.doInit);
        }
        this.doInit = false;
    }

    public void reset() {
        if (this.myIndex == 0) {
            this.counter = 0;
            this.init();
        }
    }

    public boolean hasNext() {
        boolean ok = this.counter < this.numbers.size();
        return ok;
    }

    public int[] next() {
        boolean ok;
        boolean bl = ok = this.counter < this.numbers.size();
        if (!ok) {
            throw new NoSuchElementException("No more permutations.");
        }
        this.actualPermutations[this.myIndex] = this.numbers.get(this.counter);
        if (this.myPermutations != null) {
            this.myPermutations.next();
            if (!this.myPermutations.hasNext()) {
                ++this.counter;
                boolean bl2 = ok = this.counter < this.numbers.size();
                if (ok) {
                    MyIntVec lessNumber = (MyIntVec)this.numbers.clone();
                    lessNumber.remove(this.counter);
                    this.myPermutations = new PermutationIterator(lessNumber, this.actualPermutations, this.doInit);
                }
            }
        } else {
            ++this.counter;
        }
        int[] ret = new int[this.actualPermutations.length];
        System.arraycopy(this.actualPermutations, 0, ret, 0, ret.length);
        return ret;
    }

    private class MyIntVec {
        public ArrayList numbers = null;

        MyIntVec() {
        }

        MyIntVec(int n) {
            this.numbers = new ArrayList(n);
        }

        MyIntVec(int[] manyNumber) {
            this.numbers = new ArrayList(manyNumber.length);
            for (int i = 0; i < manyNumber.length; ++i) {
                this.add(manyNumber[i]);
            }
        }

        public void add(int element) {
            this.numbers.add(new int[]{element});
        }

        public int get(int index) {
            int[] num = (int[])this.numbers.get(index);
            return num[0];
        }

        public int remove(int index) {
            int[] num = (int[])this.numbers.remove(index);
            return num[0];
        }

        public int size() {
            return this.numbers.size();
        }

        public Object clone() {
            MyIntVec newIntVec = new MyIntVec();
            newIntVec.numbers = (ArrayList)this.numbers.clone();
            return newIntVec;
        }
    }
}

