/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.metabolizer;

import chemaxon.formats.MolImporter;
import chemaxon.metabolizer.Metabolizer;
import chemaxon.metabolizer.MetabolizerException;
import chemaxon.struc.Molecule;
import chemaxon.struc.RxnMolecule;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;

public class LibraryTester {
    public static final int SUCCESS = 0;
    public static final int WARNING = 1;
    public static final int ERROR = 2;
    private String message = "";
    public static final String LIBRARY_CONTAINS_NOT_VALID_REACTION_SCHEME = "ERROR: The following reactions in the given library are not valid:\n";
    public static final String REACTION_MUST_HAVE_ONLY_ONE_REACTANT = "ERROR: The following reaction schemes contains not only one reactant:\n";
    public static final String REACTION_HAS_LESS_THAN_ONE_PRODUCT = "ERROR: The following reaction schemes has less than one product:\n";
    public static final String UNREADABLE_REACTION_FILE = "ERROR: The reaction file is corrupted.";
    public static final String REACTION_DOES_NOT_CONTAINS_SPEED_CATEGORY = "WARNING: No stability calculation available. The following reaction schemes does not contain SPEED_CATEGORY property:\n";

    public int testLibrary(Molecule[] reactions) {
        int status = 0;
        StringBuffer notValidReactions = new StringBuffer();
        boolean containsNotValidReactions = false;
        StringBuffer badReactantCountReactions = new StringBuffer();
        boolean containsReactantCountProblem = false;
        StringBuffer badProductCountReactions = new StringBuffer();
        boolean containsProductCountProbleam = false;
        StringBuffer reactionNotContainsSpeedCategory = new StringBuffer();
        boolean containsSpeedCategoryProblem = false;
        for (int i = 0; i < reactions.length; ++i) {
            if (!(reactions[i] instanceof RxnMolecule)) {
                status = 2;
                containsNotValidReactions = true;
                notValidReactions.append("#" + i + "\n");
                continue;
            }
            if (((RxnMolecule)reactions[i]).getReactantCount() != 1) {
                status = 2;
                containsReactantCountProblem = true;
                badReactantCountReactions.append("#" + i + " name:" + reactions[i].getProperty("NAME") + "\n");
                continue;
            }
            if (((RxnMolecule)reactions[i]).getProductCount() < 1) {
                status = 2;
                containsProductCountProbleam = true;
                badProductCountReactions.append("#" + i + " name:" + reactions[i].getProperty("NAME") + "\n");
                continue;
            }
            if (reactions[i].getProperty("SPEED_CATEGORY") != null) continue;
            if (status < 2) {
                status = 1;
            }
            containsSpeedCategoryProblem = true;
            reactionNotContainsSpeedCategory.append("#" + i + " name:" + reactions[i].getProperty("NAME") + "\n");
        }
        this.message = (containsNotValidReactions ? LIBRARY_CONTAINS_NOT_VALID_REACTION_SCHEME + notValidReactions.toString() : "") + (containsReactantCountProblem ? REACTION_MUST_HAVE_ONLY_ONE_REACTANT + badReactantCountReactions.toString() : "") + (containsProductCountProbleam ? REACTION_HAS_LESS_THAN_ONE_PRODUCT + badProductCountReactions.toString() : "") + (containsSpeedCategoryProblem ? REACTION_DOES_NOT_CONTAINS_SPEED_CATEGORY + reactionNotContainsSpeedCategory.toString() : "");
        return status;
    }

    public int testLibrary(String libraryFilePath) {
        int status = 0;
        try {
            status = this.testLibrary(this.readMoleculeFromFile(libraryFilePath));
        }
        catch (IOException exception) {
            status = 2;
            this.message = UNREADABLE_REACTION_FILE;
        }
        return status;
    }

    public int testLibrary(File libraryFile) {
        return this.testLibrary(libraryFile.getAbsolutePath());
    }

    public void testLibraryWithExamples(Molecule[] reactions, Molecule[] examples) {
        FileWriter writer = null;
        try {
            writer = new FileWriter("D:\\out");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ArrayList<RxnMolecule> list = new ArrayList<RxnMolecule>();
        for (int i = 0; i < reactions.length; ++i) {
            if (!(reactions[i] instanceof RxnMolecule)) continue;
            list.add((RxnMolecule)reactions[i]);
        }
        RxnMolecule[] library = list.toArray(new RxnMolecule[list.size()]);
        try {
            Metabolizer metabolizer = new Metabolizer(1, library, true);
            for (int i = 0; i < examples.length; ++i) {
                if (!(examples[i] instanceof RxnMolecule)) continue;
                RxnMolecule example = (RxnMolecule)examples[i];
                Molecule substrate = example.getReactant(0);
                metabolizer.setSubstrates(new Molecule[]{substrate});
                ArrayList<String> metabolites = new ArrayList<String>();
                while (metabolizer.hasMoreLevel()) {
                    while (!metabolizer.isCurrentLevelEnded()) {
                        Molecule[] mols = metabolizer.next();
                        if (mols == null) continue;
                        for (int j = 0; j < mols.length; ++j) {
                            metabolites.add(mols[j].toFormat("smiles:q"));
                        }
                    }
                    metabolizer.nextLevel();
                }
                for (int j = 0; j < example.getProductCount(); ++j) {
                    RxnMolecule exampleReaction = new RxnMolecule();
                    exampleReaction.addComponent(substrate, 0);
                    exampleReaction.addComponent(example.getProduct(j), 1);
                    if (metabolites.contains(exampleReaction.toFormat("smiles:q"))) continue;
                    try {
                        writer.write(exampleReaction.toFormat("smiles:q") + "\n");
                        continue;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            ((Writer)writer).flush();
            ((Writer)writer).close();
        }
        catch (MetabolizerException exception) {
            exception.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void testLibraryWithExamples(String libraryFilePath, String examplesFilePath) {
        try {
            this.testLibraryWithExamples(this.readMoleculeFromFile(libraryFilePath), this.readMoleculeFromFile(examplesFilePath));
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    private Molecule[] readMoleculeFromFile(String libraryFilePath) throws IOException {
        Molecule tempMol;
        ArrayList<Molecule> list = new ArrayList<Molecule>();
        MolImporter importer = new MolImporter(libraryFilePath);
        while ((tempMol = importer.read()) != null) {
            list.add(tempMol);
        }
        return list.toArray(new Molecule[list.size()]);
    }

    public String getMessage() {
        return this.message;
    }
}

