/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.metabolizer;

import chemaxon.struc.Molecule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class MetabolizerCalculator {
    private Map<String, Map<Float, List<String>>> treeRootAccumulationsSynthesisCodesMap = Collections.synchronizedMap(new HashMap());
    private Map<String, List<Float>> treeRootAccumulationsMap = Collections.synchronizedMap(new HashMap());
    private Map<String, Map<String, Float>> treeRootSynthesisCodeAccumulationMap = Collections.synchronizedMap(new HashMap());
    private Map<String, Map<String, Float>> treeRootSynthesisCodesAccumulationByPathMap = Collections.synchronizedMap(new HashMap());
    private Map<String, Float> treeRootMaxProductionMap = Collections.synchronizedMap(new HashMap());
    private Map<String, Map<String, Float>> treeRootSynshesisCodeLeafAccumulationMap = Collections.synchronizedMap(new HashMap());
    private static volatile MetabolizerCalculator calculator = new MetabolizerCalculator();

    private MetabolizerCalculator() {
    }

    public static MetabolizerCalculator getInstance() {
        return calculator;
    }

    public void calculateDominance(Molecule substrate, Molecule[] metabolites) {
        float substrateProduction = 1.0f;
        float substrateSpeed = 0.0f;
        float metaboliteSpeedSum = 0.0f;
        String treeRootSynthesisCode = substrate.getProperty("METABOLIC_TREE_COUNT");
        String substrateSynthesisCode = substrate.getProperty("Synthesis Code");
        if (substrate.getProperty("PRODUCTION") != null) {
            substrateProduction = Float.parseFloat(substrate.getProperty("PRODUCTION"));
            substrateSpeed = MetabolizerCalculator.calculateSpeedFromSpeedCategory(Integer.parseInt(substrate.getProperty("SPEED_CATEGORY")));
            String substrateAccu = substrate.getProperty("ACCUMULATION");
            Float substrateAccumulation = substrateAccu != null ? Float.valueOf(substrateAccu) : new Float(substrateProduction);
            this.removeAccumulation(substrateAccumulation, substrateSynthesisCode, treeRootSynthesisCode);
        }
        for (int i = 0; i < metabolites.length; ++i) {
            metaboliteSpeedSum += MetabolizerCalculator.calculateSpeedFromSpeedCategory(Integer.parseInt(metabolites[i].getProperty("SPEED_CATEGORY")));
        }
        float substrateTransmissivity = substrateSpeed > metaboliteSpeedSum ? metaboliteSpeedSum / substrateSpeed : 1.0f;
        int vMax = 0;
        for (int i = 0; i < metabolites.length; ++i) {
            int speedCategory;
            Molecule metabolite = metabolites[i];
            String synthesisCode = metabolite.getProperty("Synthesis Code");
            String oldAccumulation = metabolite.getProperty("ACCUMULATION");
            if (oldAccumulation != null) {
                this.removeAccumulation(Float.valueOf(oldAccumulation), metabolite.getProperty("Synthesis Code"), treeRootSynthesisCode);
            }
            if (vMax < (speedCategory = Integer.parseInt(metabolite.getProperty("SPEED_CATEGORY")))) {
                vMax = speedCategory;
            }
            if (vMax > 5) {
                vMax = 5;
            }
            float vCurrent = MetabolizerCalculator.calculateSpeedFromSpeedCategory(speedCategory);
            Float production = new Float(substrateProduction * substrateTransmissivity * vCurrent / metaboliteSpeedSum);
            this.addAccumulation(production, synthesisCode, treeRootSynthesisCode);
            this.addProduction(production, treeRootSynthesisCode);
            metabolite.setProperty("PRODUCTION", String.valueOf(production));
            metabolite.setProperty("ACCUMULATION", String.valueOf(production));
            metabolite.setProperty("TRANSMISSIVITY", "0.0");
        }
        Float accumulation = new Float(substrateProduction * (1.0f - substrateTransmissivity));
        this.addAccumulation(accumulation, substrateSynthesisCode, treeRootSynthesisCode);
        this.recalculateMaxPathAccumulations(treeRootSynthesisCode);
        float stability = 1.0f - (float)vMax / 5.0f;
        substrate.setProperty("ACCUMULATION", String.valueOf(accumulation));
        substrate.setProperty("STABILITY", String.valueOf(stability));
        substrate.setProperty("TRANSMISSIVITY", String.valueOf(substrateTransmissivity));
    }

    private void removeAccumulation(Float substrateAccumulation, String synthesisCode, String treeRootSynthesisCode) {
        Map<Float, List<String>> accumulationsSynthesisCodesMap = this.treeRootAccumulationsSynthesisCodesMap.get(treeRootSynthesisCode);
        if (accumulationsSynthesisCodesMap.containsKey(substrateAccumulation)) {
            List<String> synthesisCodes = accumulationsSynthesisCodesMap.get(substrateAccumulation);
            if (synthesisCode != null) {
                synthesisCodes.remove(synthesisCode);
                if (synthesisCodes.isEmpty()) {
                    accumulationsSynthesisCodesMap.remove(substrateAccumulation);
                }
            }
        }
        this.treeRootAccumulationsMap.get(treeRootSynthesisCode).remove(substrateAccumulation);
        this.treeRootSynthesisCodeAccumulationMap.get(treeRootSynthesisCode).remove(synthesisCode);
        this.treeRootSynshesisCodeLeafAccumulationMap.get(treeRootSynthesisCode).remove(synthesisCode);
    }

    public void removeAccumulations(Iterator<Molecule> iterator) {
        while (iterator.hasNext()) {
            Molecule molecule = iterator.next();
            String accu = molecule.getProperty("ACCUMULATION");
            Float accumulation = accu == null ? new Float(0.0f) : Float.valueOf(accu);
            String synthesisCode = molecule.getProperty("Synthesis Code");
            String treeRootSynthesisCode = molecule.getProperty("Synthesis Code");
            this.removeAccumulation(accumulation, synthesisCode, treeRootSynthesisCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAccumulations(List<Molecule> list) {
        List<Molecule> list2 = list;
        synchronized (list2) {
            this.removeAccumulations(list.iterator());
        }
    }

    public void setAccumulations(Molecule[] molecules) {
        this.clear();
        for (int i = 0; i < molecules.length; ++i) {
            this.addAccumulation(molecules[i]);
        }
        for (String rootSynthesisCodes : this.treeRootSynthesisCodeAccumulationMap.keySet()) {
            this.recalculateMaxPathAccumulations(rootSynthesisCodes);
        }
    }

    public void setAccumulations(Iterator<Molecule> iterator) {
        this.clear();
        while (iterator.hasNext()) {
            this.addAccumulation(iterator.next());
        }
        for (String rootSynthesisCodes : this.treeRootSynthesisCodeAccumulationMap.keySet()) {
            this.recalculateMaxPathAccumulations(rootSynthesisCodes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAccumulations(List<Molecule> list) {
        List<Molecule> list2 = list;
        synchronized (list2) {
            this.setAccumulations(list.iterator());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAccumulations(Iterable<Molecule> iterable) {
        Iterable<Molecule> iterable2 = iterable;
        synchronized (iterable2) {
            this.setAccumulations(iterable.iterator());
        }
    }

    private void addAccumulation(Molecule molecule) {
        String accumulation = molecule.getProperty("ACCUMULATION");
        String production = molecule.getProperty("PRODUCTION");
        String synthesisCode = molecule.getProperty("Synthesis Code");
        String treeRootSynthesisCode = molecule.getProperty("METABOLIC_TREE_COUNT");
        Float accu = new Float(accumulation == null ? "0" : accumulation);
        Float prod = new Float(production == null ? "0" : production);
        this.addAccumulation(accu, synthesisCode, treeRootSynthesisCode);
        this.addProduction(prod, treeRootSynthesisCode);
    }

    private void addProduction(Float prod, String treeRootSynthesisCode) {
        if (!this.treeRootMaxProductionMap.containsKey(treeRootSynthesisCode) || this.treeRootMaxProductionMap.get(treeRootSynthesisCode).floatValue() < prod.floatValue()) {
            this.treeRootMaxProductionMap.put(treeRootSynthesisCode, prod);
        }
    }

    private void addAccumulation(Float accu, String synthesisCode, String treeRootSynthesisCode) {
        Map<Object, Object> leafAccumulationMap;
        Map<Object, Object> accumulationsSynthesisCodesMap;
        if (this.treeRootAccumulationsMap.containsKey(treeRootSynthesisCode)) {
            this.treeRootAccumulationsMap.get(treeRootSynthesisCode).add(accu);
        } else {
            List<Float> accumulations = Collections.synchronizedList(new ArrayList());
            accumulations.add(accu);
            this.treeRootAccumulationsMap.put(treeRootSynthesisCode, accumulations);
        }
        if (this.treeRootAccumulationsSynthesisCodesMap.containsKey(treeRootSynthesisCode)) {
            accumulationsSynthesisCodesMap = this.treeRootAccumulationsSynthesisCodesMap.get(treeRootSynthesisCode);
        } else {
            accumulationsSynthesisCodesMap = new HashMap();
            this.treeRootAccumulationsSynthesisCodesMap.put(treeRootSynthesisCode, accumulationsSynthesisCodesMap);
        }
        if (accumulationsSynthesisCodesMap.containsKey(accu)) {
            ((List)accumulationsSynthesisCodesMap.get(accu)).add(synthesisCode);
        } else {
            List<String> synthesisCodes = Collections.synchronizedList(new ArrayList());
            synthesisCodes.add(synthesisCode);
            accumulationsSynthesisCodesMap.put(accu, synthesisCodes);
        }
        if (this.treeRootSynthesisCodeAccumulationMap.containsKey(treeRootSynthesisCode)) {
            this.treeRootSynthesisCodeAccumulationMap.get(treeRootSynthesisCode).put(synthesisCode, accu);
        } else {
            HashMap<String, Float> synthesisCodeAccumulationMap = new HashMap<String, Float>();
            synthesisCodeAccumulationMap.put(synthesisCode, accu);
            this.treeRootSynthesisCodeAccumulationMap.put(treeRootSynthesisCode, synthesisCodeAccumulationMap);
        }
        if (this.treeRootSynshesisCodeLeafAccumulationMap.containsKey(treeRootSynthesisCode)) {
            leafAccumulationMap = this.treeRootSynshesisCodeLeafAccumulationMap.get(treeRootSynthesisCode);
        } else {
            leafAccumulationMap = new HashMap();
            this.treeRootSynshesisCodeLeafAccumulationMap.put(treeRootSynthesisCode, leafAccumulationMap);
        }
        leafAccumulationMap.put(synthesisCode, accu);
    }

    private void recalculateMaxPathAccumulations(String treeRootSynthesisCode) {
        Map<Object, Object> synthesisCodesAccumulationByPath;
        if (this.treeRootSynthesisCodesAccumulationByPathMap.containsKey(treeRootSynthesisCode)) {
            synthesisCodesAccumulationByPath = this.treeRootSynthesisCodesAccumulationByPathMap.get(treeRootSynthesisCode);
        } else {
            synthesisCodesAccumulationByPath = new HashMap();
            this.treeRootSynthesisCodesAccumulationByPathMap.put(treeRootSynthesisCode, synthesisCodesAccumulationByPath);
        }
        synthesisCodesAccumulationByPath.clear();
        Map<String, Float> leafAccumulationMap = this.treeRootSynshesisCodeLeafAccumulationMap.get(treeRootSynthesisCode);
        if (leafAccumulationMap != null) {
            for (String synthesisCode : leafAccumulationMap.keySet()) {
                Float accu = leafAccumulationMap.get(synthesisCode);
                String synthCode = synthesisCode;
                while (synthCode.length() != 0) {
                    if (!synthesisCodesAccumulationByPath.containsKey(synthCode) || ((Float)synthesisCodesAccumulationByPath.get(synthCode)).floatValue() < accu.floatValue()) {
                        synthesisCodesAccumulationByPath.put(synthCode, accu);
                    }
                    int firstIndex = synthCode.indexOf(40);
                    int lastIndex = synthCode.lastIndexOf(41);
                    synthCode = firstIndex == -1 || lastIndex == -1 ? "" : synthCode.substring(firstIndex + 1, lastIndex);
                }
            }
        }
    }

    public List<String> getMajorMetaboliteSynthesisCodeList() {
        return this.getMajorMetaboliteSynthesisCodeList(0.0f);
    }

    public String[] getMajorMetaboliteSynthesisCodes() {
        return this.getMajorMetaboliteSynthesisCodes(0.0f);
    }

    public String[] getMajorMetaboliteSynthesisCodes(float tolerance) {
        List<String> synthesisCodeList = this.getMajorMetaboliteSynthesisCodeList(tolerance);
        return synthesisCodeList.toArray(new String[synthesisCodeList.size()]);
    }

    public List<String> getMajorMetaboliteSynthesisCodeList(float tolerance) {
        ArrayList<String> synthesisCodes = new ArrayList<String>();
        for (String treeRootSynthesisCode : this.treeRootAccumulationsSynthesisCodesMap.keySet()) {
            Float maxAccumulation = new Float(this.calculateMaxAccumulation(treeRootSynthesisCode));
            if (tolerance == 0.0f) {
                return this.treeRootAccumulationsSynthesisCodesMap.get(treeRootSynthesisCode).get(maxAccumulation);
            }
            float accumulationTolerance = maxAccumulation.floatValue() * tolerance;
            Map<Float, List<String>> accumulationsSynthesisCodesMap = this.treeRootAccumulationsSynthesisCodesMap.get(treeRootSynthesisCode);
            for (Float next : accumulationsSynthesisCodesMap.keySet()) {
                float accu = next.floatValue();
                if (!(maxAccumulation.floatValue() - accu <= accumulationTolerance)) continue;
                synthesisCodes.addAll((Collection<String>)accumulationsSynthesisCodesMap.get(next));
            }
        }
        return synthesisCodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private float calculateMaxAccumulation(String treeRootSynthesisCode) {
        List<Float> accumulations = this.treeRootAccumulationsMap.get(treeRootSynthesisCode);
        float maxAccumulation = 0.0f;
        if (accumulations != null) {
            List<Float> list = accumulations;
            synchronized (list) {
                Collections.sort(accumulations);
                maxAccumulation = accumulations.get(accumulations.size() - 1).floatValue();
            }
        }
        return maxAccumulation;
    }

    public int calculateAccumulationCategory(String treeRootSynthesisCode, String synthesisCode) {
        return this.calculateAccumulationCategory(treeRootSynthesisCode, synthesisCode, 1.0f, 10.0f);
    }

    public int calculateAccumulationCategory(String treeRootSynthesisCode, String synthesisCode, float minimumRange, float maximumRange) {
        float accumulation = this.treeRootSynthesisCodeAccumulationMap.containsKey(treeRootSynthesisCode) && this.treeRootSynthesisCodeAccumulationMap.get(treeRootSynthesisCode).containsKey(synthesisCode) ? this.treeRootSynthesisCodeAccumulationMap.get(treeRootSynthesisCode).get(synthesisCode).floatValue() : 1.0f;
        return this.calculateAccuCategory(treeRootSynthesisCode, minimumRange, maximumRange, accumulation);
    }

    public float[] getCategoryBorderRanges(String treeRootSynthesisCode, float minimumRange, float maximumRange) {
        float minRange = 0.01f * minimumRange;
        float maxRange = 0.01f * maximumRange;
        float top = 1.0f - maxRange;
        float diff = (top - minRange) / 3.0f;
        float border1 = top - diff;
        float border2 = top - 2.0f * diff;
        return new float[]{minRange, border2, border1, top};
    }

    private int calculateAccuCategory(String treeRootSynthesisCode, float minimumRange, float maximumRange, float accumulation) {
        float maxAccumulation = this.calculateMaxAccumulation(treeRootSynthesisCode);
        return this.calculateCategory(minimumRange, maximumRange, accumulation, maxAccumulation);
    }

    private int calculateCategory(float minimumRange, float maximumRange, float accumulation, float maxAccumulation) {
        float percent = accumulation / maxAccumulation;
        float minRange = 0.01f * minimumRange;
        float maxRange = 0.01f * maximumRange;
        float top = 1.0f - maxRange;
        float diff = (top - minRange) / 3.0f;
        float border1 = top - diff;
        float border2 = top - 2.0f * diff;
        int dominance = 0;
        if (percent >= top) {
            dominance = 5;
        } else if (percent <= minRange) {
            dominance = 1;
        } else if (percent < top && percent >= border1) {
            dominance = 4;
        } else if (percent < border1 && percent >= border2) {
            dominance = 3;
        } else if (percent < border2 && percent > minRange) {
            dominance = 2;
        }
        return dominance > 0 ? dominance : 1;
    }

    public int calculateAccumulationByPathCategory(String treeRootSynthesisCode, String synthesisCode, float minimumRange, float maximumRange) {
        if (this.treeRootSynthesisCodesAccumulationByPathMap.containsKey(treeRootSynthesisCode)) {
            Float accu = this.treeRootSynthesisCodesAccumulationByPathMap.get(treeRootSynthesisCode).get(synthesisCode);
            return accu == null ? 1 : this.calculateAccuCategory(treeRootSynthesisCode, minimumRange, maximumRange, accu.floatValue());
        }
        return 1;
    }

    public int calculateProductionCategory(float production, String treeRootSynthesisCode) {
        return this.calculateProductionCategory(production, treeRootSynthesisCode, 0.0f, 0.0f);
    }

    public int calculateProductionCategory(float production, String treeRootSynthesisCode, float minimumRange, float maximumRange) {
        return this.calculateCategory(minimumRange, maximumRange, production, this.treeRootMaxProductionMap.containsKey(treeRootSynthesisCode) ? this.treeRootMaxProductionMap.get(treeRootSynthesisCode).floatValue() : 1.0f);
    }

    public static float calculateSpeedFromSpeedCategory(int speedCategory) {
        return (float)Math.pow(10.0, speedCategory);
    }

    public List<Molecule> calculateMajorMetaboliteList(Molecule[] metabolites) {
        return this.calculateMajorMetaboliteList(metabolites, 0.0f);
    }

    public List<Molecule> calculateMajorMetaboliteList(Molecule[] metabolites, float tolerance) {
        return this.calculateMajorMetaboliteList(Arrays.asList(metabolites), tolerance);
    }

    public List<Molecule> calculateMajorMetaboliteList(List<Molecule> metabolites) {
        return this.calculateMajorMetaboliteList(metabolites, 0.0f);
    }

    public List<Molecule> calculateMajorMetaboliteList(List<Molecule> metabolites, float tolerance) {
        this.setAccumulations(metabolites.toArray(new Molecule[metabolites.size()]));
        Iterator<Molecule> iterator = metabolites.iterator();
        List<Molecule> majorMetabolites = this.calculateMajorMetaboliteList(iterator, tolerance);
        return majorMetabolites;
    }

    public List<Molecule> calculateMajorMetaboliteList(Iterator<Molecule> iterator, float tolerance) {
        ArrayList<Molecule> majorMetabolites = new ArrayList<Molecule>();
        while (iterator.hasNext()) {
            Molecule molecule = iterator.next();
            String treeRootSynthesisCode = molecule.getProperty("METABOLIC_TREE_COUNT");
            float maxAccu = this.calculateMaxAccumulation(treeRootSynthesisCode);
            float metabolicTolerance = maxAccu * tolerance;
            float accu = 0.0f;
            String accumulation = molecule.getProperty("ACCUMULATION");
            if (accumulation != null) {
                accu = Float.parseFloat(accumulation);
            }
            if (!(maxAccu - accu <= metabolicTolerance)) continue;
            majorMetabolites.add(molecule);
        }
        return majorMetabolites;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Molecule> calculateMajorMetaboliteList(Iterable<Molecule> iterable, float tolerance) {
        Iterable<Molecule> iterable2 = iterable;
        synchronized (iterable2) {
            return this.calculateMajorMetaboliteList(iterable.iterator(), tolerance);
        }
    }

    public Molecule[] calculateMajorMetabolites(Molecule[] metabolites) {
        return this.calculateMajorMetabolites(metabolites, 0.0f);
    }

    public Molecule[] calculateMajorMetabolites(Molecule[] metabolites, float tolerance) {
        List<Molecule> majorMetaboliteList = this.calculateMajorMetaboliteList(metabolites, tolerance);
        return majorMetaboliteList.toArray(new Molecule[majorMetaboliteList.size()]);
    }

    public Molecule[] calculateMajorMetabolites(List<Molecule> metabolites) {
        return this.calculateMajorMetabolites(metabolites, 0.0f);
    }

    public Molecule[] calculateMajorMetabolites(List<Molecule> metabolites, float tolerance) {
        List<Molecule> majorMetaboliteList = this.calculateMajorMetaboliteList(metabolites);
        return majorMetaboliteList.toArray(new Molecule[majorMetaboliteList.size()]);
    }

    public Molecule[] calculateMajorMetabolites(Iterator<Molecule> iterator, float tolerance) {
        List<Molecule> majorMetaboliteList = this.calculateMajorMetaboliteList(iterator, tolerance);
        return this.calculateMajorMetaboliteList(iterator, tolerance).toArray(new Molecule[majorMetaboliteList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Molecule[] calculateMajorMetabolites(Iterable<Molecule> iterable, float tolerance) {
        Iterable<Molecule> iterable2 = iterable;
        synchronized (iterable2) {
            return this.calculateMajorMetabolites(iterable.iterator(), tolerance);
        }
    }

    public Map<String, String> generateDominanceMap(Iterator<Molecule> iterator) {
        HashMap<String, String> dominanceMap = new HashMap<String, String>();
        HashMap<String, Molecule> parentMap = new HashMap<String, Molecule>();
        HashMap<String, List<Molecule>> parentChildrenMap = new HashMap<String, List<Molecule>>();
        String lastParentCode = null;
        while (iterator.hasNext()) {
            Molecule molecule = iterator.next();
            String synthesisCode = molecule.getProperty("Synthesis Code");
            String parentCode = molecule.getProperty("METABOLIZER_PARENTSYNTHESISCODE");
            if (parentCode != null) {
                List<Molecule> children;
                if (lastParentCode == null || !lastParentCode.equals(parentCode)) {
                    if (lastParentCode != null && parentMap.containsKey(lastParentCode)) {
                        this.addDatasToDominanceMap(dominanceMap, parentMap, parentChildrenMap, lastParentCode);
                    }
                    lastParentCode = parentCode;
                }
                if (!parentChildrenMap.containsKey(parentCode)) {
                    children = new ArrayList<Molecule>();
                    children.add(molecule);
                    parentChildrenMap.put(parentCode, children);
                } else {
                    children = (List)parentChildrenMap.get(parentCode);
                    children.add(molecule);
                }
            }
            if (synthesisCode == null) continue;
            parentMap.put(synthesisCode, molecule);
        }
        if (!parentChildrenMap.isEmpty() && lastParentCode != null && parentMap.containsKey(lastParentCode)) {
            this.addDatasToDominanceMap(dominanceMap, parentMap, parentChildrenMap, lastParentCode);
        }
        return dominanceMap;
    }

    private void addDatasToDominanceMap(Map<String, String> dominanceMap, Map<String, Molecule> parentMap, Map<String, List<Molecule>> parentChildrenMap, String lastParentCode) {
        List<Molecule> children = parentChildrenMap.get(lastParentCode);
        this.calculateDominance(parentMap.get(lastParentCode), children.toArray(new Molecule[children.size()]));
        dominanceMap.put(lastParentCode, parentMap.get(lastParentCode).getProperty("ACCUMULATION"));
        for (Molecule child : children) {
            dominanceMap.put(child.getProperty("Synthesis Code"), child.getProperty("ACCUMULATION"));
        }
        children.clear();
        parentChildrenMap.remove(lastParentCode);
        parentMap.remove(lastParentCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> generateDominanceMap(Iterable<Molecule> iterable) {
        Iterable<Molecule> iterable2 = iterable;
        synchronized (iterable2) {
            return this.generateDominanceMap(iterable.iterator());
        }
    }

    public void clear() {
        this.treeRootAccumulationsMap.clear();
        this.treeRootAccumulationsSynthesisCodesMap.clear();
        this.treeRootSynthesisCodeAccumulationMap.clear();
        this.treeRootSynthesisCodesAccumulationByPathMap.clear();
        this.treeRootMaxProductionMap.clear();
        this.treeRootSynshesisCodeLeafAccumulationMap.clear();
    }

    public void removeTreeData(String rootSynthesisCode) {
        this.treeRootAccumulationsMap.remove(rootSynthesisCode);
        this.treeRootAccumulationsSynthesisCodesMap.remove(rootSynthesisCode);
        this.treeRootMaxProductionMap.remove(rootSynthesisCode);
        this.treeRootSynshesisCodeLeafAccumulationMap.remove(rootSynthesisCode);
        this.treeRootSynthesisCodeAccumulationMap.remove(rootSynthesisCode);
        this.treeRootSynthesisCodesAccumulationByPathMap.remove(rootSynthesisCode);
    }
}

