/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.metabolizer;

import chemaxon.formats.MolExporter;
import chemaxon.metabolizer.MetabolizerExporter;
import chemaxon.metabolizer.MetabolizerIOException;
import chemaxon.struc.Molecule;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class MetabolizerFileExporter
implements MetabolizerExporter {
    private MolExporter exporter;
    private FileOutputStream outputStream;
    private File output;

    public MetabolizerFileExporter(File output, String format2) throws MetabolizerIOException {
        this.output = output;
        try {
            this.outputStream = new FileOutputStream(output);
            this.exporter = new MolExporter(this.outputStream, format2);
        }
        catch (IOException exception) {
            throw new MetabolizerIOException(exception);
        }
    }

    public MetabolizerFileExporter(String outputPath, String format2) throws MetabolizerIOException {
        this.output = new File(outputPath);
        try {
            this.outputStream = new FileOutputStream(this.output);
            this.exporter = new MolExporter(this.outputStream, format2);
        }
        catch (IOException exception) {
            throw new MetabolizerIOException(exception);
        }
    }

    @Override
    public void export(Molecule molecule) throws MetabolizerIOException {
        try {
            this.exporter.write(molecule);
        }
        catch (IOException exception) {
            throw new MetabolizerIOException("Error while exporting molecule.", exception);
        }
    }

    @Override
    public void close() throws MetabolizerIOException {
        try {
            this.exporter.close();
            this.outputStream.close();
        }
        catch (IOException exception) {
            throw new MetabolizerIOException(exception);
        }
    }
}

