/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.metabolizer;

import chemaxon.formats.MolImporter;
import chemaxon.metabolizer.MetabolizerIOException;
import chemaxon.metabolizer.MetabolizerImporter;
import chemaxon.struc.Molecule;
import java.io.File;
import java.io.IOException;

public class MetabolizerFileImporter
implements MetabolizerImporter {
    private MolImporter importer;
    private File input;
    private long molCount;
    private int moleculeIterator;

    public MetabolizerFileImporter(File input) throws MetabolizerIOException {
        this.input = input;
        this.initialize();
    }

    public MetabolizerFileImporter(String path) throws MetabolizerIOException {
        this.input = new File(path);
        this.initialize();
    }

    private void initialize() throws MetabolizerIOException {
        try {
            this.importer = new MolImporter(this.input, "smiles");
            this.molCount = 0L;
            while (this.importer.skipRecord()) {
                ++this.molCount;
            }
            this.importer.close();
            this.importer = new MolImporter(this.input, "smiles");
            this.moleculeIterator = 0;
        }
        catch (IOException exception) {
            throw new MetabolizerIOException(exception);
        }
    }

    @Override
    public long getMoleculeCount() throws MetabolizerIOException {
        return this.molCount;
    }

    @Override
    public Molecule next() throws MetabolizerIOException {
        Molecule molecule;
        try {
            molecule = this.importer.read();
        }
        catch (IOException exception) {
            throw new MetabolizerIOException(exception);
        }
        ++this.moleculeIterator;
        return molecule;
    }

    @Override
    public boolean hasNext() throws MetabolizerIOException {
        return (long)this.moleculeIterator != this.molCount;
    }

    @Override
    public void close() throws MetabolizerIOException {
        try {
            this.importer.close();
        }
        catch (IOException exception) {
            throw new MetabolizerIOException(exception);
        }
    }
}

