/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.metabolizer;

import chemaxon.reaction.ReactionException;
import chemaxon.reaction.Reactor;
import chemaxon.struc.Molecule;
import chemaxon.struc.RxnMolecule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class MetabolizerJob {
    private RxnMolecule[] reactions;
    private Reactor[] reactors;
    private boolean isMultiReactorMode;

    public void initializeJob(RxnMolecule[] reactions, boolean isMultiReactorMode) throws ReactionException {
        this.reactions = reactions;
        if (!isMultiReactorMode) {
            this.reactors = new Reactor[]{new Reactor()};
        } else {
            this.reactors = new Reactor[reactions.length];
            for (int i = 0; i < reactions.length; ++i) {
                this.reactors[i].setReaction(reactions[i]);
            }
        }
    }

    public Map<Integer, Molecule[]> calculateParalel(List<Molecule[]> reacts, int pahseLimit) throws ReactionException {
        HashMap<Integer, Molecule[]> products = new HashMap<Integer, Molecule[]>();
        List<Molecule[]> reactants = reacts;
        for (int i = 0; i < pahseLimit; ++i) {
            for (int j = 0; j < this.reactions.length; ++j) {
                if (this.isMultiReactorMode) {
                    this.reactors[0].setReaction(this.reactions[j]);
                }
                Iterator<Molecule[]> reactantsIterator = reactants.iterator();
                while (reactantsIterator.hasNext()) {
                    Molecule[] tempProducts;
                    this.reactors[this.isMultiReactorMode ? j : 0].setReactants(reactantsIterator.next());
                    while ((tempProducts = this.reactors[this.isMultiReactorMode ? j : 0].react()) != null) {
                        products.put(i, tempProducts);
                    }
                }
            }
            reactants = new ArrayList(products.values());
        }
        return products;
    }

    public List<Molecule> calculateSequential(Molecule[] reactants) {
        LinkedList<Molecule> products = new LinkedList<Molecule>();
        return products;
    }
}

