/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.metabolizer;

import chemaxon.metabolizer.MetabolizerExporter;
import chemaxon.metabolizer.MetabolizerIOException;
import chemaxon.struc.Molecule;
import java.util.List;

public class MetabolizerMemoryExporter
implements MetabolizerExporter {
    private List<Molecule> metabolites;

    public MetabolizerMemoryExporter(List<Molecule> metabolites) throws MetabolizerIOException {
        if (metabolites == null) {
            throw new MetabolizerIOException("Can not initialized with null");
        }
        this.metabolites = metabolites;
    }

    @Override
    public void export(Molecule molecule) throws MetabolizerIOException {
        if (this.metabolites == null) {
            throw new MetabolizerIOException("Uninitialized or closed exporter");
        }
        this.metabolites.add(molecule);
    }

    @Override
    public void close() throws MetabolizerIOException {
        this.metabolites = null;
    }
}

