/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.metabolizer;

import chemaxon.metabolizer.MetabolizerIOException;
import chemaxon.metabolizer.MetabolizerImporter;
import chemaxon.struc.Molecule;
import java.util.Iterator;
import java.util.List;

public class MetabolizerMemoryImporter
implements MetabolizerImporter {
    private List<Molecule> substrates;
    private Iterator<Molecule> substrateIterator;

    public MetabolizerMemoryImporter(List<Molecule> substrates) throws MetabolizerIOException {
        if (substrates == null) {
            throw new MetabolizerIOException("Can not initialized with null");
        }
        this.substrates = substrates;
        this.substrateIterator = substrates.iterator();
    }

    @Override
    public long getMoleculeCount() throws MetabolizerIOException {
        return this.substrates == null ? 0L : (long)this.substrates.size();
    }

    @Override
    public Molecule next() throws MetabolizerIOException {
        return this.substrateIterator == null ? null : this.substrateIterator.next();
    }

    @Override
    public boolean hasNext() throws MetabolizerIOException {
        return this.substrateIterator == null ? false : this.substrateIterator.hasNext();
    }

    @Override
    public void close() throws MetabolizerIOException {
        this.substrates = null;
    }
}

