/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.metabolizer;

import chemaxon.metabolizer.MetabolizerExporter;
import chemaxon.metabolizer.MetabolizerIOException;
import chemaxon.metabolizer.MetabolizerImporter;
import chemaxon.metabolizer.MetabolizerMemoryExporter;
import chemaxon.metabolizer.MetabolizerMemoryImporter;
import chemaxon.metabolizer.MetabolizerTemporaryStorage;
import chemaxon.struc.Molecule;
import java.util.ArrayList;
import java.util.List;

public class MetabolizerTemporaryMemoryStorage
implements MetabolizerTemporaryStorage {
    private List<Molecule> substrates = new ArrayList<Molecule>();
    private List<Molecule> metabolites = new ArrayList<Molecule>();
    private MetabolizerImporter substrateImporter;
    private MetabolizerExporter metabolitExporter;

    @Override
    public MetabolizerExporter getExporter() throws MetabolizerIOException {
        this.metabolitExporter = new MetabolizerMemoryExporter(this.metabolites);
        return this.metabolitExporter;
    }

    @Override
    public MetabolizerImporter getImporter() throws MetabolizerIOException {
        this.substrateImporter = new MetabolizerMemoryImporter(this.substrates);
        return this.substrateImporter;
    }

    @Override
    public void newIteration() {
        this.substrates.clear();
        this.substrates = this.metabolites;
        this.metabolites = new ArrayList<Molecule>();
    }

    @Override
    public void close() throws MetabolizerIOException {
        if (this.substrateImporter != null) {
            this.substrateImporter.close();
        }
        if (this.metabolitExporter != null) {
            this.metabolitExporter.close();
        }
        this.substrates.clear();
        this.metabolites.clear();
    }
}

