/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.metabolizer;

import chemaxon.formats.MolExporter;
import chemaxon.formats.MolImporter;
import chemaxon.marvin.io.SeekableInputStream;
import chemaxon.metabolizer.Metabolizer;
import chemaxon.metabolizer.MetabolizerCalculator;
import chemaxon.metabolizer.MetabolizerException;
import chemaxon.struc.Molecule;
import chemaxon.struc.RxnMolecule;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class MetabolizerUtilities {
    private boolean canceled = false;

    public boolean isCanceled() {
        return this.canceled;
    }

    public void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    public void cancel() {
        this.setCanceled(true);
    }

    public void generateMetabolites(Metabolizer metabolizer, File outputFile, String outputFormat, String outputType) throws MetabolizerException {
        try {
            FileOutputStream outputStream = new FileOutputStream(outputFile);
            this.generateMetabolites(metabolizer, outputStream, outputFormat, outputType);
            ((OutputStream)outputStream).close();
        }
        catch (IOException exception) {
            throw new MetabolizerException(exception);
        }
    }

    public void generateMetabolites(Metabolizer metabolizer, OutputStream outputStream, String outputFormat, String outputType) throws MetabolizerException {
        try {
            boolean isOutputTypeReaction = outputType.equals("reaction");
            MolExporter output = new MolExporter(outputStream, outputFormat);
            while (metabolizer.hasMoreLevel() && !this.canceled) {
                while (!metabolizer.isCurrentLevelEnded() && !this.canceled) {
                    Molecule[] molecules = metabolizer.next();
                    if (molecules == null) continue;
                    for (int i = 0; i < molecules.length && !this.canceled; ++i) {
                        if (isOutputTypeReaction || !(molecules[i] instanceof RxnMolecule)) {
                            output.write(molecules[i]);
                            continue;
                        }
                        MetabolizerUtilities.copyProperties(molecules[i], ((RxnMolecule)molecules[i]).getProduct(0));
                        output.write(((RxnMolecule)molecules[i]).getProduct(0));
                    }
                }
                metabolizer.nextLevel();
            }
            output.close();
            outputStream.flush();
        }
        catch (Exception exception) {
            throw new MetabolizerException(exception);
        }
    }

    public void generateMetabolitesWithChildDepth(Metabolizer metabolizer, File outputFile, String outputFormat, String outputType) throws MetabolizerException {
        File temp = this.generateMetabolitesToTempFile(metabolizer, outputFormat, outputType);
        this.generateChildDepth(temp, outputFile, outputFormat);
    }

    public void generateMetabolitesWithChildDepth(Metabolizer metabolizer, OutputStream outputStream, String outputFormat, String outputType) throws MetabolizerException {
        File temp = this.generateMetabolitesToTempFile(metabolizer, outputFormat, outputType);
        try {
            SeekableInputStream inputStream = new SeekableInputStream(temp);
            this.generateChildDepth(inputStream, outputStream, outputFormat);
        }
        catch (IOException exception) {
            throw new MetabolizerException(exception);
        }
    }

    public void generateMetabolitesWithChildDepth(Metabolizer metabolizer, MolExporter exporter, String outputFormat, String outputType) throws MetabolizerException {
        try {
            File temp = File.createTempFile("metabolizer", "temp");
            this.generateMetabolitesWithChildDepth(metabolizer, temp, outputFormat, outputType);
            MolImporter importer = new MolImporter(temp.getAbsolutePath());
            Molecule tempMol = null;
            while ((tempMol = importer.read()) != null) {
                exporter.write(tempMol);
            }
        }
        catch (IOException exception) {
            throw new MetabolizerException(exception);
        }
    }

    private File generateMetabolitesToTempFile(Metabolizer metabolizer, String outputFormat, String outputType) throws MetabolizerException {
        File temp;
        try {
            temp = File.createTempFile("metabolizer", "temp");
            temp.deleteOnExit();
        }
        catch (IOException exception) {
            throw new MetabolizerException(exception);
        }
        this.generateMetabolites(metabolizer, temp, outputFormat, outputType);
        return temp;
    }

    public void generateChildDepth(File inputFile, File outputFile, String outputFormat) throws MetabolizerException {
        try {
            SeekableInputStream inputStream = new SeekableInputStream(inputFile);
            FileOutputStream outputStream = new FileOutputStream(outputFile);
            this.generateChildDepth(inputStream, outputStream, outputFormat);
        }
        catch (IOException exception) {
            throw new MetabolizerException(exception);
        }
    }

    public void generateChildDepth(InputStream inputStream, OutputStream outputStream, String outputFormat) throws MetabolizerException {
        try {
            Molecule tempMol;
            HashMap<String, String> parentMap = new HashMap<String, String>();
            HashMap<String, String> levelMap = new HashMap<String, String>();
            MolImporter importer = new MolImporter(inputStream);
            while ((tempMol = importer.read()) != null && !this.canceled) {
                String parentSynthesisCode = tempMol.getProperty("METABOLIZER_PARENTSYNTHESISCODE");
                levelMap.put(tempMol.getProperty("Synthesis Code"), tempMol.getProperty("METABOLIZER_SYNTHESISLEVEL"));
                if (parentSynthesisCode == null || parentMap.containsKey(parentSynthesisCode)) continue;
                parentMap.put(parentSynthesisCode, "1");
                while (!parentSynthesisCode.equals("") && !this.canceled) {
                    if ((parentSynthesisCode = parentSynthesisCode.indexOf(40) != -1 && parentSynthesisCode.indexOf(41) != -1 ? parentSynthesisCode.substring(parentSynthesisCode.indexOf(40) + 1, parentSynthesisCode.lastIndexOf(41)) : "").equals("") || !parentMap.containsKey(parentSynthesisCode) || !levelMap.containsKey(parentSynthesisCode) || Integer.parseInt((String)parentMap.get(parentSynthesisCode)) >= Integer.parseInt(tempMol.getProperty("METABOLIZER_SYNTHESISLEVEL")) - Integer.parseInt((String)levelMap.get(parentSynthesisCode))) continue;
                    parentMap.put(parentSynthesisCode, String.valueOf(Integer.parseInt(tempMol.getProperty("METABOLIZER_SYNTHESISLEVEL")) - Integer.parseInt((String)levelMap.get(parentSynthesisCode))));
                }
            }
            importer.seekRecord(0, null);
            MolExporter exporter = new MolExporter(outputStream, outputFormat);
            while ((tempMol = importer.read()) != null && !this.canceled) {
                String synthCode = tempMol.getProperty("Synthesis Code");
                if (synthCode != null) {
                    tempMol.setProperty("CHILDDEPTH", parentMap.containsKey(synthCode) ? (String)parentMap.get(synthCode) : "-1");
                }
                exporter.write(tempMol);
            }
            importer.close();
            exporter.close();
            outputStream.flush();
        }
        catch (Exception exception) {
            throw new MetabolizerException(exception);
        }
    }

    public void generateMajorMetabolites(Metabolizer metabolizer, OutputStream outputStream, String outputFormat, String outputType, float tolerance) throws MetabolizerException {
        try {
            MolExporter exporter = new MolExporter(outputStream, outputFormat);
            this.generateMajorMetabolites(metabolizer, exporter, outputFormat, outputType, tolerance);
            exporter.close();
            outputStream.flush();
        }
        catch (IOException exception) {
            throw new MetabolizerException(exception);
        }
    }

    public void generateMajorMetabolites(Metabolizer metabolizer, MolExporter exporter, String outputFormat, String outputType, float tolerance) throws MetabolizerException {
        File tempFile = this.generateMetabolitesToTempFile(metabolizer, outputFormat, outputType);
        List<String> synthesisCodes = MetabolizerCalculator.getInstance().getMajorMetaboliteSynthesisCodeList(tolerance);
        try {
            Molecule tempMol;
            MolImporter importer = new MolImporter(tempFile.getAbsolutePath());
            HashMap<String, Molecule> majorMetabolites = new HashMap<String, Molecule>();
            while ((tempMol = importer.read()) != null && !this.canceled) {
                String synthesisCode = tempMol.getProperty("Synthesis Code");
                if (synthesisCode == null || !synthesisCodes.contains(synthesisCode)) continue;
                String smiles = tempMol.toFormat("smiles:q");
                if (majorMetabolites.containsKey(smiles)) {
                    Molecule majorMetabolite = (Molecule)majorMetabolites.get(smiles);
                    float newAccumulation = Float.parseFloat(majorMetabolite.getProperty("ACCUMULATION")) + Float.parseFloat(tempMol.getProperty("ACCUMULATION"));
                    majorMetabolite.setProperty("ACCUMULATION", String.valueOf(newAccumulation));
                    majorMetabolite.setProperty("Synthesis Code", majorMetabolite.getProperty("Synthesis Code") + " " + tempMol.getProperty("Synthesis Code"));
                    majorMetabolite.setProperty("PRODUCTION", null);
                    majorMetabolite.setProperty("METABOLIZER_PARENTSYNTHESISCODE", null);
                    majorMetabolite.setProperty("SPEED_CATEGORY", null);
                    majorMetabolite.setProperty("STABILITY", null);
                    majorMetabolite.setProperty("TRANSMISSIVITY", null);
                    majorMetabolite.setProperty("CHILDDEPTH", null);
                    majorMetabolite.setProperty("METABOLIZER_SYNTHESISLEVEL", null);
                    continue;
                }
                majorMetabolites.put(smiles, tempMol);
            }
            importer.close();
            Iterator iterator = majorMetabolites.values().iterator();
            while (iterator.hasNext()) {
                exporter.write((Molecule)iterator.next());
            }
        }
        catch (IOException exception) {
            throw new MetabolizerException(exception);
        }
    }

    public static void copyProperties(Molecule source, Molecule destination) {
        String[] keys = source.properties().getKeys();
        for (int i = 0; i < keys.length; ++i) {
            destination.setProperty(keys[i], source.getProperty(keys[i]));
        }
    }
}

