/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming;

import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolImporter;
import chemaxon.marvin.io.MolExportException;
import chemaxon.struc.Molecule;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;

public class CsvAnnotator {
    private int inputNameColumn = 8;
    private int inputNameAlternativeColumn = 7;
    private int flagConversionSuccessWith01 = 7;
    private int destinationColumn = 8;
    private BufferedWriter out;

    public static void main(String[] args) {
        new CsvAnnotator(args);
    }

    public CsvAnnotator(String[] args) {
        if (args.length == 0) {
            System.err.println("Missing input file name");
            System.exit(1);
        }
        String inputFileName = args[0];
        if (args.length == 1) {
            System.err.println("Missing ouput file name");
            System.exit(1);
        }
        String outputFileName = args[1];
        try {
            this.out = new BufferedWriter(new FileWriter(outputFileName));
        }
        catch (IOException e) {
            System.err.println("Error opening output file " + outputFileName + ": " + e);
        }
        try {
            this.processFile(inputFileName);
        }
        catch (IOException e) {
            System.err.println("I/O Error while processing " + inputFileName + ": " + e);
        }
    }

    private void processFile(String inputFileName) throws IOException {
        String line;
        BufferedReader r = new BufferedReader(new FileReader(inputFileName));
        while ((line = r.readLine()) != null) {
            try {
                this.processLine(line);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
        this.out.close();
    }

    private void processLine(String line) throws IOException {
        ArrayList<String> columns = CsvAnnotator.readCSV(line);
        this.process(columns);
        this.out.append(this.print(columns)).append('\n');
    }

    private void process(ArrayList<String> columns) {
        String name = this.get(columns, this.inputNameColumn);
        if (name == null || name.equals("")) {
            name = this.get(columns, this.inputNameAlternativeColumn);
        }
        if (name == null) {
            throw new RuntimeException("No name on line: " + columns);
        }
        if (name.startsWith("\"") && name.endsWith("\"")) {
            name = name.substring(1, name.length() - 1);
        }
        try {
            Molecule imported = MolImporter.importMol(name, "name");
            if (imported != null) {
                String smiles = imported.exportToFormat("smiles");
                this.add(columns, this.flagConversionSuccessWith01, "1");
                this.add(columns, this.destinationColumn, smiles);
                return;
            }
        }
        catch (MolFormatException e) {
        }
        catch (MolExportException molExportException) {
            // empty catch block
        }
        this.add(columns, this.flagConversionSuccessWith01, "0");
        this.add(columns, this.destinationColumn, "");
    }

    private String get(ArrayList<String> columns, int column) {
        if (column > columns.size()) {
            return null;
        }
        return columns.get(column - 1);
    }

    private void add(ArrayList<String> columns, int column, String value) {
        columns.add(column - 1, value);
    }

    private String print(ArrayList<String> columns) {
        StringBuilder res = new StringBuilder();
        for (String column : columns) {
            if (res.length() > 0) {
                res.append(',');
            }
            res.append(column);
        }
        return res.toString();
    }

    private static ArrayList<String> readCSV(String line) {
        ArrayList<String> res = new ArrayList<String>();
        if (line.length() == 0) {
            return res;
        }
        while (true) {
            if (line.length() == 0) {
                res.add("");
                break;
            }
            char start = line.charAt(0);
            if (start == '\"') {
                int end = line.indexOf(34, 1);
                if (end == -1) {
                    throw new RuntimeException("Badly formatted CSV line: " + line);
                }
                res.add(line.substring(0, end + 1));
                int comma = line.indexOf(44, end + 1);
                if (comma == -1) break;
                line = line.substring(comma + 1);
                continue;
            }
            int comma = line.indexOf(44);
            if (comma == -1) {
                res.add(line);
                break;
            }
            res.add(line.substring(0, comma));
            line = line.substring(comma + 1);
        }
        return res;
    }
}

