/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.document;

import chemaxon.naming.document.WordReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashSet;

public class HTMLWordReader
extends WordReader {
    static final char breakChar = '\u2008';
    static final HashSet<String> sentenceBreakers = HTMLWordReader.getSentenceBreakers();

    public HTMLWordReader(Reader in) {
        super(in);
    }

    @Override
    int read() throws IOException {
        int res = super.read();
        if (res == 60) {
            String tagName = "";
            while ((res = super.read()) != 62) {
                if (res == -1) {
                    return -1;
                }
                tagName = tagName + (char)res;
            }
            if (HTMLWordReader.breaksSentences(tagName)) {
                this.newSentence = true;
            }
            res = 32;
        }
        return res;
    }

    static HashSet<String> getSentenceBreakers() {
        HashSet<String> res = new HashSet<String>();
        res.addAll(Arrays.asList("ADDRESS", "BLOCKQUOTE", "CENTER", "DIR", "DIV", "DL", "FIELDSET", "FORM", "H1", "H2", "H3", "H4", "H5", "H6", "HR", "ISINDEX", "MENU", "NOFRAMES", "NOSCRIPT", "OL", "P", "PRE", "TABLE", "UL", "DD", "DT", "FRAMESET", "LI", "TBODY", "TD", "TFOOT", "TH", "THEAD", "TR", "A", "ARTICLE", "ASIDE", "DETAILS", "SUMMARY", "FIGURE", "FIGCAPTION", "FOOTER", "HEADER", "HGROUP", "NAV", "SECTION"));
        return res;
    }

    static boolean breaksSentences(String tagName) {
        return sentenceBreakers.contains(tagName.toUpperCase());
    }
}

