/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.document;

import chemaxon.marvin.util.Environment;
import chemaxon.util.LoggingUtil;
import chemaxon.util.ProcessManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.logging.Logger;
import org.apache.commons.exec.CommandLine;

public class OSRA {
    private static final Logger logger = LoggingUtil.getLogger(OSRA.class);
    private static final String osraExecutable = OSRA.getOsraExecutable();
    public static final String OSRA_CONFIDENCE_KEY = "Confidence_Estimate";

    static String getOsraExecutable() {
        String res;
        String osraExe = Environment.MSWINDOWS ? "osra.bat" : "osra";
        String osraEnvVar = System.getenv("OSRA");
        if (osraEnvVar != null && (res = OSRA.getOsraExecutable(osraEnvVar, osraExe)) != null) {
            return res;
        }
        if (OSRA.inPath(osraExe)) {
            return osraExe;
        }
        return null;
    }

    private static String getOsraExecutable(String osraEnvVar, String osraExe) {
        File f = new File(osraEnvVar);
        if (f.isDirectory()) {
            f = new File(f, osraExe);
        }
        if (f.canExecute()) {
            String res = f.getAbsolutePath();
            logger.fine("OSRA path from environment variable: " + res);
            return res;
        }
        if (!f.exists()) {
            logger.severe("The OSRA environment variable denotes a non-existing file: " + osraEnvVar);
        } else {
            logger.severe("The OSRA environment variable denotes a non-executable file: " + osraEnvVar);
        }
        return null;
    }

    private static boolean inPath(String osraExe) {
        try {
            String line;
            Process p = Runtime.getRuntime().exec(osraExe + " --version");
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            boolean available = false;
            while (!available && (line = reader.readLine()) != null) {
                if (!line.toLowerCase().contains("osra")) continue;
                available = true;
            }
            return available &= p.waitFor() == 0;
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static synchronized boolean isAvailable() {
        return osraExecutable != null;
    }

    public static String process(File file) throws IOException {
        if (file == null || !file.exists() || !OSRA.isAvailable()) {
            return null;
        }
        CommandLine commandLine = new CommandLine(osraExecutable);
        commandLine.addArgument("-p");
        commandLine.addArgument("-f");
        commandLine.addArgument("sdf");
        commandLine.addArgument(file.getAbsolutePath());
        ProcessManager p = new ProcessManager(commandLine);
        Integer exitValue = p.waitFor();
        String errors = p.getStderr();
        if (errors != null && errors.length() > 0) {
            logger.warning(errors);
        }
        if (exitValue == null || exitValue != 0) {
            return null;
        }
        String sdf = p.getStdout();
        return sdf;
    }

    public static void main(String[] args) throws IOException {
        System.out.println("OSRA result: " + OSRA.process(new File(args[0])));
    }
}

