/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.document;

import chemaxon.naming.document.D2S;
import chemaxon.naming.document.OCR;
import chemaxon.naming.document.OSRA;
import chemaxon.naming.document.TesseractProcessOCR;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObjectImage;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationMarkup;
import org.apache.pdfbox.util.Matrix;
import org.apache.pdfbox.util.PDFOperator;
import org.apache.pdfbox.util.PDFTextStripper;
import org.apache.pdfbox.util.TextPosition;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.IOExceptionWithCause;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class PDF2XHTML
extends PDFTextStripper {
    private boolean inParagraph = false;
    private final XHTMLContentHandler handler;
    private final boolean extractAnnotationText;
    private D2S.Options options;
    private static final OCR ocr = new TesseractProcessOCR();
    private static final boolean ocrAvailable = ocr.isAvailable();
    private static final Logger logger = Logger.getLogger(PDF2XHTML.class.getName());

    public static void process(PDDocument document, ContentHandler handler, Metadata metadata, boolean extractAnnotationText, boolean enableAutoSpace, boolean suppressDuplicateOverlappingText, boolean sortByPosition, D2S.Options options) throws SAXException, TikaException {
        try {
            new PDF2XHTML(handler, metadata, extractAnnotationText, enableAutoSpace, suppressDuplicateOverlappingText, sortByPosition, options).writeText(document, new Writer(){

                @Override
                public void write(char[] cbuf, int off, int len) {
                }

                @Override
                public void flush() {
                }

                @Override
                public void close() {
                }
            });
        }
        catch (IOException e) {
            if (e.getCause() instanceof SAXException) {
                throw (SAXException)e.getCause();
            }
            throw new TikaException("Unable to extract PDF content", (Throwable)e);
        }
    }

    protected PDF2XHTML(ContentHandler handler, Metadata metadata, boolean extractAnnotationText, boolean enableAutoSpace, boolean suppressDuplicateOverlappingText, boolean sortByPosition, D2S.Options options) throws IOException {
        this.handler = new XHTMLContentHandler(handler, metadata);
        this.extractAnnotationText = extractAnnotationText;
        this.setForceParsing(true);
        this.setSortByPosition(sortByPosition);
        if (enableAutoSpace) {
            this.setWordSeparator(" ");
        } else {
            this.setWordSeparator("");
        }
        this.setSuppressDuplicateOverlappingText(suppressDuplicateOverlappingText);
        this.options = options;
    }

    protected void startDocument(PDDocument pdf) throws IOException {
        try {
            this.handler.startDocument();
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("Unable to start a document", (Throwable)e);
        }
    }

    protected void endDocument(PDDocument pdf) throws IOException {
        try {
            this.handler.endDocument();
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("Unable to end a document", (Throwable)e);
        }
    }

    protected void startPage(PDPage page) throws IOException {
        try {
            this.handler.startElement("div", "class", "page");
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("Unable to start a page", (Throwable)e);
        }
        this.writeParagraphStart();
    }

    protected void endPage(PDPage page) throws IOException {
        try {
            this.writeParagraphEnd();
            if (this.extractAnnotationText) {
                for (Object o : page.getAnnotations()) {
                    if (!(o instanceof PDAnnotation) || !"FreeText".equals(((PDAnnotation)o).getSubtype())) continue;
                    PDAnnotationMarkup annot = (PDAnnotationMarkup)o;
                    String title = annot.getTitlePopup();
                    String subject = annot.getTitlePopup();
                    String contents = annot.getContents();
                    if (title == null && subject == null && contents == null) continue;
                    this.handler.startElement("div", "class", "annotation");
                    if (title != null) {
                        this.handler.startElement("div", "class", "annotationTitle");
                        this.handler.characters(title);
                        this.handler.endElement("div");
                    }
                    if (subject != null) {
                        this.handler.startElement("div", "class", "annotationSubject");
                        this.handler.characters(subject);
                        this.handler.endElement("div");
                    }
                    if (contents != null) {
                        this.handler.startElement("div", "class", "annotationContents");
                        this.handler.characters(contents);
                        this.handler.endElement("div");
                    }
                    this.handler.endElement("div");
                }
            }
            this.handler.endElement("div");
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("Unable to end a page", (Throwable)e);
        }
    }

    protected void writeParagraphStart() throws IOException {
        if (this.inParagraph) {
            this.writeParagraphEnd();
        }
        assert (!this.inParagraph);
        this.inParagraph = true;
        try {
            this.handler.startElement("p");
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("Unable to start a paragraph", (Throwable)e);
        }
    }

    protected void writeParagraphEnd() throws IOException {
        if (!this.inParagraph) {
            this.writeParagraphStart();
        }
        assert (this.inParagraph);
        this.inParagraph = false;
        try {
            this.handler.endElement("p");
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("Unable to end a paragraph", (Throwable)e);
        }
    }

    protected void writeString(String text) throws IOException {
        try {
            this.handler.characters(text);
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("Unable to write a string: " + text, (Throwable)e);
        }
    }

    protected void writeCharacters(TextPosition text) throws IOException {
        try {
            this.handler.characters(text.getCharacter());
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("Unable to write a character: " + text.getCharacter(), (Throwable)e);
        }
    }

    protected void writeWordSeparator() throws IOException {
        try {
            this.handler.characters(this.getWordSeparator());
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("Unable to write a space character", (Throwable)e);
        }
    }

    protected void writeLineSeparator() throws IOException {
        try {
            this.handler.characters("\n");
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("Unable to write a newline character", (Throwable)e);
        }
    }

    protected void processOperator(PDFOperator operator, List arguments) throws IOException {
        super.processOperator(operator, arguments);
        if (!ocrAvailable) {
            return;
        }
        String operation = operator.getOperation();
        if (operation.equals("Do")) {
            COSName objectName = (COSName)arguments.get(0);
            Map xobjects = this.getResources().getXObjects();
            PDXObject xobject = (PDXObject)xobjects.get(objectName.getName());
            if (xobject instanceof PDXObjectImage) {
                try {
                    this.processImage((PDXObjectImage)xobject);
                }
                catch (RuntimeException e) {
                    logger.log(Level.WARNING, "Failure to process image inside document", e);
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "Failure to process image inside document", e);
                }
            }
        }
    }

    private void processImage(PDXObjectImage image) throws IOException {
        File imageFile;
        block9: {
            String sdf;
            PDPage page = this.getCurrentPage();
            Matrix ctm = this.getGraphicsState().getCurrentTransformationMatrix();
            float width = ctm.getXScale();
            float height = ctm.getYScale();
            float imageSurface = width * height;
            PDRectangle pageSize = page.findMediaBox();
            float totalSurface = pageSize.getHeight() * pageSize.getWidth();
            float ratio = imageSurface / totalSurface;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Image takes " + ratio * 100.0f + "% of the page");
            }
            imageFile = null;
            if (this.options.enableOSRA && OSRA.isAvailable() && (sdf = OSRA.process(imageFile = this.writeTemp(image))) != null) {
                try {
                    this.handler.startElement("sdf");
                    this.handler.characters(sdf);
                    this.handler.endElement("sdf");
                }
                catch (SAXException e) {
                    throw new IOException(e);
                }
            }
            if (ratio > 0.8f) {
                if (imageFile == null) {
                    imageFile = this.writeTemp(image);
                }
                try {
                    String ocredText = ocr.process(imageFile);
                    this.writeString(ocredText);
                }
                catch (RuntimeException e) {
                    if (!logger.isLoggable(Level.WARNING)) break block9;
                    logger.log(Level.WARNING, "Failure during processing of page " + this.getCurrentPageNo(), e);
                }
            }
        }
        if (imageFile != null) {
            imageFile.delete();
        }
    }

    private File writeTemp(PDXObjectImage image) throws IOException {
        return PDF2XHTML.writeTemp(image.getRGBImage());
    }

    public static File writeTemp(RenderedImage image) throws IOException {
        File imageFile = File.createTempFile("ChemAxon-image", ".png");
        ImageIO.write(image, "png", imageFile);
        return imageFile;
    }
}

