/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.n2s;

import chemaxon.common.util.BasicEnvironment;
import chemaxon.naming.n2s.NameImportException;
import chemaxon.naming.n2s.Standardize;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.zip.ZipInputStream;

public class DictionaryTable
extends HashMap<String, String> {
    private static final long serialVersionUID = 5594114316379419795L;
    private int longestKey = 0;

    public void addDictionary(String dict, boolean onlyWhenNew, boolean allowExtraData) {
        try {
            this.processDictionary(dict, onlyWhenNew, allowExtraData);
        }
        catch (IOException e) {
            throw new NameImportException.Failure(e);
        }
    }

    public void addUserDictionaryFile(File f) {
        if (!f.exists()) {
            return;
        }
        try {
            this.processStream(new FileInputStream(f), true, false, false, true);
        }
        catch (IOException e) {
            System.err.println("Error reading dictionary file " + f + ": " + e);
        }
    }

    private void putIntoDictionary(String key, String val, boolean onlyWhenNew, boolean override) {
        String[] keyArray = key.split("@");
        if (keyArray.length == 1) {
            this.put(keyArray[0], val, onlyWhenNew, override);
        } else {
            if (keyArray.length == 2) {
                this.put(keyArray[0], val, onlyWhenNew, override);
            }
            for (int i = 1; i < keyArray.length; ++i) {
                this.put(keyArray[0] + keyArray[i], val, onlyWhenNew, override);
            }
        }
    }

    public int getLongestKey() {
        return this.longestKey;
    }

    private void put(String key, String val, boolean onlyWhenNew, boolean override) {
        if (key.endsWith(".")) {
            System.err.println(key + " -> " + val);
        }
        this.longestKey = Math.max(this.longestKey, key.length());
        this.checkCxSmiles(val, key);
        String old = this.put(key, val);
        if (old != null) {
            if (onlyWhenNew) {
                this.put(key, old);
            } else if (!override) {
                System.err.println("\nDuplicate dictionary entries for '" + key + "':\n" + old + "\n" + val);
                String keep = old;
                System.err.println("Using " + keep);
                this.put(key, keep);
            }
        }
    }

    private boolean checkCxSmiles(String val, String key) {
        if (val.contains("|$")) {
            String before = val.substring(0, val.indexOf("|$"));
            if (!before.endsWith(" ")) {
                System.err.println("CXSMILES: no space before |$...$| in >" + val + "<");
                return false;
            }
            String smiles = before.trim();
            if (smiles.length() < before.length() - 1) {
                System.err.println("CXSMILES: extra space before |$...$| for " + key + " in >" + val + "<");
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDictionary(String dictionary, boolean onlyWhenNew, boolean allowExtraData) throws IOException {
        InputStream stream = this.getClass().getResourceAsStream(dictionary + ".smi");
        if (stream == null) {
            stream = this.getClass().getResourceAsStream(dictionary + ".txt");
        }
        if (stream == null) {
            stream = BasicEnvironment.getResourceAsStream(this.getClass(), dictionary + ".cxsmi");
        }
        if (stream != null) {
            this.processStream(stream, false, onlyWhenNew, allowExtraData, true);
            return;
        }
        stream = this.getClass().getResourceAsStream(dictionary + ".zip");
        if (stream != null) {
            ZipInputStream zipstream = new ZipInputStream(stream);
            try {
                while (zipstream.getNextEntry() != null) {
                    this.processStream(zipstream, false, onlyWhenNew, allowExtraData, false);
                }
            }
            finally {
                zipstream.close();
            }
            return;
        }
        throw new IOException("Dictionary file not found: " + dictionary);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processStream(InputStream stream, boolean userData, boolean onlyWhenNew, boolean allowExtraData, boolean close) throws IOException {
        try {
            String input;
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            while ((input = reader.readLine()) != null) {
                this.processLine(input, userData, onlyWhenNew, allowExtraData);
            }
        }
        finally {
            if (close) {
                stream.close();
            }
        }
    }

    private void processLine(String line, boolean userData, boolean onlyWhenNew, boolean allowExtraData) {
        String flags;
        if (line.equals("") || line.startsWith("##")) {
            return;
        }
        String[] data = line.split("\t");
        if (data[0].equals("")) {
            return;
        }
        if (data.length < 2) {
            System.err.println("Dictionary format error, line ignored: " + line);
            return;
        }
        if (!userData && data.length > 3 && data[3].equalsIgnoreCase("false")) {
            return;
        }
        String name = data[1];
        if (userData && (name = Standardize.get(name)).endsWith("ane")) {
            name = name.substring(0, name.length() - 3);
        }
        if (data.length == 2) {
            flags = "";
        } else {
            StringBuilder flagsBuilder = new StringBuilder();
            for (int i = 2; i < data.length; ++i) {
                flagsBuilder.append('\t');
                String flag = data[i];
                if (i == 2 && flag.startsWith("{") && flag.endsWith("}")) {
                    flag = flag.substring(1, flag.length() - 1);
                }
                flagsBuilder.append(flag);
            }
            flags = flagsBuilder.toString();
        }
        if (data[0].endsWith(".")) {
            data[0] = data[0].substring(0, data[0].length() - 1);
            flags = flags + ".";
        }
        this.putIntoDictionary(name, data[0] + flags, onlyWhenNew, userData);
    }
}

