/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.n2s;

import chemaxon.naming.NameConverter;
import chemaxon.naming.NameFormatException;
import chemaxon.naming.n2s.N2S;
import chemaxon.naming.n2s.Util;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.PeriodicSystem;
import java.util.HashMap;
import java.util.Map;

public class ElementConverter
implements NameConverter {
    @Override
    public Molecule convert(String name) throws NameFormatException {
        Integer atno = ElementConverter.fromName(name);
        if (atno == null) {
            return null;
        }
        if (!N2S.getOptions().convertElements) {
            throw new NameFormatException.FilteredCase("Element '" + name + "' not converted as required by configuration");
        }
        Molecule m = Util.newMolecule();
        MolAtom a = new MolAtom(atno);
        a.setValenceProp(0);
        m.add(a);
        return m;
    }

    @Override
    public boolean setPrefixMode(boolean prefixMode) {
        return true;
    }

    public static Integer fromName(String elementName) {
        return NameToAtno.map.get(elementName.toLowerCase());
    }

    private static class NameToAtno {
        public static final Map<String, Integer> map = new HashMap<String, Integer>(200);

        private NameToAtno() {
        }

        static {
            for (int z = PeriodicSystem.getElementCount(); z > 0; --z) {
                map.put(PeriodicSystem.getName(z).toLowerCase(), z);
            }
            map.put("aluminum", map.get("aluminium"));
        }
    }
}

