/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.n2s;

import chemaxon.naming.n2s.Dictionary;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;

public class FastLoadingDictionary
extends Dictionary {
    FastLoadingDictionary() {
        super("/chemaxon/naming/n2s/table1.dat", Dictionary.Type.TRADITIONAL);
    }

    @Override
    void loadDictionaryEntry(HashMap<String, String> targetDict, String line, boolean prefix) throws IOException {
        int start;
        int tab = 0;
        while (line.charAt(tab) != '\t') {
            ++tab;
        }
        String smiles = line.substring(0, tab);
        int i = start = tab + 1;
        while (true) {
            if (i == line.length() || line.charAt(i) == ';') {
                String name = line.substring(start, i);
                if (name.length() > 0) {
                    this.loadEntry(name, smiles, prefix, targetDict);
                }
                if (i == line.length()) {
                    return;
                }
                start = i + 1;
            }
            ++i;
        }
    }

    public static void main(String[] args) throws IOException {
        String line;
        BufferedReader in = new BufferedReader(new FileReader(args[0]));
        BufferedWriter out = new BufferedWriter(new FileWriter(args[1]));
        while ((line = in.readLine()) != null) {
            String[] parts = line.split("\t");
            String smiles = parts[0];
            String[] names = parts[1].split(";");
            FastLoadingDictionary.write(smiles, out);
            for (String name : names) {
                FastLoadingDictionary.write(name, out);
            }
            FastLoadingDictionary.write("", out);
        }
        out.close();
        in.close();
    }

    private static void write(String s, Writer out) throws IOException {
        out.append((char)s.length());
        out.append(s);
    }
}

