/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.n2s;

import chemaxon.naming.n2s.util.AutomatonRewriter;

public class OcrCorrector {
    private static final AutomatonRewriter stage1 = new AutomatonRewriter("lH-", "1H-", "l H", "1H", "lS", "1S", "lR", "1R", "(l-", "(1-", "(l,", "(1,", "(l ,", "(1,", "(l -", "(1-", "( l -", "(1-", "(-l", "(1-", "-l-", "-1-", "-l -", "-1-", "-l ,", "-1,", "- l -", "-1-", "-l,", "-1,", "-l(", "-1(", ",l-", ",1-", ",l ", ",1", "I H", "1H", "IH-", "1H-", "(I ", "(1 ", "lE", "1E", "lZ", "1Z", "yI", "yl", "y I)", "yl)", "y l", "yl", "y\\", "yl", "y1", "yl", "fIuor", "fluor", "- -", "-", "-- ", "-");
    private static final AutomatonRewriter stage2 = new AutomatonRewriter("-y)", "-yl", "-y]", "-yl", "ethy)", "ethyl", "ethy]", "ethyl", "rn", "m", "hn", "im", " 1 ", "1", "d1Hydro", "dihydro");
    private static final AutomatonRewriter stage3 = new AutomatonRewriter("- ", "", "-S-", "-5-", "-s-", "-5-");

    public static String correctOCRerrors(String name) {
        if ((name = stage1.rewriteOverlapping(name)).startsWith("l-") || name.startsWith("l -")) {
            name = "1-" + name.substring(name.indexOf(45) + 1);
        }
        return name;
    }

    public static String correctOCRerrorsStage2(String name) {
        return stage2.rewrite(name);
    }

    public static String correctOCRerrorsStage3(String name) {
        if ((name = stage3.rewrite(name)).length() >= 2) {
            char c1 = name.charAt(0);
            char c2 = name.charAt(1);
            if (c1 >= '1' && c1 <= '9' && c2 >= '1' && c2 <= '9') {
                name = name.substring(1);
            }
        }
        return name;
    }
}

