/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.n2s;

import chemaxon.marvin.io.formats.name.util.StringRewriter;
import chemaxon.naming.n2s.util.AutomatonRewriter;
import java.util.regex.Pattern;

public class Standardize {
    private static AutomatonRewriter fastRewriter = new AutomatonRewriter("\u0092", "'", "\u0094", "\"", "\u2032", "'", "\u2033", "\"", "\u2034", "'''", "\u2035", "\"\"", "\u2019", "'", "\u2010", "-", "\u2013", "-", "\u2014", "-", "<plusmn/>", "\u00b1");
    private static AutomatonRewriter fastRewriter2 = new AutomatonRewriter(".alpha.", "\u03b1", ".beta.", "\u03b2", ".gamma.", "\u02e0", ".omega.", "\u03c9");
    private static StringRewriter rewriter = Standardize.getRewriter();
    private static final Pattern removeITag = Pattern.compile("<[iI]>([^<]*)</[iI]>");
    private static final AutomatonRewriter HTMLrewriter = new AutomatonRewriter("&alpha;", "\u03b1", "&Alpha;", "\u03b1", "&beta;", "\u03b2", "&Beta;", "\u03b2", "&gamma;", "\u02e0", "&Gamma;", "\u02e0", "&delta;", "\u03b4", "&Delta;", "\u03b4", "&lambda;", "\u03bb", "&lt;", "<", "&gt;", ">", "&laquo;", "\u00ab", "&raquo;", "\u00bb", "&prime;", "'", "&lpar;", "(", "&rpar;", ")", "&lcub;", "{", "&rcub;", "}", "&hyphen;", "-", "&sol;", "/", "&nbsp;", " ", "&thinsp;", " ", "&plusmn;", "\u00b1");
    private static String[] qualifiers = new String[]{"(USAN)"};

    public static String get(String name) {
        return Standardize.get(name, true);
    }

    public static String get(String name, boolean decodeHTML) {
        if (decodeHTML) {
            name = Standardize.decodeHTML(name);
        }
        name = Standardize.removeQualifiers(name);
        name = name.trim();
        name = fastRewriter.rewrite(name);
        name = Standardize.toLowerCase(name);
        name = fastRewriter2.rewrite(name);
        if ((name = rewriter.rewrite(name).trim()).startsWith("a-") || name.startsWith("A-")) {
            name = "\u03b1" + name.substring(1);
        }
        if (name.startsWith("b-") || name.startsWith("B-")) {
            name = "\u03b2" + name.substring(1);
        }
        return name;
    }

    private static StringRewriter getRewriter() {
        StringRewriter res = new StringRewriter();
        res.replaceAll("alpha([^a-z]|$)", "\u03b1$1");
        res.replaceAll("beta([^a-z]|$)", "\u03b2$1");
        res.replaceAll("omega([^a-z]|$)", "\u03c9$1");
        return res;
    }

    public static String decodeHTML(String name) {
        name = Standardize.decodeHTMLNumeric(name);
        name = HTMLrewriter.rewrite(name);
        name = removeITag.matcher(name).replaceAll("$1");
        return name;
    }

    private static String decodeHTMLNumeric(String name) {
        int endEntity;
        int entityIndex = name.indexOf("&#");
        if (entityIndex == -1) {
            return name;
        }
        StringBuilder res = new StringBuilder(name.substring(0, entityIndex));
        entityIndex += 2;
        while (true) {
            if ((endEntity = name.indexOf(59, entityIndex)) == -1) {
                return name;
            }
            String entity = name.substring(entityIndex, endEntity);
            if (entity.startsWith("x")) {
                entity = entity.substring(1);
                int hex = Integer.parseInt(entity, 16);
                res.append((char)hex);
            } else {
                try {
                    int val = Integer.parseInt(entity);
                    res.append((char)val);
                }
                catch (NumberFormatException e) {
                    return name;
                }
            }
            entityIndex = name.indexOf("&#", ++endEntity);
            if (entityIndex == -1) break;
            res.append(name.substring(endEntity, entityIndex));
            entityIndex += 2;
        }
        res.append(name.substring(endEntity));
        return res.toString();
    }

    private static String toLowerCase(String name) {
        int len = name.length();
        if (len <= 3 || len == 4 && !Standardize.firstUpperOnly(name)) {
            return name;
        }
        if (Standardize.hasUpperAfterLower(name)) {
            return name;
        }
        if (Standardize.mostlyNumeric(name)) {
            return name;
        }
        StringBuffer buff = null;
        for (int i = 0; i < len; ++i) {
            char c = name.charAt(i);
            int keepUnchanged = Standardize.keepCharsUnchanged(c, i, len, name);
            if (keepUnchanged > 0) {
                if (buff != null) {
                    buff.append(name.substring(i, i + keepUnchanged));
                }
                i += keepUnchanged - 1;
                continue;
            }
            if (buff == null) {
                buff = new StringBuffer(name.substring(0, i));
            }
            buff.append(Character.toLowerCase(c));
        }
        if (buff == null) {
            return name;
        }
        return buff.toString();
    }

    private static boolean firstUpperOnly(String name) {
        if (name.length() == 0) {
            return false;
        }
        if (!Character.isUpperCase(name.charAt(0))) {
            return false;
        }
        int i = name.length();
        while (--i >= 1) {
            if (Character.isLowerCase(name.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean hasUpperAfterLower(String name) {
        int len = name.length();
        if (len == 0) {
            return false;
        }
        char prev1 = name.charAt(0);
        char prev2 = '\u0000';
        for (int i = 1; i < len; ++i) {
            char curChar = name.charAt(i);
            if (Character.isUpperCase(curChar) && Character.isLowerCase(prev1) && !Character.isDigit(prev2)) {
                return true;
            }
            prev2 = prev1;
            prev1 = curChar;
        }
        return false;
    }

    private static boolean mostlyNumeric(String name) {
        int len = name.length();
        int numeric = 0;
        int i = len;
        while (--i >= 0) {
            char c = name.charAt(i);
            if (!Character.isDigit(c)) continue;
            ++numeric;
        }
        return numeric * 2 >= len;
    }

    static int keepCharsUnchanged(char c, int i, int len, String name) {
        if (!Character.isUpperCase(c)) {
            return 1;
        }
        if (Standardize.isSingle(c, i, len, name)) {
            return 1;
        }
        if (Standardize.isDoubleUpper(c, i, len, name)) {
            return 2;
        }
        if (Standardize.isUpperAfterLocant(c, i, len, name)) {
            return 1;
        }
        if (Standardize.isRomanNumeral(c, i, len, name)) {
            return 1;
        }
        if (Standardize.isCasNameVersion(c, i, len, name)) {
            return 3;
        }
        int res = Standardize.countUpperThenNumber(i, len, name);
        if (res != 0) {
            return res;
        }
        return 0;
    }

    static boolean isSingle(char c, int i, int len, String name) {
        return !(i != 0 && Character.isLetter(name.charAt(i - 1)) || i + 1 != len && Character.isLetter(name.charAt(i + 1)));
    }

    static boolean isDoubleUpper(char c, int i, int len, String name) {
        if (i + 1 >= len) {
            return false;
        }
        if (c == 'Y' && name.substring(i).startsWith("YL")) {
            return false;
        }
        if (c == 'O' && name.substring(i).startsWith("OL")) {
            return false;
        }
        if (c == 'D' && name.substring(i).startsWith("DI-")) {
            return false;
        }
        return !(i != 0 && Character.isLetter(name.charAt(i - 1)) || !Character.isUpperCase(name.charAt(i + 1)) || i + 2 != len && Character.isLetter(name.charAt(i + 2)));
    }

    static boolean isUpperAfterLocant(char c, int i, int len, String name) {
        if (i < 2) {
            return false;
        }
        return Character.isDigit(name.charAt(i - 2)) && Character.isLowerCase(name.charAt(i - 1));
    }

    static boolean isRomanNumeral(char c, int i, int len, String name) {
        char next;
        char prev;
        if (!Standardize.isRomanNumeral(c)) {
            return false;
        }
        int j = i;
        while (--j >= 0 && (prev = name.charAt(j)) != ' ' && prev != '(') {
            if (Standardize.isRomanNumeral(prev)) continue;
            return false;
        }
        j = i;
        while (++j < len && (next = name.charAt(j)) != ' ' && next != ')') {
            if (Standardize.isRomanNumeral(next)) continue;
            return false;
        }
        return true;
    }

    static boolean isRomanNumeral(char c) {
        return c == 'I' || c == 'V' || c == 'X';
    }

    static boolean isCasNameVersion(char c, int i, int len, String name) {
        if (c != 'C') {
            return false;
        }
        if (i == 0 || i >= len - 2) {
            return false;
        }
        return Character.isDigit(name.charAt(i - 1)) && name.charAt(i + 1) == 'I' && (name.charAt(i + 2) == ')' || name.charAt(i + 2) == ',');
    }

    static int countUpperThenNumber(int i, int len, String name) {
        int res = 1;
        while (i + res < len) {
            char c = name.charAt(i + res);
            if (Character.isDigit(c)) {
                return res;
            }
            if (!Character.isUpperCase(c)) {
                return 0;
            }
            ++res;
        }
        return 0;
    }

    private static String removeQualifiers(String name) {
        String end;
        int start;
        for (String qual : qualifiers) {
            if (!name.endsWith(qual)) continue;
            return name.substring(0, name.length() - qual.length());
        }
        if (name.endsWith("]") && (start = name.lastIndexOf(" [")) != -1 && name.length() - start <= 12) {
            return name.substring(0, start);
        }
        if (name.endsWith(")") && (start = name.lastIndexOf("(")) != -1 && ((end = name.substring(start + 1, name.length() - 1)).equalsIgnoreCase("german") || end.equals("VAN"))) {
            return name.substring(0, start).trim();
        }
        return name;
    }

    public static String normalize(String name) {
        name = name.replaceAll(" +", " ");
        name = name.replace("( ", "(");
        name = name.replace(" )", ")");
        name = name.replace(" -", "-");
        name = name.replace("- ", "-");
        return name;
    }
}

