/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.n2s;

import chemaxon.core.calculations.ValenceCheck;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolImporter;
import chemaxon.marvin.io.formats.name.nameexport.Chem;
import chemaxon.naming.n2s.util.Formats;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;

public class Util {
    public static final String VALENCE_CHECK_MARKER = "ValenceCheck";

    public static Molecule newMolecule() {
        Molecule res = new Molecule();
        res.setDim(0);
        res.setProperty(VALENCE_CHECK_MARKER, "N");
        return res;
    }

    public static void mergeAtoms(Molecule molecule, MolAtom atom1, MolAtom atom2) {
        molecule.mergeAtoms(atom1, atom2);
    }

    public static void disableKeyword(MolAtom a, String key) {
        a.setAliasstr(a.getAliasstr().replace(key, key.toUpperCase()));
    }

    public static boolean isDefaultHydro(MolAtom a) {
        return a.getExtraLabel() != null && a.getExtraLabel().equals("defHydro");
    }

    public static void enableDefaultHydro(MolAtom a) {
        a.setExtraLabel("defHydro");
    }

    public static void disableDefaultHydro(MolAtom a) {
        a.setExtraLabel(null);
    }

    public static boolean isOHOrAnalog(MolAtom atom) {
        if (!Util.isOxygenOrAnalog(atom)) {
            return false;
        }
        if (atom.getBondCount() != 1) {
            return false;
        }
        return atom.getBond(0).getType() == 1;
    }

    public static boolean isOxygenOrAnalog(MolAtom atom) {
        return Util.isAtom(atom, 8) || Util.isAtom(atom, 16) || Util.isAtom(atom, 34) || Util.isAtom(atom, 52);
    }

    public static boolean isAtom(MolAtom atom, int atno) {
        if (atom == null) {
            return false;
        }
        return atom.getAtno() == atno;
    }

    public static String describeValenceError(Molecule mol) {
        for (MolAtom a : mol.getAtomArray()) {
            if (!a.hasValenceError()) continue;
            return a + ": valence=" + a.getValence();
        }
        return "unknown";
    }

    public static boolean hasValenceError(Molecule mol) {
        for (MolAtom a : mol.getAtomArray()) {
            if (!Util.hasValenceError(a)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasValenceError(MolAtom a) {
        int atno = a.getAtno();
        int valence = Chem.getValence(a);
        int charge = a.getCharge();
        switch (atno) {
            case 17: {
                if (valence == 7) {
                    return false;
                }
            }
            case 35: 
            case 53: {
                if (valence == 5 || valence == 7) {
                    return false;
                }
            }
            case 52: {
                if (valence != 4 || charge != 4) break;
                return false;
            }
            case 34: {
                if (valence != 4 && valence != 6 || charge != 0) break;
                return false;
            }
            case 8: {
                if (valence != 4 || charge != 1) break;
                return false;
            }
        }
        return valence > Chem.maxValence(atno);
    }

    public static Molecule parseSmilesOrAny(String structure) throws MolFormatException {
        if (structure.startsWith("InChI=")) {
            return MolImporter.importMol(structure, "inchi");
        }
        if (structure.charAt(0) == '<') {
            return MolImporter.importMol(structure);
        }
        return Formats.importCxSmiles(structure);
    }

    public static boolean isRingAtom(MolAtom a) {
        try {
            int i = a.getBondCount();
            while (--i >= 0) {
                if (!a.getParent().isRingBond(a.getParent().indexOf(a.getBond(i)))) continue;
                return true;
            }
            return false;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public static void addBond(MoleculeGraph m, MolBond b) {
        if (m.contains(b)) {
            throw new RuntimeException("Duplicate bond");
        }
        m.add(b);
    }

    public static MolAtom commonAtom(MolBond b1, MolBond b2) {
        MolAtom a11 = b1.getAtom1();
        MolAtom a12 = b1.getAtom2();
        MolAtom a21 = b2.getAtom1();
        MolAtom a22 = b2.getAtom2();
        if (a11 == a21 || a11 == a22) {
            return a11;
        }
        if (a12 == a21 || a12 == a22) {
            return a12;
        }
        return null;
    }

    public static void valenceCheck(Molecule m) {
        boolean valenceCheck = m.isValenceCheckEnabled();
        m.setValenceCheckEnabled(true);
        m.valenceCheck();
        m.setValenceCheckEnabled(valenceCheck);
    }

    public static int getImplicitHcount(MolAtom a) {
        if (a.getParent() != null && !a.getParent().isValenceCheckEnabled()) {
            ValenceCheck.check(a);
        }
        return a.getImplicitHcount();
    }

    public static int[] getGraphInvariants(Molecule m) {
        int[] grinv = new int[m.getAtomCount()];
        if (!m.isValenceCheckEnabled()) {
            Util.valenceCheck(m);
        }
        m.getGrinv(grinv);
        return grinv;
    }

    public static String getProperty(Molecule m, String key) {
        return (String)m.properties().getObject(key);
    }
}

