/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.n2s.lex;

import chemaxon.marvin.io.formats.name.nameexport.Util;
import chemaxon.naming.n2s.NameImportException;
import chemaxon.naming.n2s.lex.TextSource;

public class Lexer {
    final TextSource source;

    Lexer(TextSource source) {
        this.source = source;
    }

    void optional(boolean read) {
    }

    boolean read(String s) {
        return this.source.read(s);
    }

    boolean read(char c) {
        return this.source.read(c);
    }

    char read() {
        return this.source.read();
    }

    char peek() {
        return this.peek(0);
    }

    char prev() {
        return this.peek(-1);
    }

    char peek(int index) {
        return this.source.peek(index);
    }

    boolean peek(String prefix) {
        return this.source.peek(prefix);
    }

    String alreadyLexed() {
        return this.source.getReadText();
    }

    void mustRead(char c) {
        if (this.read(c)) {
            return;
        }
        throw new NameImportException("Expected: " + c);
    }

    protected char next() {
        return this.peek(1);
    }

    protected boolean eol(int offset) {
        return this.peek(offset) == '\u0000';
    }

    protected int readOptionalInt() {
        char c;
        int res = -1;
        while ((c = this.read()) != '\u0000') {
            int value;
            if (Character.isDigit(c)) {
                value = Character.getNumericValue(c);
            } else {
                value = Util.unicodeSuperscriptNumberValue(c);
                if (value < 0) {
                    this.source.move(-1);
                    break;
                }
            }
            if (res == -1) {
                res = 0;
            }
            res = res * 10 + value;
        }
        return res;
    }

    protected int readInt() {
        int res = this.readOptionalInt();
        if (res == -1) {
            throw new NameImportException("Number expected at " + this.source.remainder());
        }
        return res;
    }

    void skipSpaces() {
        while (this.peek(0) == ' ') {
            this.read();
        }
    }

    boolean read(String prefix, String ... allowedContinuations) {
        return this.source.read(prefix, allowedContinuations);
    }

    protected boolean readToEnd(String text) {
        return this.source.readToEnd(text);
    }

    public String readUntil(char end) {
        char c;
        StringBuilder res = new StringBuilder();
        while ((c = this.read()) != end) {
            if (c == '\u0000') {
                return null;
            }
            res.append(c);
        }
        return res.toString();
    }
}

