/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.n2s.lex;

import chemaxon.naming.NameFormatException;
import chemaxon.naming.NamePrefixException;
import chemaxon.naming.n2s.N2S;
import chemaxon.naming.n2s.NameImportException;
import chemaxon.naming.n2s.UnknownTokenException;
import chemaxon.naming.n2s.lex.Lexer;
import chemaxon.naming.n2s.lex.NewStructureLexer;
import chemaxon.naming.n2s.lex.PostLexer;
import chemaxon.naming.n2s.lex.PreLexer;
import chemaxon.naming.n2s.lex.StringSource;
import chemaxon.naming.n2s.lex.data.AtomLocant;
import chemaxon.naming.n2s.lex.data.BracketToken;
import chemaxon.naming.n2s.lex.data.ComplexLocant;
import chemaxon.naming.n2s.lex.data.EndingToken;
import chemaxon.naming.n2s.lex.data.FusedLocant;
import chemaxon.naming.n2s.lex.data.Hydro;
import chemaxon.naming.n2s.lex.data.IonNumber;
import chemaxon.naming.n2s.lex.data.Locant;
import chemaxon.naming.n2s.lex.data.LocantList;
import chemaxon.naming.n2s.lex.data.NonStdValenceLocant;
import chemaxon.naming.n2s.lex.data.RatioToken;
import chemaxon.naming.n2s.lex.data.RingNumber;
import chemaxon.naming.n2s.lex.data.Separator;
import chemaxon.naming.n2s.lex.data.SimpleLocant;
import chemaxon.naming.n2s.lex.data.SpecialLocant;
import chemaxon.naming.n2s.lex.data.StereoNumber;
import chemaxon.naming.n2s.lex.data.Token;
import java.io.Reader;
import java.util.ArrayList;

public class NameLexer
extends Lexer {
    private final boolean dataMining;
    int num;
    int primes;
    Locant locant;
    boolean ringNumbering;
    private static final Separator addedSpace = new Separator(' ');
    public static final char tokenSeparator = '\u200b';

    public static ArrayList<Token> parse(String name, boolean dataMining) throws NameFormatException {
        return new NameLexer(name, dataMining).parseName();
    }

    NameLexer(String name, boolean dataMining) {
        super(new StringSource(NameLexer.preParse(name)));
        this.dataMining = dataMining;
    }

    private static String preParse(String name) {
        name = PreLexer.preParseName(name);
        return name;
    }

    private ArrayList<Token> parseName() throws NameFormatException {
        ArrayList<Token> tokens = this.parseName('\u0000');
        if (!PostLexer.canBeValidName(tokens = PostLexer.fix(tokens), this.dataMining)) {
            throw new NameImportException("Invalid name: " + this.source.getReadText());
        }
        return tokens;
    }

    private ArrayList<Token> parseName(char close) throws NameFormatException {
        ArrayList<Token> res = new ArrayList<Token>();
        while (this.source.hasMore()) {
            LocantList l;
            int valence;
            if (this.closeBracket(close)) {
                return res;
            }
            if (this.read(' ')) {
                this.skipSpaces();
                if (this.closeBracket(close)) {
                    return res;
                }
                res.add(new Separator(' '));
            }
            if (this.peek() == '[' && this.parseFusedLocants(res)) continue;
            if (this.read(',')) {
                res.add(Separator.comma);
                continue;
            }
            if (this.ignoreIrrelevantCharacters(res) || this.parseLocants(res, close) || this.parseRatio(res)) continue;
            if (this.read('{')) {
                this.parseBracket(res, '{', '}');
                continue;
            }
            if (this.read('(')) {
                if (this.read("8CI)") || this.read("VAN8CI)") || this.read("van 8CI)") || this.read("9CI)") || this.read("VAN9CI)") || this.read("van 9CI)") || this.read("8CI9CI)") || this.read("8CI 9CI)") || this.read("VAN8CI9CI)") || this.read("7CI,8CI)") || this.read("8CI,9CI)") || this.read("7CI,9CI)") || this.read("van,8CI,9CI)")) {
                    while (!res.isEmpty() && res.get(res.size() - 1).is(" ")) {
                        res.remove(res.size() - 1);
                    }
                    continue;
                }
                this.parseBracket(res, '(', ')');
                continue;
            }
            if (this.read('[')) {
                this.parseBracket(res, '[', ']');
                continue;
            }
            if (this.read('-')) {
                if (close != '\u0000' && this.read(',')) {
                    return res;
                }
                this.read(this.prev());
                res.add(new Separator(this.prev()));
                continue;
            }
            if (this.read("rel-")) {
                N2S.getState().rel = true;
                continue;
            }
            if (this.read("$l")) {
                valence = this.parseLambda();
                l = new LocantList();
                l.tryAddLocant(new NonStdValenceLocant(valence));
                res.add(l);
                continue;
            }
            if (this.read("\u03bb") || this.read("lambda")) {
                valence = this.readInt();
                l = new LocantList();
                l.tryAddLocant(new NonStdValenceLocant(valence));
                res.add(l);
                continue;
            }
            if (Character.isLetter(this.peek())) {
                this.parseText(res);
                if (close == '\u0000' || !res.get(res.size() - 1).getValue().startsWith("[BREAK_")) continue;
                return res;
            }
            if (this.read('\u200b')) {
                res.add(new Separator('\u200b'));
                continue;
            }
            if (this.read('/')) {
                res.add(new Separator('/'));
                continue;
            }
            throw new NameImportException("Unrecognized name format: '" + this.source.remainder() + "'");
        }
        return res;
    }

    private boolean closeBracket(char close) {
        if (this.read(close)) {
            return true;
        }
        return this.dataMining && close != '\u0000' && (this.read(')') || this.read('}') || this.read(']'));
    }

    private boolean ignoreIrrelevantCharacters(ArrayList<Token> tokens) {
        if (this.read("(+)") || this.read("(-)") || this.read("(\u2212)") || this.read("(+ )") || this.read("( +)") || this.read("(- )") || this.read("( -)") || this.read("(+/-)") || this.read("(+-)") || this.read("(+ -)") || this.read("(.+-.)") || this.read("(.+ -.)") || this.read("(\u00b1)")) {
            if (this.read(' ') || this.read('-')) {
                // empty if block
            }
            return true;
        }
        return !(!tokens.isEmpty() && tokens.get(tokens.size() - 1) == addedSpace || !this.read("d-") && !this.read("l-") && !this.read("dl-"));
    }

    private void parseBracket(ArrayList<Token> res, char open, char close) throws NameFormatException {
        this.skipSpaces();
        ArrayList<Token> inside = this.parseName(close);
        if (this.avoidBrackets(inside, res, open)) {
            res.addAll(inside);
        } else {
            boolean closed = this.prev() == close;
            res.add(new BracketToken(open, close, inside, closed));
        }
    }

    private boolean avoidBrackets(ArrayList<Token> inside, ArrayList<Token> res, char open) {
        if (inside.size() == 3 && inside.get(0) instanceof LocantList && inside.get(1) instanceof Separator && inside.get(2) instanceof LocantList) {
            return true;
        }
        if (this.allHydro(inside)) {
            return true;
        }
        if (inside.size() != 1) {
            return false;
        }
        Token t = inside.get(0);
        if (t.getType() == 5 || t.getType() == 2) {
            return true;
        }
        if (t.getType() == 12 && open != '[') {
            Locant l;
            StereoNumber sn;
            LocantList ll = (LocantList)t;
            if (ll.size() == 1 && (sn = (l = ll.getLocant(0)).toStereoNumber()) != null) {
                ll.getLocantsList().set(0, sn);
            }
            return true;
        }
        if (t instanceof Hydro) {
            return true;
        }
        return (res.size() == 0 || !(res.get(res.size() - 1) instanceof EndingToken) && !(res.get(res.size() - 1) instanceof Separator)) && t.getType() == 0;
    }

    private boolean allHydro(ArrayList<Token> tokens) {
        if (tokens.isEmpty()) {
            return false;
        }
        for (Token inside : tokens) {
            if (inside instanceof Hydro) continue;
            return false;
        }
        return true;
    }

    private boolean parseLocants(ArrayList<Token> res, char close) {
        Locant specialLocant = this.parseSpecialLocant();
        if (specialLocant == null) {
            return this.parseLocantList(res, close);
        }
        LocantList l = new LocantList();
        l.tryAddLocant(specialLocant);
        res.add(l);
        if (this.prev() == '-') {
            this.source.move(-1);
        }
        return true;
    }

    boolean parseLocantList(ArrayList<Token> res, char close) {
        boolean foundSomething = false;
        this.ringNumbering = false;
        boolean complexLocant = false;
        LocantList l = new LocantList();
        this.locant = null;
        while (this.source.hasMore()) {
            if (this.parseOneLocant(res, close)) {
                foundSomething = true;
                continue;
            }
            if (this.num == -1 && this.locant == null) {
                if (this.read(',') || this.ringNumbering && this.read(".")) {
                    this.skipSpaces();
                    continue;
                }
                int size = l.getLocantsList().size();
                if (size <= 0 || size % 2 != 0 || !this.read(":")) break;
                complexLocant = true;
                continue;
            }
            this.makeLocantObject();
            if (this.peek() == '-' && l.getLocantsList().size() == 1 && Character.isLowerCase(this.next()) && this.peek(2) == close) {
                this.read();
                char letter = this.read();
                int locant1 = l.getLocant(0).getValue();
                int locant2 = this.locant.getValue();
                l = new LocantList();
                this.locant = new FusedLocant(locant1, locant2, letter);
            }
            this.addLocant(l, this.locant);
        }
        if (complexLocant) {
            l = NameLexer.makeComplexLocant(l);
        }
        if (l.size() == 1 && (this.read('H') || this.read('h') || this.read("(H)"))) {
            Hydro h = new Hydro(l);
            res.add(h);
            this.read(',');
            this.skipSpaces();
            return true;
        }
        if (l.hasLocant()) {
            res.add(l);
            return true;
        }
        return foundSomething;
    }

    private void addLocant(LocantList list, Locant locant) {
        list.addLocant(locant);
    }

    private void makeLocantObject() {
        if (this.locant != null) {
            this.locant.setParent(this.primes);
        } else {
            this.locant = this.ringNumbering ? new RingNumber(this.num) : new SimpleLocant(this.num, this.primes);
        }
    }

    Locant parseLocant() {
        this.parseOneLocant(null, '\u0000');
        this.makeLocantObject();
        return this.locant;
    }

    private boolean parseOneLocant(ArrayList<Token> res, char close) {
        char next;
        this.locant = null;
        if (this.read("\u03b1") || this.peek(1) == '-' && !this.eol(2) && (this.read("a") || this.read("A"))) {
            this.locant = new SimpleLocant(0x7FFFFFFC);
            return false;
        }
        if (this.read("\u03b2") || this.peek(1) == '-' && !this.eol(2) && (this.read("b") || this.read("B"))) {
            this.locant = Locant.Beta;
            return false;
        }
        if (this.read("\u03b3") || this.peek(1) == '-' && !this.eol(2) && (this.read("c") || this.read("C"))) {
            this.locant = new SimpleLocant(0x7FFFFFFE);
            return false;
        }
        if (this.read("\u03c9")) {
            this.locant = new SimpleLocant(Integer.MAX_VALUE);
            return false;
        }
        if (this.prev() == '(' && this.read("+")) {
            int charge = this.readInt();
            this.skipSpaces();
            this.locant = new IonNumber(charge);
            return false;
        }
        if (this.prev() == '(' && this.read("-")) {
            int charge = this.readInt();
            this.skipSpaces();
            this.locant = new IonNumber(-charge);
            return false;
        }
        this.num = this.readOptionalInt();
        if (this.num != -1) {
            this.skipSpaces();
            if (this.read("%") || this.read("+%")) {
                Token last;
                while (!res.isEmpty() && ((last = res.get(res.size() - 1)).is(" ") || last.is(","))) {
                    res.remove(res.size() - 1);
                }
                return true;
            }
        }
        if (this.num == -1) {
            if (this.read("ortho", "-", ",", " ") || this.read("o", "-", ",", "'", " ") || this.readToEnd("o")) {
                this.locant = new SimpleLocant(2, true);
            } else if (this.read("meta", "-", ",", " ") || this.read("m", "-", ",", "'", " ") || this.readToEnd("m")) {
                this.locant = new SimpleLocant(3, true);
            } else if (this.read("para", "-", ",", " ") || this.read("p", "-", ",", "'", " ") || this.readToEnd("p")) {
                this.locant = new SimpleLocant(4, true);
            }
        }
        if (this.num == -1 && this.locant == null && this.isAtomLocant(this.peek(), 1, true)) {
            char atom = this.read();
            if (atom == 'n') {
                atom = 'N';
            }
            this.num = this.readOptionalInt();
            if (this.num == -1 && this.read("(sup")) {
                this.skipSpaces();
                this.num = this.readInt();
                this.mustRead(')');
            }
            this.locant = this.num == -1 ? AtomLocant.create(atom) : AtomLocant.create(this.num, atom);
        }
        this.primes = this.parsePrimes();
        if (!(this.num == -1 || this.peek() < 'a' || this.peek() >= 'h' || this.peek() == 'e' || NameLexer.isLatinLowerCase(next = this.peek(1)) && next != 'r' && next != 's')) {
            this.num *= 100;
            this.num += this.read() - 97 + 1;
        }
        if (this.primes == 0) {
            this.primes = this.parsePrimes();
        }
        if (this.read('^')) {
            this.ringNumbering = true;
            if (this.num == -1) {
                throw new NameImportException("Unexpected superscript");
            }
            this.locant = this.parseRingNumbering(this.num);
        }
        char stereo = this.stereoLetter(this.num < 0);
        boolean duplicateLocant = false;
        if (this.num != -1 && stereo == '\u0000') {
            if (this.read("(R)")) {
                stereo = 'R';
            } else if (this.read("(S)")) {
                stereo = 'S';
            }
            duplicateLocant = true;
        }
        if (stereo > '\u0000') {
            this.skipSpaces();
            boolean relative = false;
            if ("RSrs".indexOf(stereo) != -1 && this.read('*')) {
                relative = true;
            }
            if (this.locant != null) {
                this.locant = new StereoNumber(this.locant, stereo, relative);
            } else {
                boolean empty;
                boolean bl = empty = this.num == -1;
                if (this.num == -1) {
                    this.num = 1;
                }
                this.locant = new StereoNumber(this.num, stereo, relative, empty);
            }
            if (this.read("-cis")) {
                ((StereoNumber)this.locant).setExtraCis();
            } else if (this.read("-trans")) {
                ((StereoNumber)this.locant).setExtraTrans();
            }
            if (duplicateLocant) {
                res.add(LocantList.simpleList(this.locant));
                this.locant = null;
            }
        }
        if (this.locant == null && this.num != -1) {
            int valence;
            if (this.read('+')) {
                this.locant = new IonNumber(this.num);
            } else if (this.peek(1) == ')' && this.read('-')) {
                this.locant = new IonNumber(-this.num);
            } else if (this.isAtomLocant(this.peek(1), 2, false) && this.read("-")) {
                char atom = this.read();
                this.locant = AtomLocant.create(this.num, this.primes, atom);
            } else if (this.read("$l")) {
                valence = this.parseLambda();
                this.locant = new NonStdValenceLocant(this.num, 0, valence);
            } else if (this.read("\u03bb") || this.read("lambda") || this.read("-lambda")) {
                valence = this.readInt();
                this.locant = new NonStdValenceLocant(this.num, 0, valence);
            } else if (this.read("\u03b1") || this.peek("-\u03b1)") && this.read("-\u03b1")) {
                this.locant = new SimpleLocant(this.num, 'a');
            } else if (this.read("\u03b2") || this.peek("-\u03b2)") && this.read("-\u03b2")) {
                this.locant = new SimpleLocant(this.num, 'b');
            } else if (this.read("-cis")) {
                this.locant = new StereoNumber(this.num, "cis");
            } else if (this.read("-trans")) {
                this.locant = new StereoNumber(this.num, "trans");
            } else if (this.read("-exo")) {
                this.locant = new StereoNumber(this.num, "exo");
            } else if (this.read("-endo")) {
                this.locant = new StereoNumber(this.num, "endo");
            } else if (this.peek() == '.' && close != '\u0000' && this.locant == null) {
                this.locant = new RingNumber(this.num);
                this.ringNumbering = true;
            }
        }
        return false;
    }

    private char stereoLetter(boolean strict) {
        if ("EZRS".indexOf(this.peek()) != -1) {
            return this.read();
        }
        if (!("ezrs".indexOf(this.peek()) == -1 || Character.isLetter(this.peek(1)) || strict && Character.isLetter(this.peek(-1)))) {
            return this.read();
        }
        return '\u0000';
    }

    private int parsePrimes() {
        int primes = 0;
        if (this.num != -1 || this.locant != null) {
            while (this.read('\"')) {
                primes += 2;
            }
            while (this.read('\'')) {
                ++primes;
            }
        }
        return primes;
    }

    private static boolean isLatinLowerCase(char c) {
        return c >= 'a' && c <= 'z';
    }

    private Locant parseSpecialLocant() {
        if (this.read("cis-")) {
            return StereoNumber.cis;
        }
        if (this.read("trans-")) {
            return StereoNumber.trans;
        }
        if (this.read("s-") || this.read("sym-")) {
            return SpecialLocant.sym;
        }
        if (this.read("as-") || this.read("asym-")) {
            return SpecialLocant.asym;
        }
        if (this.read("v-") || this.read("vic-")) {
            return SpecialLocant.vicinal;
        }
        if (this.read("n-")) {
            return SpecialLocant.n;
        }
        if (this.read("endo-") || this.read("(endo)")) {
            return StereoNumber.endo;
        }
        if (this.read("exo-") || this.read("(exo)")) {
            return StereoNumber.exo;
        }
        if (this.read("D-") || this.read("(D)")) {
            return new StereoNumber(4);
        }
        if (this.read("L-") || this.read("(L)")) {
            return new StereoNumber(3);
        }
        if (this.read("DL-") || this.read("(DL)")) {
            return new StereoNumber(5);
        }
        return null;
    }

    private Locant parseRingNumbering(int num) {
        char open = this.read();
        int first = this.readInt();
        char c = this.read();
        if (c == this.closingBracket(open)) {
            return new RingNumber(num, first);
        }
        if (c != ',') {
            throw new NameImportException("Comma or bracket expected in ring number");
        }
        this.skipSpaces();
        int second = this.readInt();
        char closeBracket = this.read();
        if (closeBracket != this.closingBracket(open)) {
            throw new NameImportException(this.closingBracket(open) + " expected, " + closeBracket + " found");
        }
        return new RingNumber(num, first, second);
    }

    private static LocantList makeComplexLocant(LocantList l) {
        ArrayList<Locant> locants = l.getLocantsList();
        if (locants.size() % 2 != 0) {
            throw new NameImportException("Invalid locant format");
        }
        l = new LocantList();
        int i = 0;
        while (i < locants.size()) {
            SimpleLocant l1 = (SimpleLocant)locants.get(i++);
            SimpleLocant l2 = (SimpleLocant)locants.get(i++);
            ComplexLocant c = new ComplexLocant(l1, l2);
            l.tryAddLocant(c);
        }
        return l;
    }

    private static boolean isAtomLocantStart(char c) {
        return "CNOPSn".indexOf(c) != -1;
    }

    private boolean isAtomLocant(char c, int offset, boolean acceptLowerCase) {
        if (!NameLexer.isAtomLocantStart(c)) {
            return false;
        }
        if (!acceptLowerCase && Character.isLowerCase(c)) {
            return false;
        }
        char next = this.peek(offset);
        if (next == '\u0000') {
            return true;
        }
        if (" '\"-,EZ123456789(".indexOf(next) == -1) {
            return false;
        }
        if (c != 'S' || next == ' ') {
            // empty if block
        }
        return true;
    }

    private boolean parseFusedLocants(ArrayList<Token> res) {
        LocantList l;
        block3: {
            char c;
            if (!this.isFusedLetter(this.peek(1)) || this.peek(2) != ',' && this.peek(2) != ']') {
                return false;
            }
            this.read();
            l = new LocantList();
            while (true) {
                if (!this.isFusedLetter(c = this.read())) {
                    throw new RuntimeException("Wrong fused locant:" + c);
                }
                FusedLocant f = new FusedLocant(1, 2, c);
                l.tryAddLocant(f);
                c = this.read();
                if (c == ']') break block3;
                if (c != ',') break;
                this.skipSpaces();
            }
            throw new RuntimeException("Unexpected fused locant: " + c);
        }
        res.add(l);
        return true;
    }

    private boolean isFusedLetter(char c) {
        return c >= 'a' && c <= 'l';
    }

    private int parseLambda() {
        this.mustRead('^');
        char open = this.read();
        char close = this.closingBracket(open);
        if (close == '\u0000') {
            throw new NameImportException("Bracket expected");
        }
        String value = this.readUntil(close);
        if (value == null) {
            throw new NameImportException("Missing closing bracket");
        }
        int l = Integer.parseInt(value);
        return l;
    }

    private boolean parseRatio(ArrayList<Token> res) {
        if (this.peek(0) != '(' || this.peek(2) != ':' || this.peek(4) != ')') {
            return false;
        }
        char c1 = this.peek(1);
        char c2 = this.peek(3);
        try {
            int mix1 = Integer.parseInt(c1 + "");
            int mix2 = c2 == '?' ? -1 : Integer.parseInt(c2 + "");
            String text = this.source.remainder().substring(0, 5);
            this.source.move(5);
            RatioToken t = new RatioToken(mix1, mix2);
            t.setName(text);
            res.add(t);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private void parseText(ArrayList<Token> res) throws UnknownTokenException, NamePrefixException {
        Reader r = this.source.getReader();
        try {
            int read = NewStructureLexer.addStructures(r, res);
            if (read == 0) {
                throw new UnknownTokenException(this.unknownToken(), this.alreadyLexed());
            }
            this.source.move(read);
        }
        catch (NamePrefixException e) {
            String prefix = this.alreadyLexed();
            throw new NamePrefixException(prefix + e.getParsed(), e.token);
        }
        char next = this.peek();
        if (Character.isLetter(next) && Character.isLetter(this.peek(-1))) {
            res.add(addedSpace);
        }
    }

    private String unknownToken() {
        for (int skip = 1; skip < this.source.remaining(); ++skip) {
            int read;
            Reader r = this.source.getReader(skip);
            try {
                read = NewStructureLexer.addStructures(r, new ArrayList<Token>());
            }
            catch (NamePrefixException e) {
                continue;
            }
            if (read <= 0) continue;
            return this.source.remainder(skip);
        }
        return this.source.remainder();
    }

    private char closingBracket(char open) {
        switch (open) {
            case '(': {
                return ')';
            }
            case '{': {
                return '}';
            }
            case '[': {
                return ']';
            }
            case '~': {
                return '~';
            }
        }
        return '\u0000';
    }
}

