/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.n2s.lex;

import chemaxon.naming.NamePrefixException;
import chemaxon.naming.n2s.Standardize;
import chemaxon.naming.n2s.lex.data.Anhydro;
import chemaxon.naming.n2s.lex.data.BridgeStr;
import chemaxon.naming.n2s.lex.data.EndingToken;
import chemaxon.naming.n2s.lex.data.EtherStr;
import chemaxon.naming.n2s.lex.data.Hydro;
import chemaxon.naming.n2s.lex.data.Number;
import chemaxon.naming.n2s.lex.data.Separator;
import chemaxon.naming.n2s.lex.data.SpecialGroup;
import chemaxon.naming.n2s.lex.data.StructureToken;
import chemaxon.naming.n2s.lexer.Lexer;
import chemaxon.naming.n2s.lexer.Token;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;

public class NewStructureLexer {
    static final String PREFIX = "!PREFIX";
    static Lexer _lexer;

    public static int addStructures(Reader in, ArrayList<chemaxon.naming.n2s.lex.data.Token> tokens) throws NamePrefixException {
        Lexer.State res;
        try {
            res = NewStructureLexer.getLexer().lex(in);
        }
        catch (IOException e) {
            throw new RuntimeException("StringReader throws no IOException", e);
        }
        for (Token t : res.getTokens()) {
            TokenContainer tc = (TokenContainer)t;
            chemaxon.naming.n2s.lex.data.Token tok = NewStructureLexer.dictFormatToToken(tc.val, tc.name);
            tokens.add(tok);
        }
        if (!tokens.isEmpty()) {
            chemaxon.naming.n2s.lex.data.Token t = tokens.get(tokens.size() - 1);
            String name = t.getName();
            if (PREFIX.equals(t.getValue()) && res.trailingText().length() == 0) {
                throw new NamePrefixException(res.getLexedText(), name);
            }
        }
        return res.textLength();
    }

    static Lexer getLexer() {
        if (_lexer != null) {
            return _lexer;
        }
        Lexer res = new Lexer();
        try {
            res = NewStructureLexer.loadTokens(res);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        _lexer = res;
        return res;
    }

    private static Lexer loadTokens(Lexer lexer) throws IOException {
        lexer = NewStructureLexer.loadTokens(lexer, "/chemaxon/naming/n2s/dictionary.smi");
        lexer = NewStructureLexer.loadTokens(lexer, "/chemaxon/naming/n2s/nonSmilesDict.txt");
        return lexer;
    }

    private static Lexer loadTokens(Lexer lexer, String dict) throws IOException {
        String line;
        InputStream stream = NewStructureLexer.class.getResourceAsStream(dict);
        boolean userData = false;
        boolean onlyWhenNew = false;
        boolean allowExtraData = false;
        int lineNum = 0;
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        while ((line = reader.readLine()) != null) {
            lexer = NewStructureLexer.processLine(lexer, line, userData, onlyWhenNew, allowExtraData, ++lineNum, dict);
        }
        return lexer;
    }

    private static Lexer processLine(Lexer lexer, String line, boolean userData, boolean onlyWhenNew, boolean allowExtraData, int lineNum, String dictName) {
        String flags;
        if (line.equals("") || line.startsWith("##")) {
            return lexer;
        }
        String[] data = line.split("\t");
        if (data[0].equals("")) {
            return lexer;
        }
        if (data.length < 2) {
            System.err.println("Dictionary format error in " + dictName + " line " + lineNum + ".\nLine >>" + line + "<< is ignored.");
            return lexer;
        }
        if (!userData && data.length > 3 && data[3].equalsIgnoreCase("false")) {
            return lexer;
        }
        String name = data[1];
        if (userData && (name = Standardize.get(name)).endsWith("ane")) {
            name = name.substring(0, name.length() - 3);
        }
        if (data.length == 2) {
            flags = "";
        } else {
            StringBuilder flagsBuilder = new StringBuilder();
            for (int i = 2; i < data.length; ++i) {
                flagsBuilder.append('\t');
                String flag = data[i];
                if (i == 2 && flag.startsWith("{") && flag.endsWith("}")) {
                    flag = flag.substring(1, flag.length() - 1);
                }
                flagsBuilder.append(flag);
            }
            flags = flagsBuilder.toString();
        }
        if (data[0].endsWith(".")) {
            data[0] = data[0].substring(0, data[0].length() - 1);
            flags = flags + ".";
        }
        try {
            return NewStructureLexer.extendLexer(lexer, name, data[0] + flags, onlyWhenNew, userData);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Error while processing dictionary line '" + line + "'", e);
        }
    }

    private static Lexer extendLexer(Lexer lexer, String key, String val, boolean onlyWhenNew, boolean override) {
        String[] keyArray = key.split("@");
        if (keyArray.length == 1) {
            return NewStructureLexer.put(lexer, keyArray[0], val, onlyWhenNew, override);
        }
        if (keyArray.length == 2) {
            lexer = NewStructureLexer.put(lexer, keyArray[0], val, onlyWhenNew, override);
        }
        for (int i = 1; i < keyArray.length; ++i) {
            lexer = NewStructureLexer.put(lexer, keyArray[0] + keyArray[i], val, onlyWhenNew, override);
        }
        return lexer;
    }

    private static Lexer put(Lexer lexer, String name, String val, boolean onlyWhenNew, boolean override) {
        TokenContainer t = new TokenContainer(name, val);
        return lexer.addToken(t);
    }

    static chemaxon.naming.n2s.lex.data.Token dictFormatToToken(String value, String name) {
        if (value.endsWith(".")) {
            return new EndingToken(name, value);
        }
        if (value.endsWith("*") && value.length() > 1) {
            int type = 1;
            if (name.endsWith("a")) {
                type = 0;
            }
            return new Number(name, value, type);
        }
        if ((value.equalsIgnoreCase("H") || value.equalsIgnoreCase("-H")) && !name.equals("hydrogen")) {
            return new Hydro(name, value);
        }
        if (value.equals(" ")) {
            return new Separator(' ');
        }
        if (value.equals("!EPI")) {
            return new BridgeStr();
        }
        if (name.equals("anhydro")) {
            return new Anhydro();
        }
        if (value.equals("!ether")) {
            return new EtherStr("ether", 8);
        }
        if (value.equals("!thioether")) {
            return new EtherStr(name, 16);
        }
        if (name.equalsIgnoreCase("spiro") || name.equalsIgnoreCase("cyclo") || value.startsWith("!")) {
            return new SpecialGroup(name, value);
        }
        return StructureToken.create(name, value);
    }

    private static class TokenContainer
    implements Token {
        private String name;
        private String val;
        private boolean beforeVowel;

        public TokenContainer(String name, String val) {
            if (name.endsWith("vowel?")) {
                name = name.substring(0, name.length() - "vowel?".length());
                this.beforeVowel = true;
            }
            if (NewStructureLexer.PREFIX.equals(val)) {
                val = NewStructureLexer.PREFIX;
            }
            this.name = name;
            this.val = val;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean acceptableBefore(int nextCharacter) {
            if (this.beforeVowel) {
                return "aeiou".indexOf(nextCharacter) != -1;
            }
            if (this.val == NewStructureLexer.PREFIX) {
                return nextCharacter == -1;
            }
            return true;
        }

        public String toString() {
            return this.name;
        }
    }
}

