/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.n2s.lex.data;

import chemaxon.naming.n2s.lex.data.Locant;
import chemaxon.naming.n2s.lex.data.LocantList;
import chemaxon.naming.n2s.lex.data.Str;
import chemaxon.naming.n2s.lex.data.StructureToken;
import chemaxon.struc.MolAtom;

public class AminoAcidStr
extends StructureToken {
    AminoAcidStr(String name, String struc) {
        super(name, struc);
        this.defaultStereo = 3;
    }

    @Override
    public boolean consume(LocantList locants, int mul) {
        if (mul == -1 && this.is("alanine") && locants.isBeta()) {
            this.setValue("NCCC(O)=O |$N;3;2;1;ester;$|");
            return true;
        }
        return false;
    }

    @Override
    public boolean needsLocant() {
        return false;
    }

    @Override
    MolAtom[] getConnectionPoints(Str substituent) {
        if (!substituent.hasLocant() && substituent instanceof AminoAcidStr) {
            return new MolAtom[]{this.getAtom(Locant.N)};
        }
        return super.getConnectionPoints(substituent);
    }

    @Override
    public boolean isEsterParent() {
        if (this.getLocantMap().get("ester") != null) {
            return true;
        }
        return super.isEsterParent();
    }
}

