/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.n2s.lex.data;

import chemaxon.naming.n2s.N2S;
import chemaxon.naming.n2s.lex.data.Locant;
import chemaxon.naming.n2s.lex.data.LocantList;
import chemaxon.naming.n2s.lex.data.StereoNumber;
import chemaxon.struc.MolAtom;

public class AtomLocant
extends Locant {
    protected int locantIndex = 0;
    public boolean atomUnmatched;

    public static AtomLocant create(char atom) {
        return AtomLocant.create(0, atom);
    }

    public static AtomLocant create(int num, char atom) {
        return AtomLocant.create(num, 0, atom);
    }

    public static AtomLocant create(int num, int primes, char atom) {
        return AtomLocant.create(num, primes, MolAtom.numOf("" + atom));
    }

    public static AtomLocant create(int num, int primes, int atno) {
        return new AtomLocant(num, primes, atno);
    }

    @Override
    public int getUnmatchedAtno() {
        if (this.atomUnmatched) {
            return this.getAtno();
        }
        return super.getUnmatchedAtno();
    }

    private AtomLocant(int num, int primes, int atno) {
        this.value = atno;
        this.locantIndex = num;
        this.setParent(primes);
        N2S.getState().structureMatches = true;
    }

    public AtomLocant(Locant l, int atno) {
        this.value = atno;
        this.locantIndex = l.getSimpleValue();
        if (this.locantIndex <= 0) {
            throw new RuntimeException("Invalid atom locant");
        }
        this.primes = l.primes;
    }

    public int getLocantIndex() {
        return this.locantIndex;
    }

    public void setLocantIndex(int locantIndex) {
        this.locantIndex = locantIndex;
    }

    public boolean setLocantIndex(LocantList l) {
        return this.setLocantIndex(l.getSingleLocant());
    }

    private boolean setLocantIndex(Locant locant) {
        if (this.locantIndex != 0) {
            return false;
        }
        if (locant == null) {
            return false;
        }
        int value = locant.getSimpleValue();
        if (value <= 0) {
            return false;
        }
        this.locantIndex = value;
        return true;
    }

    public String toString() {
        String res = this.getAtomSymbol();
        if (this.locantIndex > 0) {
            res = res + Integer.toString(this.locantIndex);
        }
        int i = this.getPrimes();
        while (--i >= 0) {
            res = res + "'";
        }
        return res;
    }

    public String getAtomSymbol() {
        return MolAtom.symbolOf(this.value);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof AtomLocant)) {
            return false;
        }
        AtomLocant oo = (AtomLocant)o;
        return this.getAtno() == oo.getAtno() && this.locantIndex == oo.locantIndex && this.getPrimes() == oo.getPrimes();
    }

    @Override
    public StereoNumber toStereoNumber() {
        if (this.getAtno() == 16) {
            return new StereoNumber(16);
        }
        return null;
    }

    @Override
    public int getValue() {
        throw new RuntimeException("use getAtno");
    }

    public int getAtno() {
        return this.value;
    }
}

