/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.n2s.lex.data;

import chemaxon.naming.n2s.lex.data.ComplexLocant;
import chemaxon.naming.n2s.lex.data.Locant;
import chemaxon.naming.n2s.lex.data.Str;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;

public class BridgeStr
extends Str {
    public int multiplier;

    public BridgeStr() {
        this.name = "epi";
    }

    @Override
    public Str cloneMe() {
        return this.clone();
    }

    @Override
    public Molecule getCompleteStructureClear() {
        throw new RuntimeException("Bridge cannot be the parent");
    }

    @Override
    public Molecule createParentMolecule() {
        if (this.substituents != null && this.substituents.size() == 1) {
            return ((Str)this.substituents.remove(0)).createParentMolecule();
        }
        return null;
    }

    @Override
    protected void connectToParent(Str parent) {
        MolAtom[] roots = this.getRoots(parent);
        if (this.multiplier == -1) {
            this.multiplier = 1;
        }
        if (roots.length != this.multiplier * 2) {
            throw new RuntimeException("Epi: " + roots.length + " locants for " + this.multiplier + " multiplicity");
        }
        Molecule bridgeMbase = this.getMol();
        for (int i = 0; i < roots.length; i += 2) {
            MolBond b;
            Molecule bridgeM = bridgeMbase.cloneMolecule();
            BridgeStr.fuseCleared(parent.getMol(), bridgeM);
            MolAtom radical = bridgeM.getAtom(0);
            if (radical.getRadical() == 6) {
                radical.setRadical(0);
            }
            MolAtom root1 = roots[i];
            MolAtom root2 = roots[i + 1];
            parent.addBond(root1, radical, 1, this);
            parent.addBond(root2, radical, 1, this);
            if (roots.length != 2 || (b = root1.getBondTo(root2)) == null || b.getType() != 2) continue;
            b.setType(1);
        }
    }

    private MolAtom[] getRoots(Str parent) {
        if (this.locantsBefore != null && this.locantsBefore.getType() == 3) {
            MolAtom[] res = new MolAtom[this.locantsBefore.size() * 2];
            int n = 0;
            for (Locant loc : this.locantsBefore.getLocantsList()) {
                ComplexLocant l = (ComplexLocant)loc;
                res[n++] = parent.getAtom(l.getFirstLocant());
                res[n++] = parent.getAtom(l.getSecondLocant());
            }
            return res;
        }
        return parent.getAllAtoms(this.locantsBefore, 2);
    }
}

