/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.n2s.lex.data;

import chemaxon.marvin.io.formats.name.nameexport.Chem;
import chemaxon.naming.n2s.N2S;
import chemaxon.naming.n2s.Util;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class Dearomatizer {
    private BitSet isRingBond;
    private Molecule m;
    int[][] cycles;
    HashSet<MolBond> fullyAromaticBonds;
    HashSet<MolBond> partiallyAromaticBonds;
    int steps = 0;
    public static boolean dbg = false;

    static Molecule removePartialAromatization(Molecule res) {
        if (dbg) {
            System.out.println("Input to dearomatizer: " + Dearomatizer.display(res));
        }
        return new Dearomatizer(res).go();
    }

    Dearomatizer(Molecule res) {
        this.m = res;
    }

    private Molecule go() {
        if (this.m.dearomatize()) {
            return this.m;
        }
        N2S.getState().structureMatches = true;
        this.cycles = this.m.getSSSRBonds();
        this.isRingBond = this.computeRingBonds(this.cycles);
        this.removeImpossibleAtomaticBonds();
        this.classifyBonds();
        if (dbg) {
            this.printDebugStats();
        }
        return this.run();
    }

    private void classifyBonds() {
        this.fullyAromaticBonds = new HashSet(this.m.getBondCount());
        this.partiallyAromaticBonds = new HashSet(this.m.getBondCount());
        for (int[] cycle : this.cycles) {
            int numAromatic = 0;
            int i = cycle.length;
            while (--i >= 0) {
                MolBond bond = this.m.getBond(cycle[i]);
                if (bond.getType() != 4) continue;
                ++numAromatic;
            }
            if (numAromatic == 0) continue;
            HashSet<MolBond> storeBonds = numAromatic == cycle.length ? this.fullyAromaticBonds : this.partiallyAromaticBonds;
            int i2 = cycle.length;
            while (--i2 >= 0) {
                MolBond bond = this.m.getBond(cycle[i2]);
                if (bond.getType() != 4) continue;
                storeBonds.add(bond);
            }
        }
        this.partiallyAromaticBonds.removeAll(this.fullyAromaticBonds);
    }

    private BitSet computeRingBonds(int[][] cycles) {
        BitSet res = new BitSet();
        int[][] arr$ = cycles;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int[] cycle;
            for (int bond : cycle = arr$[i$]) {
                res.set(bond);
            }
        }
        return res;
    }

    private int getRingBondCount(MolAtom a) {
        int res = 0;
        int b = a.getBondCount();
        while (--b >= 0) {
            if (!this.isRingBond.get(this.m.indexOf(a.getBond(b)))) continue;
            ++res;
        }
        return res;
    }

    private void printDebugStats() {
        System.out.println("Cycles: " + this.cycles.length);
        System.out.println("Aromatic bonds in fully aromatic cycles: " + this.fullyAromaticBonds.size());
        System.out.println("Aromatic bonds in partially aromatic cycles: " + this.partiallyAromaticBonds.size());
        System.out.println(this.m.toFormat("cxsmiles"));
    }

    private Molecule run() {
        while (this.doSomething()) {
            if (this.steps++ <= 100) continue;
            throw new RuntimeException("Dearomatizing forever");
        }
        if (this.m.dearomatize()) {
            return this.m;
        }
        if (this.useDefaultHydro()) {
            return this.run();
        }
        if (this.partiallyAromaticBonds.isEmpty()) {
            return this.m;
        }
        if (dbg) {
            System.out.println("Still partially aromatic:");
            this.printDebugStats();
        }
        return null;
    }

    private boolean useDefaultHydro() {
        for (MolAtom a : this.m.getAtomArray()) {
            if (!Util.isDefaultHydro(a)) continue;
            if (dbg) {
                System.out.println("Use default hydro on " + this.display(a));
            }
            if (a.getAtno() == 6) {
                this.removeAromaticBonds(a);
            } else {
                a.setImplicitHcount(a.getImplicitHcount() + 1);
            }
            Util.disableDefaultHydro(a);
            return true;
        }
        return false;
    }

    private void removeAromaticBonds(MolAtom a) {
        int b = a.getBondCount();
        while (--b >= 0) {
            MolBond bond = a.getBond(b);
            if (bond.getType() != 4) continue;
            bond.setType(1);
            if (this.partiallyAromaticBonds.remove(bond)) continue;
            this.classifyBonds();
        }
    }

    boolean doSomething() {
        if (this.partiallyAromaticBonds.isEmpty()) {
            return false;
        }
        boolean res = false;
        res |= this.removeValenceFull();
        if (this.handleOddAromatics()) {
            return true;
        }
        return res;
    }

    private boolean removeImpossibleAtomaticBonds() {
        boolean doneSomething = false;
        for (MolAtom a : this.m.getAtomArray()) {
            if (this.getRingBondCount(a) > 2 || !this.isValenceFull(a, true)) continue;
            int b = a.getBondCount();
            while (--b >= 0) {
                MolBond bond = a.getBond(b);
                if (bond.getType() != 4) continue;
                if (dbg) {
                    System.out.println("Remove impossible aromatic bond: " + this.display(bond));
                }
                bond.setType(1);
                doneSomething = true;
            }
        }
        return doneSomething;
    }

    private boolean handleOddAromatics() {
        for (MolBond b : this.partiallyAromaticBonds) {
            ArrayList<MolBond> bonds = this.partialAromNeighbours(b);
            if (bonds == null || bonds.size() % 2 != 1) continue;
            if (dbg) {
                System.out.println("Found odd aromatic chain: " + this.display(bonds) + " from " + this.display(b));
            }
            this.changePA(bonds.get(0), 2);
            for (int i = 1; i < bonds.size(); i += 2) {
                this.changePA(bonds.get(i), 1);
                this.changePA(bonds.get(i + 1), 2);
            }
            return true;
        }
        return false;
    }

    private ArrayList<MolBond> partialAromNeighbours(MolBond b) {
        ArrayList<MolBond> res = new ArrayList<MolBond>();
        if (this.partialAromNeighbours(res, b, b.getAtom1(), b.getAtom2())) {
            return null;
        }
        Collections.reverse(res);
        res.add(b);
        if (this.partialAromNeighbours(res, b, b.getAtom2(), b.getAtom1())) {
            return null;
        }
        return res;
    }

    private boolean partialAromNeighbours(ArrayList<MolBond> list, MolBond b, MolAtom from, MolAtom not) {
        boolean found = false;
        for (MolAtom a : from.getLigands()) {
            MolBond bb;
            if (a == not || !this.partiallyAromaticBonds.contains(bb = from.getBondTo(a))) continue;
            if (list.contains(bb)) {
                return true;
            }
            if (found) {
                return true;
            }
            found = true;
            list.add(bb);
            if (!this.partialAromNeighbours(list, bb, a, from)) continue;
            return true;
        }
        return false;
    }

    private void changePA(MolBond b, int type) {
        b.setType(type);
        boolean removed = this.partiallyAromaticBonds.remove(b);
        assert (removed);
    }

    private boolean hasAromaticNeighbour(MolBond b) {
        return this.hasAromaticNeighbour(b, b.getAtom1()) || this.hasAromaticNeighbour(b, b.getAtom2());
    }

    private boolean hasAromaticNeighbour(MolBond b, MolAtom from) {
        int i = from.getBondCount();
        while (--i >= 0) {
            MolBond other = from.getBond(i);
            if (other == b || other.getType() != 4) continue;
            return true;
        }
        return false;
    }

    private boolean removeValenceFull() {
        boolean doneSomething = false;
        Iterator<MolBond> it = this.partiallyAromaticBonds.iterator();
        while (it.hasNext()) {
            MolBond b = it.next();
            if (!this.removeValenceFull(b)) continue;
            it.remove();
            doneSomething = true;
        }
        return doneSomething;
    }

    private boolean removeValenceFull(MolBond b) {
        if (this.isValenceFull(b.getAtom1(), false) || this.isValenceFull(b.getAtom2(), false)) {
            b.setType(1);
            if (dbg) {
                System.out.println("Full valence on " + b.getAtom1().getAliasstr() + "-" + b.getAtom2().getAliasstr());
            }
            return true;
        }
        return false;
    }

    private boolean isValenceFull(MolAtom a, boolean strict) {
        int minimalValence = this.getMinimalDoubleValence(a, strict);
        if (a.getAtno() == 7 && minimalValence == 10) {
            return false;
        }
        int desiredValence = this.getDesiredValence(a);
        if (strict) {
            return minimalValence > 2 * desiredValence;
        }
        return minimalValence >= 2 * desiredValence;
    }

    private int getDesiredValence(MolAtom a) {
        int atno = a.getAtno();
        int res = Chem.standardValence(atno);
        if (atno == 7 && a.getCharge() == 1) {
            ++res;
        }
        return res;
    }

    private int getMinimalDoubleValence(MolAtom a, boolean strict) {
        int doubleValence = 0;
        int b = a.getBondCount();
        block6: while (--b >= 0) {
            MolBond bond = a.getBond(b);
            switch (bond.getType()) {
                case 1: {
                    doubleValence += 2;
                    continue block6;
                }
                case 2: {
                    doubleValence += 4;
                    continue block6;
                }
                case 3: {
                    doubleValence += 6;
                    continue block6;
                }
                case 4: {
                    if (strict || this.fullyAromaticBonds.contains(bond)) {
                        doubleValence += 3;
                        continue block6;
                    }
                    doubleValence += 2;
                    continue block6;
                }
            }
            throw new RuntimeException("Unhandled bond type: " + bond.getType());
        }
        return doubleValence;
    }

    private boolean removeBonds() {
        boolean doneSomething = false;
        for (int[] cycle : this.cycles) {
            MolBond b1;
            int numAromatic = 0;
            int numPartiallyAromatic = 0;
            int i = cycle.length;
            while (--i >= 0) {
                MolBond bond = this.m.getBond(cycle[i]);
                if (bond.getType() != 4) continue;
                ++numAromatic;
                if (this.fullyAromaticBonds.contains(bond)) continue;
                ++numPartiallyAromatic;
            }
            if (numAromatic == 0 || numAromatic == cycle.length) continue;
            if (numPartiallyAromatic == 1) {
                i = cycle.length;
                while (--i >= 0) {
                    b1 = this.bond(cycle, i);
                    if (b1.getType() != 4 || !this.partiallyAromaticBonds.contains(b1)) continue;
                    b1.setType(2);
                    this.partiallyAromaticBonds.remove(b1);
                    doneSomething = true;
                    if (!dbg) continue;
                    System.out.println("1/1 on " + this.display(b1));
                }
            }
            if (numAromatic == 3 && numPartiallyAromatic == 1 && cycle.length == 5) {
                i = cycle.length;
                while (--i >= 0) {
                    b1 = this.bond(cycle, i);
                    if (b1.getType() != 4 || this.fullyAromaticBonds.contains(b1)) continue;
                    b1.setType(1);
                    this.partiallyAromaticBonds.remove(b1);
                    doneSomething = true;
                    if (!dbg) continue;
                    System.out.println("1/3");
                }
            }
            if (numPartiallyAromatic != 3) continue;
            i = cycle.length;
            while (--i >= 0) {
                MolBond b2;
                MolBond b0;
                b1 = this.bond(cycle, i);
                if (b1.getType() != 4 || (b0 = this.neighbour(b1, b1.getAtom1(), cycle)).getType() != 4 || (b2 = this.neighbour(b1, b1.getAtom2(), cycle)).getType() != 4) continue;
                b0.setType(2);
                b1.setType(1);
                b2.setType(2);
                this.partiallyAromaticBonds.remove(b0);
                this.partiallyAromaticBonds.remove(b1);
                this.partiallyAromaticBonds.remove(b2);
                doneSomething = true;
                if (!dbg) continue;
                System.out.println("3/3 on " + this.display(b0) + " " + this.display(b1) + " " + this.display(b2));
            }
        }
        return doneSomething;
    }

    private MolBond neighbour(MolBond b1, MolAtom atom1, int[] cycle) {
        int i = atom1.getBondCount();
        while (--i >= 0) {
            MolBond b2 = atom1.getBond(i);
            if (b2 == b1 || !chemaxon.marvin.io.formats.name.nameexport.Util.contains(cycle, this.m.indexOf(b2))) continue;
            return b2;
        }
        return null;
    }

    private MolBond bond(int[] cycle, int i) {
        return this.m.getBond(cycle[i]);
    }

    private String display(List<MolBond> bonds) {
        if (bonds.size() == 0) {
            return "[]";
        }
        if (bonds.size() == 1) {
            return this.display(bonds.get(0));
        }
        StringBuilder res = new StringBuilder();
        MolAtom a = Util.commonAtom(bonds.get(0), bonds.get(1));
        a = bonds.get(0).getOtherAtom(a);
        res.append(this.display(a));
        for (MolBond b : bonds) {
            MolAtom next = b.getOtherAtom(a);
            res.append('-').append(this.display(next));
            a = next;
        }
        return res.toString();
    }

    private String display(MolBond b) {
        return this.display(b.getAtom1()) + "-" + this.display(b.getAtom2());
    }

    private String display(MolAtom atom) {
        return atom.getAliasstr();
    }

    private static String display(Molecule m) {
        return m.toFormat("cxsmiles");
    }
}

