/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.n2s.lex.data;

import chemaxon.naming.n2s.lex.data.Str;
import chemaxon.naming.n2s.lex.data.StructureToken;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import java.util.List;

public class Diacetate
extends StructureToken {
    public Diacetate(String struc) {
        super("diacetate", struc);
    }

    @Override
    public void connect(Str substituent) {
        List<MolAtom> OHs = substituent.getHydroxys();
        if (OHs.size() == 0) {
            // empty if block
        }
        if (OHs.size() != 2) {
            throw new RuntimeException("diacetate case not supported");
        }
        MolAtom[] connectionPoints = this.getConnectionPoints(substituent);
        if (connectionPoints.length != 2) {
            throw new RuntimeException("diacetate case not supported");
        }
        Molecule subM = substituent.getCompleteStructure();
        Diacetate.fuseCleared(this.getParentMol(), subM);
        for (int i = 0; i < 2; ++i) {
            MolAtom connectionPoint = connectionPoints[i];
            MolAtom OH = OHs.get(i);
            this.mergeAtoms(connectionPoint, OH);
            if (OH.getCharge() != -1) continue;
            OH.setCharge(0);
        }
    }
}

