/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.n2s.lex.data;

import chemaxon.naming.n2s.UtilLegacy;
import chemaxon.naming.n2s.lex.data.Token;

public class EndingToken
extends Token {
    public static final int NOT_SET = 0;
    public static final int SALT_ENDING = 1;
    public static final int ACID_ENDING = 2;
    public static final int ION_ENDING = 3;
    public static final int AMINE_ENDING = 4;
    public static final int RADICAL_ENDING = 5;
    public static final int BOND_ENDING = 6;
    private static final int MAXTYPE = 6;
    private String ending;
    private int type = 0;

    public EndingToken(String name, String ending) {
        this.name = name;
        while (ending.endsWith(".")) {
            ending = ending.substring(0, ending.length() - 1);
        }
        this.ending = ending;
        this.setTypes(ending);
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public String getValue() {
        return this.ending;
    }

    @Override
    public void setValue(String value) {
        this.ending = value;
    }

    @Override
    public String getTypeInString() {
        switch (this.type) {
            case 0: {
                return "NOT_SET";
            }
            case 1: {
                return "SALT_ENDING";
            }
            case 2: {
                return "ACID_ENDING";
            }
            case 3: {
                return "ION_ENDING";
            }
            case 4: {
                return "AMINE_ENDING";
            }
            case 5: {
                return "RADICAL_ENDING";
            }
            case 6: {
                return "BOND_ENDING";
            }
        }
        return "ERROR " + this.type;
    }

    private void setTypes(String ending) {
        if (ending.length() < 1) {
            return;
        }
        int n = this.type = ending.startsWith("|") ? 5 : 0;
        while (ending.startsWith("=") || ending.startsWith("#") || ending.startsWith("|")) {
            if (ending.startsWith("|")) {
                this.type = 5;
            }
            ending = ending.substring(1);
        }
        if (ending.length() == 0 && this.type != 5) {
            this.type = 6;
        }
        if (ending.matches("[+|-]h[+|-]")) {
            this.type = 3;
        }
        if (ending.equals("[SALT]")) {
            this.type = 1;
        }
        if (this.name.endsWith("acid")) {
            this.type = 2;
        }
    }

    public boolean equalsName(String name) {
        return UtilLegacy.isName(this.name, name);
    }
}

