/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.n2s.lex.data;

import chemaxon.naming.n2s.Util;
import chemaxon.naming.n2s.lex.data.Str;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;

public class EtherStr
extends Str {
    private int atno;
    Str etherStructure = null;

    public EtherStr(String name, int atno) {
        super(name);
        this.atno = atno;
    }

    @Override
    public Str cloneMe() {
        return null;
    }

    @Override
    public Molecule createParentMolecule() {
        if (this.etherStructure != null) {
            return this.etherStructure.createParentMolecule();
        }
        Molecule res = Util.newMolecule();
        MolAtom o = new MolAtom(this.atno);
        this.setLocant(o, "ESTERIFIED");
        res.add(o);
        return res;
    }

    @Override
    boolean canSubstitute(MolAtom a, boolean prospective) {
        return true;
    }

    @Override
    protected void connectToParent(Str parent) {
        MolAtom[] os = parent.getAllChalcogens(this.atno);
        if (os.length == this.substituents.size()) {
            int n = 0;
            for (Str sub : this.substituents) {
                MolAtom connection = os[n++];
                parent.connect(sub, connection);
            }
            return;
        }
        super.connectToParent(parent);
    }

    @Override
    public void generate() {
        if (this.substituents == null) {
            throw new RuntimeException("Unsubstituted ether");
        }
        super.generate();
    }

    public void setEther(Str s) {
        this.etherStructure = s;
    }

    @Override
    protected MolAtom duplicateEsterConnection(MolAtom ester1) {
        return null;
    }

    @Override
    public boolean isSimpleEther() {
        return this.etherStructure == null;
    }
}

