/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.n2s.lex.data;

import chemaxon.naming.n2s.lex.data.SimpleLocant;
import chemaxon.naming.n2s.lex.data.Str;
import chemaxon.struc.MolAtom;

public class NonStdValenceLocant
extends SimpleLocant {
    private int valence;
    private final boolean empty;

    public NonStdValenceLocant(int value, int parent, int valence) {
        super(value, parent);
        this.valence = valence;
        this.empty = false;
    }

    public NonStdValenceLocant(int valence) {
        super(0, 0);
        this.valence = valence;
        this.empty = true;
    }

    public int getValence() {
        return this.valence;
    }

    public void setValence(int valence) {
        this.valence = valence;
    }

    @Override
    public String toString() {
        String val = this.empty ? "" : Integer.toString(this.value);
        for (int i = 0; i < this.primes; ++i) {
            val = val + "'";
        }
        if (val.equals("0")) {
            val = "";
        }
        val = val + "$l^{" + Integer.toString(this.valence) + "}";
        return val;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof NonStdValenceLocant)) {
            return false;
        }
        NonStdValenceLocant oo = (NonStdValenceLocant)o;
        return super.equals(oo) && this.valence == oo.valence;
    }

    @Override
    public boolean applyToParent(Str parent) {
        MolAtom a = parent.getAtom(this);
        this.applyTo(a);
        return true;
    }

    @Override
    public void applyTo(MolAtom a) {
        a.setValenceProp(this.valence);
    }

    @Override
    public MolAtom getAtom(Str s) {
        if (this.empty && s.isMonoAtomic()) {
            return s.getParentMol().getAtom(0);
        }
        return super.getAtom(s);
    }
}

