/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.n2s.lex.data;

import chemaxon.naming.n2s.lex.data.Token;

public class Number
extends Token {
    public static final int BOTH = 0;
    public static final int MULTIPLIER = 1;
    public static final int CARBONCHAIN = 2;
    private static final int MAXTYPE = 2;
    private int value;
    private int type;

    public Number(String name, String value, int type) {
        this.name = name;
        if (type > 2) {
            type = 0;
        }
        this.type = type;
        if (value.endsWith("*")) {
            value = value.substring(0, value.length() - 1);
        }
        this.value = Integer.parseInt(value);
        if (this.value < 5) {
            this.type = 1;
        }
    }

    public int getData() {
        return this.value;
    }

    public void setData(int value) {
        this.value = value;
    }

    public void setType(int type) {
        if (type < 0 || type > 2) {
            type = 0;
        }
        this.type = type;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public String getValue() {
        return Integer.toString(this.value);
    }

    @Override
    public String getTypeInString() {
        switch (this.type) {
            case 0: {
                return "BOTH";
            }
            case 1: {
                return "MULTIPLIER";
            }
            case 2: {
                return "CARBONCHAIN";
            }
        }
        return "ERROR " + this.type;
    }
}

