/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.n2s.lex.data;

import chemaxon.naming.n2s.lex.data.Token;

public class SpecialGroup
extends Token {
    public static final int NOT_SET = -1;
    public static final int SPIRO = 0;
    public static final int CYCLO = 1;
    private int type;
    private String value;

    public SpecialGroup(String name, String value) {
        super(name);
        this.value = value;
        this.type = name.equalsIgnoreCase("spiro") ? 0 : (name.equalsIgnoreCase("cyclo") ? 1 : -1);
    }

    @Override
    public int getType() {
        return this.type;
    }

    public boolean valid() {
        return this.type > -1;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public String getTypeInString() {
        switch (this.type) {
            case -1: {
                return "NOT_SET";
            }
            case 0: {
                return "SPIRO";
            }
            case 1: {
                return "CYCLO";
            }
        }
        return "ERROR " + this.type;
    }
}

