/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.n2s.lex.data;

import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolImporter;
import chemaxon.marvin.io.MolExportException;
import chemaxon.marvin.io.formats.name.nameexport.Chem;
import chemaxon.marvin.io.formats.name.util.TextUtils;
import chemaxon.naming.n2s.NameImportException;
import chemaxon.naming.n2s.Util;
import chemaxon.naming.n2s.UtilLegacy;
import chemaxon.naming.n2s.lex.StructureLexer;
import chemaxon.naming.n2s.lex.data.AminoAcidStr;
import chemaxon.naming.n2s.lex.data.Anhyride;
import chemaxon.naming.n2s.lex.data.Diacetate;
import chemaxon.naming.n2s.lex.data.HydrazoneStr;
import chemaxon.naming.n2s.lex.data.Locant;
import chemaxon.naming.n2s.lex.data.LocantList;
import chemaxon.naming.n2s.lex.data.MarkushStr;
import chemaxon.naming.n2s.lex.data.Nor;
import chemaxon.naming.n2s.lex.data.Nucleoside;
import chemaxon.naming.n2s.lex.data.OximeStr;
import chemaxon.naming.n2s.lex.data.SimpleLocant;
import chemaxon.naming.n2s.lex.data.SpecialLocant;
import chemaxon.naming.n2s.lex.data.SpecialStr;
import chemaxon.naming.n2s.lex.data.Str;
import chemaxon.naming.n2s.lex.data.Sugar;
import chemaxon.naming.n2s.parse.HeteroAtomStr;
import chemaxon.naming.n2s.parse.Suffix;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.PeriodicSystem;
import java.util.ArrayList;

public class StructureToken
extends Str
implements Cloneable {
    private String smiles;
    private String options;
    public StructureToken cloneOf;
    protected int defaultStereo;

    public static Str create(String name, String struc) {
        if (name.equals("anhydride")) {
            return new Anhyride();
        }
        if (name.equals("oxime") || name.equals("monoxime") || name.equals("monooxime")) {
            return new OximeStr(name, struc);
        }
        if (name.equals("diacetate")) {
            return new Diacetate(struc);
        }
        if (name.equals("nor")) {
            return new Nor();
        }
        if (struc.startsWith("%")) {
            return new SpecialStr(name, struc.substring(1));
        }
        String newStructure = StructureToken.isType(struc, "Query");
        if (newStructure != null) {
            return new MarkushStr(name, newStructure);
        }
        newStructure = StructureToken.isType(struc, "NucleoBase");
        if (newStructure != null) {
            return new Nucleoside(name, newStructure);
        }
        newStructure = StructureToken.isType(struc, "AminoAcid");
        if (newStructure != null) {
            return new AminoAcidStr(name, newStructure);
        }
        newStructure = StructureToken.isType(struc, "KetoPyranose");
        if (newStructure != null) {
            return new Sugar(name, newStructure, Sugar.Kind.KetoPyranose);
        }
        newStructure = StructureToken.isType(struc, "KetoFuranose");
        if (newStructure != null) {
            return new Sugar(name, newStructure, Sugar.Kind.KetoFuranose);
        }
        newStructure = StructureToken.isType(struc, "Sugar");
        if (newStructure != null) {
            return new Sugar(name, newStructure);
        }
        if (struc.startsWith("|")) {
            return HeteroAtomStr.create(name, struc.substring(1));
        }
        if (HydrazoneStr.isHydrazoneClass(name)) {
            return new HydrazoneStr(name, struc);
        }
        return new StructureToken(name, struc);
    }

    private static String isType(String struc, String type) {
        int start = struc.indexOf("\t" + type);
        if (start == -1) {
            return null;
        }
        int end = struc.indexOf(9, start + 1);
        if (end == -1) {
            return struc.substring(0, start);
        }
        return struc.substring(0, start + 1) + struc.substring(end + 1).trim();
    }

    public StructureToken(String name, String struc) {
        this.name = name;
        int optionStart = struc.indexOf(9);
        if (optionStart == -1) {
            this.smiles = struc;
        } else {
            this.smiles = struc.substring(0, optionStart);
            this.options = struc.substring(optionStart + 1);
        }
    }

    @Override
    public Molecule createParentMolecule() {
        Molecule res;
        try {
            res = Util.parseSmilesOrAny(this.smiles);
        }
        catch (MolFormatException e) {
            throw new RuntimeException(e);
        }
        for (MolAtom a : res.getAtomArray()) {
            String keys;
            if (a.getAliasstr() == null) {
                a.setAliasstr(a.getExtraLabel());
            }
            if ((keys = a.getAliasstr()) != null) {
                if (keys.contains("defHydro")) {
                    Util.enableDefaultHydro(a);
                }
                if (keys.contains("mergeWithO")) {
                    a.putProperty("mergeWithO", Boolean.TRUE);
                }
                if (keys.contains("mergeWithN")) {
                    a.putProperty("mergeWithN", Boolean.TRUE);
                }
            }
            if (a.getAtno() != 134 || res.getAtomCount() <= 1) continue;
            res.removeAtom(a);
        }
        return res;
    }

    @Override
    public String getValue() {
        return this.smiles;
    }

    @Override
    public void setValue(String value) {
        this.smiles = value;
    }

    @Override
    public boolean consume(LocantList locants, int mul) {
        return locants.is(SpecialLocant.n) && !this.isModified() && (this.isStraightChain() && !this.is("acet") || this.name.startsWith("butyr") || this.name.startsWith("valer"));
    }

    @Override
    public void addSuffix(Suffix suffix) {
        Suffix sulfonicAcid;
        if (suffix.getName().equals("ane") && !suffix.hasLocant()) {
            return;
        }
        if (suffix.is("hydrazide") && (sulfonicAcid = this.getSuffix("sulfonic acid")) != null) {
            sulfonicAcid.setName("sulfonic acid hydrazide");
            sulfonicAcid.setValue("S(=O)(=O)NN");
            return;
        }
        if (this.is("aceton") && (suffix.is("at") || suffix.is("ato"))) {
            throw new NameImportException.ParseException("acetonate is not supported yet");
        }
        if (suffix.is("at") && !suffix.hasLocant()) {
            String acid = (String)StructureLexer.getDict().get(this.name + "ic acid");
            if (acid == null) {
                acid = (String)StructureLexer.getDict().get(this.name + "oic acid");
            }
            if (acid == null && (acid = (String)StructureLexer.getDict().get(this.name + "ic")) != null) {
                suffix.setValue("C(=O)[O-] |$;;ester$|");
            } else if (acid != null) {
                if (acid.contains("\t")) {
                    throw new NameImportException.ParseException("Unhandled acid: " + this.name + "ate");
                }
                this.smiles = acid;
                this.setName(this.getName() + "ate");
                return;
            }
        }
        if (this.is("isopropyl") && !suffix.hasLocant()) {
            suffix.setLocant(new SimpleLocant(2));
        }
        if (this.is("androst") && !suffix.hasLocant() && suffix.getMultiplicity() == 2) {
            suffix.setLocant(LocantList.simpleList(3, 17));
        }
        if (this.is("thiophen") && suffix.is("ol")) {
            this.setName("thiophenol");
            this.setValue("Sc1ccccc1 |$;1;2;3;4;5;6$|");
            return;
        }
        super.addSuffix(suffix);
    }

    @Override
    public StructureToken cloneMe() {
        return this.cloneMe(true);
    }

    @Override
    public StructureToken cloneMe(boolean alwaysDeep) {
        StructureToken res;
        if (this.cloneOf == null) {
            this.cloneOf = this;
            res = this;
            if (!alwaysDeep) {
                return this;
            }
        } else {
            res = (StructureToken)this.clone();
        }
        if (this.substituents != null) {
            ArrayList<Str> subs = new ArrayList<Str>(res.substituents.size());
            for (Str sub : res.substituents) {
                subs.add(sub.cloneMe(false));
            }
            res.substituents = subs;
        }
        if (this.locantsBefore != null) {
            res.locantsBefore = this.locantsBefore.clone();
        }
        return res;
    }

    public String basicSmiles() {
        return UtilLegacy.basicSmiles(this.smiles);
    }

    @Override
    public boolean isEsterParent() {
        if (this.is("hydrate")) {
            return false;
        }
        if (this.is("glycol")) {
            return true;
        }
        return super.isEsterParent();
    }

    @Override
    public boolean isCyclic() {
        if (this.basicSmiles().indexOf(49) != -1) {
            return true;
        }
        return super.isCyclic();
    }

    @Override
    public boolean isMonoAtomic() {
        int parentAtoms = this.getNumParentAtoms();
        if (parentAtoms > 1) {
            return false;
        }
        if (parentAtoms == 1) {
            return true;
        }
        String smiles = this.basicSmiles();
        if (smiles.length() == 1) {
            return true;
        }
        if (smiles.equals("Cl") || smiles.equals("Br")) {
            return true;
        }
        if (this.is("hydrogen")) {
            return false;
        }
        return smiles.charAt(0) == '[' && smiles.length() <= 6 && smiles.charAt(smiles.length() - 1) == ']';
    }

    public boolean isStraightChain() {
        if (this.smiles == null) {
            return false;
        }
        if (this.name.startsWith("iso")) {
            return false;
        }
        String simplified = this.smiles.replace("C", "");
        return simplified.length() == 0 || simplified.startsWith(" ");
    }

    @Override
    public boolean isChain() {
        if (this.smiles == null) {
            return false;
        }
        if (this.is("carbin")) {
            return false;
        }
        if (this.is("isobut")) {
            return true;
        }
        return UtilLegacy.isChain(this.smiles);
    }

    @Override
    public boolean hasDefaultLocants() {
        if (this.options == null) {
            return false;
        }
        return this.options.indexOf("Substituent:") != -1 || this.options.indexOf("RGroups:") != -1 || this.options.indexOf("AtomsToReplace:") != -1 || this.options.indexOf("ConnectionPoint:") != -1;
    }

    boolean hasOneDefaultLocant() {
        if (this.options == null) {
            return false;
        }
        return this.options.indexOf("Substituent:") != -1 || this.options.indexOf("RGroups:") != -1 || this.options.indexOf("AtomsToReplace:") != -1;
    }

    @Override
    public boolean tryAddLocantsBefore(LocantList locants, boolean cautious) {
        if (locants.size() == 2 && this.locantInParent == null && this.hasLocant(SpecialLocant.end2)) {
            this.locantInParent = locants;
            return true;
        }
        return super.tryAddLocantsBefore(locants, cautious);
    }

    @Override
    protected void setDefaultBondLocants(LocantList l, int multiplicity) {
        if (this.is("buta") && multiplicity == 2) {
            l.tryAddLocant(new SimpleLocant(1));
            l.tryAddLocant(new SimpleLocant(3));
        }
    }

    @Override
    int getDefaultStereo() {
        return this.defaultStereo;
    }

    Locant reinterpretLocantAsNumber(Locant l) {
        if (l.isGreekLetter() && !this.isCyclic()) {
            int n = UtilLegacy.greekLetterToNumbering(l.getValue());
            if (this.isAcid()) {
                ++n;
            }
            return new SimpleLocant(n);
        }
        return l;
    }

    @Override
    public boolean hasLocantForSubstituent(Locant l) {
        if (l.isOrthoMetaPara() && this.hasDefaultLocants() && !this.locantsBefore.hasLocant() && !this.is("toluene") && !this.is("toluol") && !this.is("veratrole")) {
            return false;
        }
        return super.hasLocantForSubstituent(l);
    }

    public static SimpleLocant parseLocant(String loc) {
        int primes = 0;
        while (loc.endsWith("'")) {
            ++primes;
            loc = loc.substring(0, loc.length() - 1);
        }
        while (loc.endsWith("\"")) {
            primes += 2;
            loc = loc.substring(0, loc.length() - 1);
        }
        return new SimpleLocant(UtilLegacy.stringToLocant(loc), primes);
    }

    @Override
    public boolean firstAtomSubstituable() {
        try {
            return MolImporter.importMol(this.smiles).getAtom(0).getImplicitHcount() > 0;
        }
        catch (MolFormatException e) {
            return true;
        }
    }

    public boolean replaceLastO(HeteroAtomStr replacement) {
        for (int i = this.smiles.length() - 4; i >= 1; --i) {
            if (this.smiles.indexOf("[O-]", i) == -1) continue;
            String hetero = replacement.getSymbol();
            if (hetero.length() == 0) {
                throw new RuntimeException("Wrong replacement: " + replacement);
            }
            if (Chem.standardValence(replacement.getAtno()) != 1) {
                hetero = hetero + "-";
            }
            this.smiles = this.smiles.substring(0, i) + "[" + hetero + "]" + this.smiles.substring(i + 4);
            return true;
        }
        return false;
    }

    static String removeAllO(String smiles) {
        if (smiles.indexOf("|$") != -1) {
            try {
                Molecule m = MolImporter.importMol(smiles, "cxsmiles");
                boolean foundOne = false;
                int i = m.getAtomCount();
                while (--i >= 0) {
                    MolAtom a = m.getAtom(i);
                    if (a.getAtno() != 8 || a.getBondCount() != 1 || a.getBond(0).getType() != 1) continue;
                    foundOne = true;
                    m.removeAtom(a);
                }
                if (!foundOne) {
                    return null;
                }
                return m.exportToFormat("cxsmiles");
            }
            catch (MolFormatException e) {
                throw new NameImportException.Failure(e);
            }
            catch (MolExportException e) {
                throw new NameImportException.Failure(e);
            }
        }
        return smiles.replaceAll("\\(O\\)", "");
    }

    @Override
    public boolean acceptsAne() {
        if (this.isChain()) {
            return true;
        }
        if (this.isMonoAtomic()) {
            String basicSmiles = this.basicSmiles();
            try {
                int atno = MolImporter.importMol(basicSmiles, "smiles").getAtom(0).getAtno();
                int col = PeriodicSystem.getColumn(atno);
                return col >= 13 && col <= 17;
            }
            catch (MolFormatException e) {
                throw new RuntimeException(e);
            }
        }
        return super.acceptsAne();
    }

    @Override
    public void generate() {
        this.parseOptions();
        this.checkValidity();
        super.generate();
    }

    private void checkValidity() {
        if (this.is("phen") && this.suffixCount() == 0) {
            throw new RuntimeException("phen");
        }
    }

    @Override
    public boolean isSeparate() {
        MolAtom a;
        if (this.is("ammonium") && this.spaceSeparated) {
            return true;
        }
        if (this.substituents != null) {
            return false;
        }
        Molecule m = this.getParentMol();
        return m.getAtomCount() == 1 && PeriodicSystem.isMetal((a = m.getAtom(0)).getAtno());
    }

    @Override
    protected void connectToParent(Str parent) {
        if (this.hasLocant(SpecialLocant.end2)) {
            if (this.locantInParent == null || this.locantInParent.size() != 2) {
                throw new RuntimeException("Invalid end1/2");
            }
            Molecule m = this.getMol();
            MolAtom rad1 = this.getAtom(SpecialLocant.end1);
            MolAtom rad2 = this.getAtom(SpecialLocant.end2);
            Molecule parentM = parent.getMol();
            StructureToken.fuseCleared(parentM, m);
            parentM.add(new MolBond(rad1, parent.getAtom(this.locantInParent.getLocant(0))));
            parentM.add(new MolBond(rad2, parent.getAtom(this.locantInParent.getLocant(1))));
            return;
        }
        super.connectToParent(parent);
    }

    private void parseOptions() {
        String[] options;
        if (this.options == null) {
            return;
        }
        for (String option : options = TextUtils.split(this.options, '\t')) {
            String[] parts = TextUtils.splitFirst(option, ':');
            assert (parts != null) : "Wrong option format: " + option;
            String key = parts[0].trim().intern();
            String value = parts.length == 1 ? null : parts[1].trim();
            this.handleOption(key, value);
        }
    }

    private void handleOption(String key, String value) {
        if (key == "Hydrogens") {
            if (this.hydroCount() == 0) {
                SimpleLocant defaultHydrogen = StructureToken.parseLocant(value);
                MolAtom a = this.getAtom(defaultHydrogen);
                this.hydrogenize(a, 1);
            }
            return;
        }
        if (key == "AtomsToReplace") {
            ArrayList<Locant> locants;
            String[] entries = TextUtils.split(value, ' ');
            if (this.locantsBefore != null && this.locantsBefore.size() == entries.length) {
                locants = this.locantsBefore.getLocantsList();
                this.locantsBefore = null;
            } else {
                locants = null;
            }
            for (String entry : entries) {
                String[] e = TextUtils.split(entry, '@');
                String atom = e[0];
                Locant locant = locants != null ? locants.remove(0) : StructureToken.parseLocant(e[1]);
                MolAtom a = this.getAtom(locant);
                this.changeAtom(a, PeriodicSystem.getAtomicNumber(atom));
                a.valenceCheck();
            }
            return;
        }
        if (key == "FixOxoGroup") {
            String[] entries;
            for (String entry : entries = TextUtils.split(value, ' ')) {
                SimpleLocant locant = StructureToken.parseLocant(entry);
                MolAtom a = this.getAtom(locant);
                MolAtom oxo = new MolAtom(8);
                this.getParentMol().add(oxo);
                this.getParentMol().add(new MolBond(a, oxo, 2));
            }
            return;
        }
        if (key == "Substituent") {
            String[] entries = TextUtils.split(value, ' ');
            ArrayList<Locant> locants = null;
            if (this.locantsBefore != null) {
                if (this.is("xylene")) {
                    this.locantsBefore.isOrthoMetaPara = true;
                }
                this.locantsBefore = this.locantsBefore.expandOMP(entries.length);
                if (this.locantsBefore.size() == entries.length) {
                    locants = this.locantsBefore.getLocantsList();
                    this.locantsBefore = null;
                }
            }
            for (String entry : entries) {
                Molecule sub;
                String[] e = TextUtils.split(entry, '@');
                String subSmiles = e[0];
                Locant locant = locants != null ? locants.remove(0) : StructureToken.parseLocant(e[1]);
                MolAtom root = this.getAtom(locant);
                int bondType = 1;
                if (subSmiles.startsWith("=")) {
                    bondType = 2;
                    subSmiles = subSmiles.substring(1);
                }
                try {
                    sub = MolImporter.importMol(subSmiles.replace("|$", " |$"), "cxsmiles");
                }
                catch (MolFormatException e1) {
                    throw new RuntimeException(e1);
                }
                this.getParentMol().fuse(sub);
                this.addBond(root, sub.getAtom(0), bondType, new StructureToken(subSmiles, subSmiles));
                for (MolAtom a : sub.getAtomArray()) {
                    if (a.getAliasstr() == null) {
                        a.setAliasstr(a.getExtraLabel());
                    }
                    if (StructureToken.getLocant(a) == null) continue;
                    this.registerLocants(a);
                }
            }
            return;
        }
        if (key == "Stereo") {
            return;
        }
        if (key == "StereoD") {
            this.defaultStereo = 4;
            return;
        }
        if (key == "StereoL") {
            this.defaultStereo = 3;
            return;
        }
        if (key == "Chain") {
            return;
        }
        throw new RuntimeException("Unhandled structure option: " + key);
    }

    @Override
    public boolean consumeAtom(Str atom, boolean lonely) {
        Suffix ol;
        String a = atom.getValue();
        if (a.length() != 1) {
            return false;
        }
        if (this.is("phen") && (ol = this.getSuffix("ol")) != null) {
            ol.setValue(a);
            return true;
        }
        if (this.is("anisole")) {
            this.name = atom.getName() + this.name;
            this.smiles = "CSC1=CC=CC=C1 |$1;;;2;3;4;5;6$|";
            return true;
        }
        if (this.is("benzoic acid")) {
            this.name = atom.getName() + this.name;
            this.smiles = "c1(C(S)=O)ccccc1 |$0;;ester;;2;3;4;5;6;$|";
            return true;
        }
        if (this.is("acetic acid")) {
            this.name = atom.getName() + this.name;
            this.smiles = "CC(S)=O |$2,defCon,alpha;;ester;$|";
            return true;
        }
        Suffix oyl = this.getSuffix("oyl");
        if (oyl != null) {
            oyl.setName(atom.getName() + oyl.getName());
            oyl.setValue(oyl.getValue().replace("=O", "=" + a));
            return true;
        }
        Suffix amide = this.getSuffix("amide");
        if (amide != null) {
            amide.setName(atom.getName() + amide.getName());
            amide.setValue(amide.getValue().replace("=O", "=" + a));
            return true;
        }
        if (this.smiles.contains("=O")) {
            this.smiles = this.smiles.replaceFirst("=O", "=" + a);
            return true;
        }
        if (this.smiles.contains("O=")) {
            this.smiles = this.smiles.replaceFirst("O=", a + "=");
            return true;
        }
        if (this.options != null) {
            if (this.options.contains("=O")) {
                this.options = this.options.replaceFirst("=O", "=" + a);
                return true;
            }
            if (this.options.contains("O=")) {
                this.options = this.options.replaceFirst("O=", a + "=");
                return true;
            }
        }
        return super.consumeAtom(atom, lonely);
    }
}

