/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.n2s.parse;

import chemaxon.naming.n2s.Util;
import chemaxon.naming.n2s.lex.data.Str;
import chemaxon.struc.Molecule;
import java.util.ArrayList;
import java.util.List;

public class AggregateStr
extends Str {
    private List<Str> components;

    public AggregateStr(List<Str> components) {
        this.name = "AggregateStr";
        this.components = components;
    }

    public AggregateStr(Str s1, Str s2) {
        this.name = "AggregateStr";
        this.components = new ArrayList<Str>(2);
        this.components.add(s1);
        this.components.add(s2);
    }

    @Override
    public Molecule createParentMolecule() {
        Molecule res = Util.newMolecule();
        for (Str s : this.components) {
            Molecule m = s.getCompleteStructure();
            for (int i = 0; i < s.multiplicity; ++i) {
                if (i > 0) {
                    m = m.cloneMolecule();
                }
                res.fuse(m, false);
            }
        }
        return res;
    }

    @Override
    public Str cloneMe() {
        return null;
    }

    @Override
    public void connectToParent(Str parent) {
        throw new RuntimeException("AggregateStr cannot be a substitutent");
    }
}

