/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.n2s.parse;

import chemaxon.naming.n2s.Util;
import chemaxon.naming.n2s.UtilLegacy;
import chemaxon.naming.n2s.lex.data.Locant;
import chemaxon.naming.n2s.lex.data.LocantList;
import chemaxon.naming.n2s.lex.data.NonStdValenceLocant;
import chemaxon.naming.n2s.lex.data.Str;
import chemaxon.naming.n2s.lex.data.StructureToken;
import chemaxon.naming.n2s.parse.HeteroAtomStr;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import java.util.ArrayList;

public class BenzoFusedStr
extends Str {
    private StructureToken basicStruc = null;
    private ArrayList<HeteroAtomStr> heteroAtoms = new ArrayList();
    private Type type;

    public BenzoFusedStr(Type type, ArrayList<HeteroAtomStr> heteroAtoms, LocantList locants) {
        this.name = "BenzoFusedStr";
        this.type = type;
        this.basicStruc = new StructureToken("benzofused", type.smiles);
        for (int i = 0; i < heteroAtoms.size(); ++i) {
            HeteroAtomStr atom = heteroAtoms.get(i);
            this.basicStruc.addSubstituent(locants.getLocant(i), atom);
            this.heteroAtoms.add(atom);
            if (!(locants.getLocant(i) instanceof NonStdValenceLocant)) continue;
        }
    }

    @Override
    public Molecule createParentMolecule() {
        MolAtom a;
        Molecule mol = this.basicStruc.getParentMol(true);
        for (HeteroAtomStr hetero : this.heteroAtoms) {
            MolAtom a2 = this.basicStruc.getAtom(hetero.getLocantInParent().getSimpleLocant());
            this.changeAtom(a2, hetero.getAtno());
            if (hetero != this.heteroAtoms.get(0)) continue;
            Util.enableDefaultHydro(a2);
        }
        if (this.type == Type.Ole) {
            int index = -1;
            if (this.setBonds(mol, 1)) {
                this.setBondsType(mol, 3, 1);
                mol.getAtom(this.getAtomIndex(2)).getBondTo(mol.getAtom(this.getAtomIndex(3))).setType(2);
                index = 1;
            }
            if (this.setBonds(mol, 3) && index < 0) {
                this.setBondsType(mol, 1, 1);
                mol.getAtom(this.getAtomIndex(1)).getBondTo(mol.getAtom(this.getAtomIndex(2))).setType(2);
            }
        }
        if ((a = this.basicStruc.getAtom(Locant.One)).getImplicitHcount() != 0) {
            this.addLocant(a, "defaultRadical");
        } else {
            a = this.basicStruc.getAtom(Locant.Two);
            if (a.getImplicitHcount() != 0) {
                this.addLocant(a, "defaultRadical");
            }
        }
        return mol;
    }

    private boolean setBonds(Molecule mol, int index) {
        if (UtilLegacy.isOxygen(mol.getAtom(this.getAtomIndex(index)))) {
            this.setBondsType(mol, index, 1);
            return true;
        }
        return false;
    }

    private void setBondsType(Molecule mol, int atomIndex, int bondType) {
        MolAtom atom = mol.getAtom(atomIndex);
        for (int i = 0; i < atom.getBondCount(); ++i) {
            if (UtilLegacy.isOxygen(atom.getBond(i).getOtherAtom(atom))) continue;
            atom.getBond(i).setType(bondType);
        }
    }

    private int getAtomIndex(int index) {
        return index;
    }

    @Override
    public Str cloneMe() {
        BenzoFusedStr res = (BenzoFusedStr)this.clone();
        return res;
    }

    @Override
    public boolean isCyclic() {
        return true;
    }

    static enum Type {
        Ole(5, "c12cccc1cccc2 |$7a;1;2;3;3a;4;5;6;7$|"),
        Oline(5, "C1Cc2ccccc2C1 |$2;1;7a;7;6;5;4;3a;3$|"),
        Ine(6, "c12ccccc1cccc2 |$8a;1;2;3;4;4a;5;6;7;8$|"),
        Epine(7, "c12cccccc1cccc2 |$9a;1;2;3;4;5;5a;6;7;8;9$|"),
        Ocine(8, "c12ccccccc1cccc2 |$10a;1;2;3;4;5;6;6a;7;8;9;10$|"),
        Onine(9, "c12cccccccc1cccc2 |$11a;1;2;3;4;5;6;7;7a;8;9;10;11$|");

        final String smiles;
        final int ringSize;

        private Type(int ringSize, String smiles) {
            this.ringSize = ringSize;
            this.smiles = smiles;
        }
    }
}

