/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.n2s.parse;

import chemaxon.naming.n2s.lex.data.LocantList;
import chemaxon.naming.n2s.lex.data.Str;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;

public class Bridge
extends Str {
    private LocantList locants;
    private Str link;

    Bridge(String name, LocantList locants, Str link) {
        super(name);
        this.locants = locants;
        this.link = link;
    }

    @Override
    public Str cloneMe() {
        return this;
    }

    @Override
    public Molecule createParentMolecule() {
        return this.link.getParentMol();
    }

    @Override
    public void connectToParent(Str parent) {
        Molecule parentM = parent.getParentMol();
        Molecule m = this.getParentMol();
        parentM.fuse(m);
        MolAtom root1 = parent.getAtom(this.locants.getLocant(0));
        MolAtom root2 = parent.getAtom(this.locants.getLocant(1));
        parentM.add(new MolBond(root1, m.getAtom(0)));
        parentM.add(new MolBond(root2, m.getAtom(m.getAtomCount() - 1)));
    }
}

