/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.n2s.parse;

import chemaxon.naming.n2s.Util;
import chemaxon.naming.n2s.lex.data.Locant;
import chemaxon.naming.n2s.lex.data.LocantList;
import chemaxon.naming.n2s.lex.data.SimpleLocant;
import chemaxon.naming.n2s.lex.data.Str;
import chemaxon.naming.n2s.parse.FusedStr;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;

public class Cycle
extends Str {
    private int length;
    private int atom1;
    private int atom2 = -1;

    Cycle(int length, int atom1, int atom2) {
        this.name = "cycle(" + length + ")";
        this.length = length;
        this.atom1 = atom1;
        this.atom2 = atom2;
    }

    @Override
    public boolean isCyclic() {
        return true;
    }

    @Override
    public Str cloneMe() {
        return this.clone();
    }

    @Override
    public Molecule createParentMolecule() {
        Molecule res = Util.newMolecule();
        int bondType = this.getBondType();
        for (int i = 0; i < this.length; ++i) {
            int atno = this.atom2 > 0 ? (i % 2 == 0 ? this.atom1 : this.atom2) : this.atom1;
            MolAtom a = new MolAtom(atno);
            if (i == 0) {
                this.setLocant(a, "def");
            }
            res.add(a);
            if (i > 0) {
                res.add(new MolBond(res.getAtom(i - 1), a, bondType));
            }
            if (i != this.length - 1) continue;
            res.add(new MolBond(res.getAtom(0), a, bondType));
        }
        return res;
    }

    private int getBondType() {
        if (this.getParent() instanceof FusedStr) {
            FusedStr fused = (FusedStr)this.getParent();
            if (this == fused.leftStructure || this == fused.rightStructure) {
                return 4;
            }
        }
        return 1;
    }

    @Override
    public MolAtom getAtomInCore(Locant l) {
        int value;
        int n = value = l == null ? 1 : l.getSimpleValue();
        if (value < 1 || value > this.length) {
            return null;
        }
        return this.getParentMol().getAtom(value - 1);
    }

    @Override
    public boolean acceptsAne() {
        return true;
    }

    @Override
    protected void setDefaultBondLocants(LocantList l, int multiplicity) {
        if (multiplicity * 2 == this.length) {
            for (int i = 0; i < multiplicity; ++i) {
                l.tryAddLocant(new SimpleLocant(i * 2 + 1));
            }
        }
        if (multiplicity == 1) {
            l.tryAddLocant(Locant.One);
        }
    }
}

