/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.n2s.parse;

import chemaxon.naming.n2s.lex.data.Str;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;

public class EsterStr
extends Str {
    public EsterStr() {
        this.name = "Ester";
    }

    @Override
    public String getValue() {
        return "ester";
    }

    @Override
    public boolean isVal(String val) {
        return val.equals("ester");
    }

    @Override
    public Str cloneMe() {
        return null;
    }

    @Override
    public void generate() {
    }

    @Override
    public Molecule createParentMolecule() {
        Str acid = (Str)this.substituents.remove(this.substituents.size() - 1);
        if (acid.substituents != null) {
            for (Str sub : acid.substituents) {
                sub.setSpaceSeparated(false);
            }
        }
        if (this.substituents.size() == 1 && ((Str)this.substituents.get(0)).isYlene()) {
            return this.yleneEster(acid, (Str)this.substituents.get(0));
        }
        acid.getMolPublic();
        for (Str s : this.substituents) {
            s.setSpaceSeparated(true);
            s.mustBeEster = true;
            acid.connect(s);
            if (!s.isDangling()) continue;
            throw new RuntimeException("Dangling in ester");
        }
        return acid.getCompleteStructure();
    }

    private Molecule yleneEster(Str acid, Str ylene) {
        Str acid2 = acid.clone();
        Molecule acidM = acid.getMolPublic();
        MolAtom ox = acid.getEsterificationPoint();
        if (ox == null) {
            throw new RuntimeException("Cannot esterify " + acid);
        }
        Molecule acid2M = acid2.getMolPublic();
        MolAtom ox2 = acid2.getEsterificationPoint();
        if (ox2 == null) {
            throw new RuntimeException("Cannot esterify " + acid);
        }
        Molecule yleneM = ylene.getCompleteStructure();
        MolAtom radical1 = yleneM.getAtom(0);
        MolAtom radical2 = yleneM.getAtom(yleneM.getAtomCount() - 1);
        EsterStr.fuseCleared(acidM, yleneM);
        this.addSimpleBond(acidM, ox, radical1, 1);
        EsterStr.fuseCleared(acidM, acid2M);
        this.addSimpleBond(acidM, ox2, radical2, 1);
        return acidM;
    }
}

