/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.n2s.parse;

import chemaxon.naming.n2s.lex.data.Locant;
import chemaxon.naming.n2s.lex.data.Str;
import chemaxon.naming.n2s.lex.data.Token;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.PeriodicSystem;

public class HeteroAtomStr
extends Str {
    private int atno;
    private int charge;

    public static HeteroAtomStr create(Token t) {
        if (t instanceof HeteroAtomStr) {
            return ((HeteroAtomStr)t).cloneMe();
        }
        if (t.is("thi")) {
            return HeteroAtomStr.create("thi", "S");
        }
        return HeteroAtomStr.create(t.getName(), t.getValue());
    }

    public static HeteroAtomStr create(String name, String representation) {
        return new HeteroAtomStr(name, representation);
    }

    public HeteroAtomStr(String name, int atno) {
        super(name);
        this.atno = atno;
    }

    private HeteroAtomStr(String name, String representation) {
        super(name);
        if (representation.startsWith("[")) {
            representation = representation.substring(1, 3);
            this.atno = PeriodicSystem.getAtomicNumber(representation);
            return;
        }
        if (representation.endsWith("+")) {
            this.charge = 1;
            representation = representation.substring(0, representation.length() - 1);
        }
        this.atno = PeriodicSystem.getAtomicNumber(representation);
    }

    @Override
    public boolean isMonoAtomic() {
        return true;
    }

    @Override
    public boolean cannotBeParent() {
        return true;
    }

    protected String printValue() {
        return this.getValue();
    }

    @Override
    public HeteroAtomStr cloneMe() {
        return (HeteroAtomStr)this.clone();
    }

    public int getRadicalMultiplicity() {
        return 0;
    }

    public int getAtno() {
        return this.atno;
    }

    public int getCharge() {
        return this.charge;
    }

    public String getSymbol() {
        return PeriodicSystem.getSymbol(this.atno);
    }

    @Override
    protected MolAtom[] getConnectionPointInParent(Str str) {
        if (this.is("thia") || this.is("selena") || this.is("tellura")) {
            for (MolAtom a : str.parentAtoms()) {
                if (a.getAtno() != 8 || a.getBondCount() != 2) continue;
                return new MolAtom[]{a};
            }
        }
        return null;
    }

    @Override
    public Molecule createParentMolecule() {
        throw new RuntimeException("Should not happen");
    }

    @Override
    public MolAtom getAtomInCore(Locant l) {
        return null;
    }
}

