/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.n2s.parse;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public interface Modifier<Parent> {
    public boolean apply(Parent var1);

    public int priority();

    public static class Set<Parent>
    implements Cloneable {
        private ArrayList<Modifier<Parent>> unappliedModifiers = new ArrayList();
        private ArrayList<Modifier<Parent>> appliedModifiers = new ArrayList();
        private static final Comparator<Modifier> comp = new Comparator<Modifier>(){

            @Override
            public int compare(Modifier mod1, Modifier mod2) {
                return mod1.priority() - mod2.priority();
            }
        };

        public void add(Modifier<Parent> mod) {
            int where = Collections.binarySearch(this.unappliedModifiers, mod, comp);
            if (where < 0) {
                where = -where - 1;
            }
            this.unappliedModifiers.add(mod);
        }

        public void applyAll(Parent parent) {
            Iterator<Modifier<Parent>> it = this.unappliedModifiers.iterator();
            while (it.hasNext()) {
                Modifier<Parent> mod = it.next();
                if (!mod.apply(parent)) continue;
                it.remove();
                this.appliedModifiers.add(mod);
            }
        }

        public <T extends Modifier<Parent>> List<T> getUnapplied(Class<T> class1) {
            ArrayList<Modifier<Parent>> res = new ArrayList<Modifier<Parent>>();
            for (Modifier<Parent> mod : this.unappliedModifiers) {
                if (!class1.isInstance(mod)) continue;
                res.add(mod);
            }
            return res;
        }

        public <T extends Modifier<Parent>> List<T> getAll(Class<T> class1) {
            ArrayList<Modifier<Parent>> res = new ArrayList<Modifier<Parent>>();
            for (Modifier<Parent> mod : this.unappliedModifiers) {
                if (!class1.isInstance(mod)) continue;
                res.add(mod);
            }
            for (Modifier<Parent> mod : this.appliedModifiers) {
                if (!class1.isInstance(mod)) continue;
                res.add(mod);
            }
            return res;
        }

        public Set<Parent> clone() {
            try {
                Set res = (Set)super.clone();
                res.unappliedModifiers = new ArrayList<Modifier<Parent>>(this.unappliedModifiers);
                res.appliedModifiers = new ArrayList<Modifier<Parent>>(this.appliedModifiers);
                return res;
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

