/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.n2s.parse;

import chemaxon.common.util.IntVector;
import chemaxon.marvin.io.formats.name.nameexport.Chem;
import chemaxon.naming.n2s.UtilLegacy;
import chemaxon.naming.n2s.lex.data.LocantList;
import chemaxon.naming.n2s.lex.data.RingNumber;
import chemaxon.naming.n2s.lex.data.Str;
import chemaxon.naming.n2s.parse.RingUtil;
import chemaxon.naming.n2s.parse.StructureLegacy;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.PeriodicSystem;

public class MonoCyclicSpiroSytem
extends Str {
    protected LocantList numbering;
    protected int atom;
    protected int atom2 = -1;

    public MonoCyclicSpiroSytem(LocantList numbering, int atom) {
        this(numbering, atom, -1);
    }

    public MonoCyclicSpiroSytem(LocantList numbering, int atom, int atom2) {
        this.name = "spiro";
        this.numbering = numbering;
        this.atom = atom;
        this.atom2 = atom2;
    }

    @Override
    public boolean isCyclic() {
        return true;
    }

    public LocantList getNumbering() {
        return this.numbering;
    }

    public int getAtom2() {
        return this.atom2;
    }

    protected String printValue() {
        String atom2 = this.atom2 == 1 ? "" : " " + this.atom2;
        return '\"' + this.numbering.toString() + " " + this.atom + atom2 + '\"';
    }

    @Override
    public Molecule createParentMolecule() {
        Molecule res = StructureLegacy.readMol(this.toSmiles());
        for (MolAtom a : res.getAtomArray()) {
            a.setValenceProp(-1);
        }
        return res;
    }

    protected String toSmiles() {
        String atom2;
        String smiles = "";
        String atom = PeriodicSystem.getSymbol(this.atom);
        if (atom.length() == 2) {
            int valence = Chem.standardValence(this.atom) - 1;
            atom = "[" + atom + "H" + valence + "]";
        }
        String string = atom2 = this.atom2 == -1 ? null : PeriodicSystem.getSymbol(this.atom2);
        if (atom2 != null && atom2.length() == 2) {
            int valence = Chem.standardValence(this.atom2) - 1;
            atom2 = "[" + atom2 + "H" + valence + "]";
        }
        if (this.numbering.size() == 2) {
            smiles = this.getSimpleRing(this.numbering, atom, atom2);
        } else if (this.numbering.size() > 2) {
            smiles = this.getComplexRing(this.numbering, atom, atom2);
        }
        return smiles;
    }

    private String getSimpleRing(LocantList numbering, String atom, String atom2) {
        int i;
        int num2;
        int num1 = numbering.getLocant(0).getValue();
        if (num1 > (num2 = numbering.getLocant(1).getValue())) {
            int tmp = num1;
            num1 = num2;
            num2 = tmp;
        }
        String chain = atom + "1";
        if (atom2 == null) {
            for (i = 0; i < num1; ++i) {
                chain = chain + atom;
            }
            chain = chain + "12";
            for (i = 0; i < num2; ++i) {
                chain = chain + atom;
            }
            chain = chain + "2";
        } else {
            for (i = 0; i < num1; ++i) {
                chain = chain + (i % 2 == 0 ? atom2 : atom);
            }
            chain = chain + "12";
            for (i = 0; i < num2; ++i) {
                chain = chain + ((num1 + i) % 2 == 0 ? atom2 : atom);
            }
            chain = chain + "2";
        }
        chain = chain + " |$";
        for (i = 1; i <= num1 + num2 + 1; ++i) {
            if (i > 1) {
                chain = chain + ";";
            }
            chain = chain + i;
        }
        chain = chain + "$|";
        return chain;
    }

    private String getComplexRing(LocantList numbering, String atom, String atom2) {
        IntVector atomnumbers = new IntVector();
        this.fixMissingExponents(numbering);
        String retVal = atom2 != null ? this.build(numbering, atom, atom2, atomnumbers) : this.build(numbering, atom, atomnumbers);
        retVal = retVal + " |$";
        for (int i = 0; i < atomnumbers.size(); ++i) {
            if (i > 0) {
                retVal = retVal + ";";
            }
            retVal = retVal + atomnumbers.get(i);
        }
        retVal = retVal + "$|";
        return retVal;
    }

    private String build(LocantList numbering, String atom, IntVector atomnumbers) {
        StringBuffer retVal = new StringBuffer();
        int locant = 0;
        int tmploc = 0;
        int ringIndex = 0;
        for (int i = 0; i < numbering.size(); ++i) {
            RingNumber ringnum = (RingNumber)numbering.getLocant(i);
            if (ringnum.getFirst() == 0) {
                this.realign(retVal, tmploc);
                for (int j = 0; j <= ringnum.getValue(); ++j) {
                    RingUtil.appendAtom(retVal, atomnumbers, atom, ++locant);
                }
                tmploc = locant;
                continue;
            }
            RingUtil.appendBridge(retVal, atomnumbers, tmploc, ringnum.getFirst(), ringnum.getValue(), ++ringIndex, atom, ++locant);
            locant += ringnum.getValue() - 1;
            tmploc = ringnum.getFirst();
        }
        RingUtil.appendBridge(retVal, atomnumbers, 1, numbering.getLocant(0).getValue() + 1, 0, ++ringIndex, atom, 0);
        return retVal.toString();
    }

    private String build(LocantList numbering, String atom1, String atom2, IntVector atomnumbers) {
        StringBuffer retVal = new StringBuffer();
        int locant = 0;
        int tmploc = 0;
        int shift = 0;
        int sh = 0;
        int ringIndex = 0;
        String[] atoms = new String[]{atom2, atom1};
        for (int i = 0; i < numbering.size(); ++i) {
            RingNumber ringnum = (RingNumber)numbering.getLocant(i);
            if (ringnum.getFirst() == 0) {
                this.realign(retVal, tmploc);
                for (int j = 0; j <= ringnum.getValue(); ++j) {
                    RingUtil.appendAtom(retVal, atomnumbers, atoms[sh++ % 2], ++locant);
                }
                tmploc = locant;
                continue;
            }
            RingUtil.appendBridge(retVal, atomnumbers, tmploc, ringnum.getFirst(), ringnum.getValue(), ++ringIndex, atoms, ++locant, sh % 2);
            locant += ringnum.getValue() - 1;
            tmploc = ringnum.getFirst();
        }
        String tmp = retVal.substring(0, numbering.getLocant(0).getValue() + 1);
        shift = tmp.indexOf(atom1) > tmp.indexOf(atom2) ? 1 : 0;
        RingUtil.appendBridge(retVal, atomnumbers, 1, numbering.getLocant(0).getValue() + 1, 0, ++ringIndex, atoms, 0, shift);
        return retVal.toString();
    }

    private void realign(StringBuffer strbuff, int atomnumber) {
        int pos = UtilLegacy.getLastIndexOfElement(strbuff.toString(), atomnumber);
        if (pos < strbuff.length() - 1 && pos > 0) {
            strbuff.insert(pos + 1, '(').append(')');
        }
    }

    private void fixMissingExponents(LocantList numbering) {
        if (numbering.size() != 4) {
            return;
        }
        RingNumber third = (RingNumber)numbering.getLocant(2);
        if (third.getFirst() > 0) {
            return;
        }
        RingNumber first = (RingNumber)numbering.getLocant(0);
        RingNumber second = (RingNumber)numbering.getLocant(1);
        RingNumber fourth = (RingNumber)numbering.getLocant(3);
        third.setFirst(first.getValue() + second.getValue() + 2);
        fourth.setFirst(first.getValue() + 1);
    }

    @Override
    public Str cloneMe() {
        return this.clone();
    }
}

