/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.n2s.parse;

import chemaxon.naming.n2s.NameImportException;
import chemaxon.naming.n2s.Util;
import chemaxon.naming.n2s.lex.data.ComplexLocant;
import chemaxon.naming.n2s.lex.data.LocantList;
import chemaxon.naming.n2s.lex.data.SimpleLocant;
import chemaxon.naming.n2s.lex.data.Str;
import chemaxon.naming.n2s.parse.RingUtil;
import chemaxon.naming.n2s.parse.SpiroStr;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import java.util.ArrayList;

public class MultipliedSpiroStr
extends SpiroStr {
    protected Str structure;
    protected LocantList locants;

    public MultipliedSpiroStr(Str structure, int mul, LocantList complexLocants) {
        this.name = "spiro";
        this.structure = structure;
        this.structure.setParent(this);
        this.locants = complexLocants;
        this.structures = new ArrayList();
        for (int i = 0; i < mul; ++i) {
            this.structures.add(structure.cloneMe());
        }
    }

    @Override
    public Molecule createParentMolecule() {
        Molecule mol = Util.newMolecule();
        this.setMol(mol);
        if (this.locants.getType() == 12) {
            for (int i = 0; i < this.locants.size(); ++i) {
                mol.fuse(((Str)this.structures.get(i)).getMolPublic());
            }
            this.connectWithSimpleLocant(mol);
        } else if (this.locants.getType() == 3) {
            for (int i = 0; i < RingUtil.getMaxParent(this.locants) + 1; ++i) {
                mol.fuse(((Str)this.structures.get(i)).getMolPublic());
            }
            this.connectWithComplexLocant(mol);
        } else {
            throw new NameImportException("Invalid numbering: " + this.locants);
        }
        return mol;
    }

    protected void connectWithComplexLocant(Molecule mol) {
        for (int i = 0; i < this.locants.size(); ++i) {
            SimpleLocant first = ((ComplexLocant)this.locants.getLocant(i)).getFirstLocant();
            SimpleLocant second = ((ComplexLocant)this.locants.getLocant(i)).getSecondLocant();
            MolAtom atom1 = this.getAtom(first);
            MolAtom atom2 = this.getAtom(second);
            this.createConnection(mol, atom1, atom2);
        }
    }

    protected void connectWithSimpleLocant(Molecule mol) {
        SimpleLocant basiclocant = (SimpleLocant)this.locants.getLocant(0);
        Str s = (Str)this.structures.get(basiclocant.getParent());
        MolAtom basicatom = s.getAtom(MultipliedSpiroStr.noPrimes(basiclocant));
        for (int i = 1; i < this.locants.size(); ++i) {
            SimpleLocant locant = (SimpleLocant)this.locants.getLocant(i);
            MolAtom atom = this.getAtom(locant);
            this.createConnection(mol, basicatom, atom);
            if (mol.contains(basicatom)) continue;
            basicatom = atom;
        }
    }

    protected void createConnection(Molecule mol, MolAtom basicatom, MolAtom atom) {
        this.mergeAtoms(atom, basicatom);
    }

    @Override
    public Str cloneMe() {
        return this.clone();
    }
}

