/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.n2s.parse;

import chemaxon.naming.n2s.Util;
import chemaxon.naming.n2s.lex.data.LocantList;
import chemaxon.naming.n2s.lex.data.Str;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;

public class MultipliedSystemStr
extends Str {
    private Str single;
    private int multiplier;
    private LocantList locants;

    public MultipliedSystemStr(int multiplier, Str single, LocantList locants) {
        this.name = "MultipliedSystemStr";
        this.multiplier = multiplier;
        this.single = single;
        this.locants = locants;
    }

    @Override
    public boolean isCyclic() {
        return true;
    }

    @Override
    public Str cloneMe() {
        return null;
    }

    @Override
    public Molecule createParentMolecule() {
        Molecule one = this.single.getMolPublic();
        Molecule res = one.cloneMolecule();
        for (int i = 1; i < this.multiplier; ++i) {
            Molecule cur = this.createPrimedVersion(one, i);
            res.fuse(cur);
        }
        return res;
    }

    @Override
    public void generate() {
        if (this.locants != null) {
            if (this.locants.size() != 2) {
                throw new RuntimeException("Not implemented");
            }
            MolAtom a0 = this.getAtom(this.locants.getLocant(0));
            MolAtom a1 = this.getAtom(this.locants.getLocant(1));
            Util.addBond(this.getParentMol(), new MolBond(a0, a1));
        }
        super.generate();
    }

    private Molecule createPrimedVersion(Molecule one, int i) {
        String primes = "";
        while (i-- > 0) {
            primes = primes + "'";
        }
        Molecule res = one.cloneMolecule();
        for (MolAtom a : res.getAtomArray()) {
            String[] locants = this.getLocants(a);
            if (locants == null) continue;
            this.setLocant(a, null);
            for (String locant : locants) {
                this.addLocant(a, locant + primes);
            }
        }
        return res;
    }
}

