/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.n2s.parse;

import chemaxon.naming.n2s.NameImportException;
import chemaxon.naming.n2s.Util;
import chemaxon.naming.n2s.lex.data.ComplexLocant;
import chemaxon.naming.n2s.lex.data.LocantList;
import chemaxon.naming.n2s.lex.data.SimpleLocant;
import chemaxon.naming.n2s.lex.data.Str;
import chemaxon.naming.n2s.parse.SpiroStr;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import java.util.ArrayList;

public class PolyCyclicSpiroSystem
extends SpiroStr {
    protected LocantList locants;
    protected ArrayList<Molecule> moleculeList = new ArrayList();

    public PolyCyclicSpiroSystem(ArrayList<Str> structures, LocantList complexLocants) {
        this.name = "Spiro";
        this.structures = structures;
        this.setParent(this.structures);
        this.locants = complexLocants;
    }

    public ArrayList<Str> getAllStructures() {
        return this.structures;
    }

    public LocantList getLocants() {
        return this.locants;
    }

    @Override
    public Molecule createParentMolecule() {
        int i;
        Molecule mol = Util.newMolecule();
        this.setMol(mol);
        this.moleculeList = new ArrayList();
        for (i = 0; i < this.structures.size(); ++i) {
            this.moleculeList.add(((Str)this.structures.get(i)).getCompleteStructure());
        }
        for (i = 0; i < this.structures.size(); ++i) {
            mol.fuse(this.moleculeList.get(i));
        }
        if (this.locants.getType() == 12) {
            for (i = 0; i < this.locants.size(); i += 2) {
                SimpleLocant locant = (SimpleLocant)this.locants.getLocant(i);
                MolAtom atom1 = ((Str)this.structures.get(i)).getAtom(PolyCyclicSpiroSystem.noPrimes(locant));
                locant = (SimpleLocant)this.locants.getLocant(i + 1);
                MolAtom atom2 = ((Str)this.structures.get(i + 1)).getAtom(PolyCyclicSpiroSystem.noPrimes(locant));
                this.mergeAtoms(atom1, atom2);
            }
        } else if (this.locants.getType() == 3) {
            for (i = 0; i < this.locants.size(); ++i) {
                SimpleLocant first = ((ComplexLocant)this.locants.getLocant(i)).getFirstLocant();
                SimpleLocant second = ((ComplexLocant)this.locants.getLocant(i)).getSecondLocant();
                MolAtom atom1 = this.getAtom(first);
                MolAtom atom2 = this.getAtom(second);
                this.mergeAtoms(atom1, atom2);
            }
        } else {
            throw new NameImportException("Invalid numbering: " + this.locants);
        }
        return mol;
    }

    private void setParent(ArrayList<Str> strucList) {
        for (int i = 0; i < strucList.size(); ++i) {
            strucList.get(i).setParent(this);
        }
    }

    @Override
    public Str cloneMe() {
        return this.clone();
    }
}

